/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.File;

public final class ClassInfo {
    private final ArgType type;
    private String pkg;
    private String name;
    private String fullName;
    private ClassInfo parentClass;
    private ClassInfo alias;

    private ClassInfo(RootNode root, ArgType type) {
        this(root, type, true);
    }

    private ClassInfo(RootNode root, ArgType type, boolean inner) {
        if (!type.isObject() || type.isGeneric()) {
            throw new JadxRuntimeException("Not class type: " + type);
        }
        this.type = type;
        this.alias = this;
        this.splitNames(root, inner);
    }

    public static ClassInfo fromType(RootNode root, ArgType type) {
        ClassInfo cls;
        if (type.isArray()) {
            type = ArgType.OBJECT;
        }
        if ((cls = root.getInfoStorage().getCls(type)) != null) {
            return cls;
        }
        cls = new ClassInfo(root, type);
        return root.getInfoStorage().putCls(cls);
    }

    public static ClassInfo fromDex(DexNode dex, int clsIndex) {
        if (clsIndex == -1) {
            return null;
        }
        return ClassInfo.fromType(dex.root(), dex.getType(clsIndex));
    }

    public static ClassInfo fromName(RootNode root, String clsName) {
        return ClassInfo.fromType(root, ArgType.object(clsName));
    }

    public static ClassInfo extCls(RootNode root, ArgType type) {
        ClassInfo classInfo = ClassInfo.fromName(root, type.getObject());
        return classInfo.alias;
    }

    public void rename(RootNode root, String fullName) {
        ClassInfo newAlias = new ClassInfo(root, ArgType.object(fullName), this.isInner());
        if (!this.alias.getFullName().equals(newAlias.getFullName())) {
            this.alias = newAlias;
        }
    }

    public boolean isRenamed() {
        return this.alias != this;
    }

    public ClassInfo getAlias() {
        return this.alias;
    }

    private void splitNames(RootNode root, boolean canBeInner) {
        String clsName;
        String fullObjectName = this.type.getObject();
        int dot = fullObjectName.lastIndexOf(46);
        if (dot == -1) {
            this.pkg = "";
            clsName = fullObjectName;
        } else {
            this.pkg = fullObjectName.substring(0, dot);
            clsName = fullObjectName.substring(dot + 1);
        }
        int sep = clsName.lastIndexOf(36);
        if (canBeInner && sep > 0 && sep != clsName.length() - 1) {
            String parClsName = this.pkg + "." + clsName.substring(0, sep);
            if (this.pkg.isEmpty()) {
                parClsName = clsName.substring(0, sep);
            }
            this.parentClass = ClassInfo.fromName(root, parClsName);
            clsName = clsName.substring(sep + 1);
        } else {
            this.parentClass = null;
        }
        this.name = clsName;
        this.fullName = this.makeFullClsName(clsName, false);
    }

    public String makeFullClsName(String shortName, boolean raw) {
        if (this.parentClass != null) {
            String innerSep = raw ? "$" : ".";
            return this.parentClass.makeFullClsName(this.parentClass.getShortName(), raw) + innerSep + shortName;
        }
        return this.pkg.isEmpty() ? shortName : this.pkg + "." + shortName;
    }

    public String getFullPath() {
        ClassInfo usedAlias = this.getAlias();
        return usedAlias.getPackage().replace('.', File.separatorChar) + File.separatorChar + usedAlias.getNameWithoutPackage().replace('.', '_');
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getShortName() {
        return this.name;
    }

    public String getPackage() {
        return this.pkg;
    }

    public boolean isDefaultPackage() {
        return this.pkg.isEmpty();
    }

    public String getRawName() {
        return this.type.getObject();
    }

    public String getNameWithoutPackage() {
        if (this.parentClass == null) {
            return this.name;
        }
        return this.parentClass.getNameWithoutPackage() + "." + this.name;
    }

    public ClassInfo getParentClass() {
        return this.parentClass;
    }

    public ClassInfo getTopParentClass() {
        if (this.parentClass != null) {
            ClassInfo topCls = this.parentClass.getTopParentClass();
            return topCls != null ? topCls : this.parentClass;
        }
        return null;
    }

    public boolean isInner() {
        return this.parentClass != null;
    }

    public void notInner(RootNode root) {
        this.splitNames(root, false);
    }

    public ArgType getType() {
        return this.type;
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClassInfo) {
            ClassInfo other = (ClassInfo)obj;
            return this.type.equals(other.type);
        }
        return false;
    }
}

