/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.xmlgen.entry.ResourceEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceStorage {
    private final List<ResourceEntry> list = new ArrayList<ResourceEntry>();
    private String appPackage;

    public Collection<ResourceEntry> getResources() {
        return this.list;
    }

    public void add(ResourceEntry ri) {
        this.list.add(ri);
    }

    public void finish() {
        this.list.sort(Comparator.comparingInt(ResourceEntry::getId));
    }

    public ResourceEntry getByRef(int refId) {
        ResourceEntry key = new ResourceEntry(refId);
        int index = Collections.binarySearch(this.list, key, Comparator.comparingInt(ResourceEntry::getId));
        if (index < 0) {
            return null;
        }
        return this.list.get(index);
    }

    public String getAppPackage() {
        return this.appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public Map<Integer, String> getResourcesNames() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (ResourceEntry entry : this.list) {
            map.put(entry.getId(), entry.getTypeName() + "/" + entry.getKeyName());
        }
        return map;
    }
}

