/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.osgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import lucee.loader.engine.CFMLEngineFactory;
import lucee.loader.engine.CFMLEngineFactorySupport;
import lucee.loader.osgi.BundleCollection;
import lucee.loader.osgi.BundleUtil;
import lucee.loader.util.Util;
import org.apache.felix.framework.Felix;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundleLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleCollection loadBundles(CFMLEngineFactory engFac, File cacheRootDir, File jarDirectory, File rc, BundleCollection old) throws IOException, BundleException {
        JarFile jf = new JarFile(rc);
        try {
            File f;
            String id;
            Felix felix;
            Manifest mani = jf.getManifest();
            if (mani == null) {
                throw new IOException("lucee core [" + rc + "] is invalid, there is no META-INF/MANIFEST.MF File");
            }
            Attributes attrs = mani.getMainAttributes();
            Properties defProp = BundleLoader.loadDefaultProperties(jf);
            HashMap<String, Object> config = new HashMap<String, Object>();
            for (Map.Entry<Object, Object> e : defProp.entrySet()) {
                String k = (String)e.getKey();
                if (!k.startsWith("org.") && !k.startsWith("felix.")) continue;
                config.put(k, CFMLEngineFactorySupport.removeQuotes((String)e.getValue(), true));
            }
            if (old != null) {
                BundleLoader.removeBundlesEL(old);
                felix = old.felix;
                BundleUtil.stop(felix, false);
                felix = engFac.getFelix(cacheRootDir, config);
            } else {
                felix = engFac.getFelix(cacheRootDir, config);
            }
            BundleContext bc = felix.getBundleContext();
            String rb = attrs.getValue("Require-Bundle");
            if (Util.isEmpty(rb)) {
                throw new IOException("lucee core [" + rc + "] is invalid, no Require-Bundle defintion found in the META-INF/MANIFEST.MF File");
            }
            String rbf = attrs.getValue("Require-Bundle-Fragment");
            Map<String, String> requiredBundles = BundleLoader.readRequireBundle(rb);
            Map<String, String> requiredBundleFragments = BundleLoader.readRequireBundle(rbf);
            Map<String, File> availableBundles = BundleLoader.loadAvailableBundles(jarDirectory);
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            for (Map.Entry<String, String> e : requiredBundles.entrySet()) {
                id = e.getKey() + "|" + e.getValue();
                f = availableBundles.get(id);
                if (f == null) {
                    // empty if block
                }
                if (f == null) {
                    f = engFac.downloadBundle(e.getKey(), e.getValue(), null);
                }
                bundles.add(BundleUtil.addBundle(engFac, bc, f, null));
            }
            ArrayList<Bundle> fragments = new ArrayList<Bundle>();
            for (Map.Entry<String, String> e : requiredBundleFragments.entrySet()) {
                id = e.getKey() + "|" + e.getValue();
                f = availableBundles.get(id);
                if (f == null) {
                    f = engFac.downloadBundle(e.getKey(), e.getValue(), null);
                }
                fragments.add(BundleUtil.addBundle(engFac, bc, f, null));
            }
            Bundle bundle = BundleUtil.addBundle(engFac, bc, rc, null);
            BundleUtil.start(engFac, bundles);
            BundleUtil.start(engFac, bundle);
            BundleCollection bundleCollection = new BundleCollection(felix, bundle, bundles);
            return bundleCollection;
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Map<String, File> loadAvailableBundles(File jarDirectory) {
        HashMap<String, File> rtn = new HashMap<String, File>();
        File[] jars = jarDirectory.listFiles();
        if (jars != null) {
            for (int i = 0; i < jars.length; ++i) {
                if (!jars[i].isFile() || !jars[i].getName().endsWith(".jar")) continue;
                try {
                    rtn.put(BundleLoader.loadBundleInfo(jars[i]), jars[i]);
                    continue;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadBundleInfo(File jar) throws IOException {
        JarFile jf = new JarFile(jar);
        try {
            Attributes attrs = jf.getManifest().getMainAttributes();
            String symbolicName = attrs.getValue("Bundle-SymbolicName");
            String version = attrs.getValue("Bundle-Version");
            if (Util.isEmpty(symbolicName)) {
                throw new IOException("OSGi bundle [" + jar + "] is invalid, {Lucee-Core}META-INF/MANIFEST.MF does not contain a \"Bundle-SymbolicName\"");
            }
            if (Util.isEmpty(version)) {
                throw new IOException("OSGi bundle [" + jar + "] is invalid, {Lucee-Core}META-INF/MANIFEST.MF does not contain a \"Bundle-Version\"");
            }
            String string = symbolicName + "|" + version;
            return string;
        }
        finally {
            Util.closeEL(jf);
        }
    }

    private static Map<String, String> readRequireBundle(String rb) throws IOException {
        HashMap<String, String> rtn = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(rb, ",");
        String jarVersion = null;
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            if (Util.isEmpty(line)) continue;
            StringTokenizer stl = new StringTokenizer(line, ";");
            String jarName = stl.nextToken().trim();
            while (stl.hasMoreTokens()) {
                int index;
                String token = stl.nextToken().trim();
                if (!token.startsWith("bundle-version") || (index = token.indexOf(61)) == -1) continue;
                jarVersion = token.substring(index + 1).trim();
            }
            if (jarVersion == null) {
                throw new IOException("missing \"bundle-version\" info in the following \"Require-Bundle\" record: \"" + jarName + "\"");
            }
            rtn.put(jarName, jarVersion);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadDefaultProperties(JarFile jf) throws IOException {
        ZipEntry ze = jf.getEntry("default.properties");
        if (ze == null) {
            throw new IOException("the Lucee core has no default.properties file!");
        }
        Properties prop = new Properties();
        InputStream is = null;
        try {
            is = jf.getInputStream(ze);
            prop.load(is);
        }
        finally {
            CFMLEngineFactorySupport.closeEL(is);
        }
        return prop;
    }

    public static void removeBundles(BundleContext bc) throws BundleException {
        Bundle[] bundles;
        for (Bundle bundle : bundles = bc.getBundles()) {
            BundleLoader.removeBundle(bundle);
        }
    }

    public static void removeBundles(BundleCollection bc) throws BundleException {
        Bundle[] bundles;
        BundleContext bcc = bc.getBundleContext();
        for (Bundle bundle : bundles = bcc == null ? new Bundle[]{} : bcc.getBundles()) {
            if (BundleUtil.isSystemBundle(bundle)) continue;
            BundleLoader.stopBundle(bundle);
        }
        for (Bundle bundle : bundles) {
            if (BundleUtil.isSystemBundle(bundle)) continue;
            BundleLoader.uninstallBundle(bundle);
        }
    }

    public static void removeBundlesEL(BundleCollection bc) {
        Bundle[] bundles;
        BundleContext bcc = bc.getBundleContext();
        for (Bundle bundle : bundles = bcc == null ? new Bundle[]{} : bcc.getBundles()) {
            if (BundleUtil.isSystemBundle(bundle)) continue;
            try {
                BundleLoader.stopBundle(bundle);
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
        for (Bundle bundle : bundles) {
            if (BundleUtil.isSystemBundle(bundle)) continue;
            try {
                BundleLoader.uninstallBundle(bundle);
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
    }

    public static void removeBundle(Bundle bundle) throws BundleException {
        BundleLoader.stopBundle(bundle);
        BundleLoader.uninstallBundle(bundle);
    }

    public static void uninstallBundle(Bundle bundle) throws BundleException {
        if (bundle == null) {
            return;
        }
        if (bundle.getState() == 32 || bundle.getState() == 8 || bundle.getState() == 16) {
            BundleLoader.stopBundle(bundle);
        }
        if (bundle.getState() != 1) {
            bundle.uninstall();
        }
    }

    public static void stopBundle(Bundle bundle) throws BundleException {
        if (bundle == null) {
            return;
        }
        int sleept = 0;
        while (bundle.getState() == 16 || bundle.getState() == 8) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                break;
            }
            if ((sleept += 10) <= 5000) continue;
        }
        if (bundle.getState() == 32 || bundle.getState() == 8) {
            BundleUtil.stop(bundle, false);
        }
    }
}

