/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.auth;

import java.util.Arrays;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.exception.RadiusException;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.util.RadiusUtils;

public class PAPAuthenticator
extends RadiusAuthenticator {
    public static final String NAME = "pap";

    public String getAuthName() {
        return NAME;
    }

    public void processRequest(RadiusPacket p) throws RadiusException {
        if (this.password == null) {
            throw new RadiusException("no password given");
        }
        p.removeAttribute(this.password);
        RadiusAttribute attr = AttributeFactory.newAttribute("User-Password");
        p.addAttribute(attr);
        attr.setValue(RadiusUtils.encodePapPassword(this.password.getValue().getBytes(), p.createAuthenticator(null, 0, 0, this.client.getSharedSecret()), this.client.getSharedSecret()));
    }

    public static boolean verifyPassword(byte[] userPassword, byte[] requestAuthenticator, byte[] clearText, String sharedSecret) {
        byte[] pw = RadiusUtils.encodePapPassword(clearText, requestAuthenticator, sharedSecret);
        return Arrays.equals(pw, userPassword);
    }
}

