/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.spdy.SpdyHeader;
import org.glassfish.grizzly.spdy.SpdyResponse;
import org.glassfish.grizzly.spdy.SpdyStream;

class SpdyRequest
extends HttpRequestPacket
implements SpdyHeader {
    private static final Logger LOGGER = Grizzly.logger(SpdyRequest.class);
    private static final ThreadCache.CachedTypeIndex<SpdyRequest> CACHE_IDX = ThreadCache.obtainIndex(SpdyRequest.class, 2);
    private final ProcessingState processingState = new ProcessingState();
    private final SpdyResponse spdyResponse;
    private boolean contentTypeParsed;

    public static SpdyRequest create() {
        SpdyRequest spdyRequest = ThreadCache.takeFromCache(CACHE_IDX);
        if (spdyRequest == null) {
            spdyRequest = new SpdyRequest();
        }
        return spdyRequest.init();
    }

    SpdyRequest() {
        this.spdyResponse = new SpdyResponse();
    }

    SpdyRequest(SpdyResponse spdyResponse) {
        this.spdyResponse = spdyResponse;
    }

    @Override
    public ProcessingState getProcessingState() {
        return this.processingState;
    }

    private SpdyRequest init() {
        this.setResponse(this.spdyResponse);
        this.spdyResponse.setRequest(this);
        this.setChunkingAllowed(true);
        this.spdyResponse.setChunkingAllowed(true);
        return this;
    }

    @Override
    public SpdyStream getSpdyStream() {
        return SpdyStream.getSpdyStream(this);
    }

    @Override
    public String getCharacterEncoding() {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        return super.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String charset) {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        super.setCharacterEncoding(charset);
    }

    @Override
    public String getContentType() {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        return super.getContentType();
    }

    private void parseContentTypeHeader() {
        DataChunk dc;
        this.contentTypeParsed = true;
        if (!this.contentType.isSet() && (dc = this.headers.getValue(Header.ContentType)) != null && !dc.isNull()) {
            this.setContentType(dc.toString());
        }
    }

    @Override
    public Object getAttribute(String name) {
        if (SpdyStream.SPDY_STREAM_ATTRIBUTE.equals(name)) {
            return this.spdyResponse.getSpdyStream();
        }
        return super.getAttribute(name);
    }

    @Override
    protected void reset() {
        this.contentTypeParsed = false;
        this.processingState.recycle();
        super.reset();
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public void setExpectContent(boolean isExpectContent) {
        super.setExpectContent(isExpectContent);
    }

    @Override
    protected void requiresAcknowledgement(boolean requiresAcknowledgement) {
        super.requiresAcknowledgement(requiresAcknowledgement);
    }
}

