/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import org.postgresql.PGProperty;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.v2.ConnectionFactoryImpl;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class ConnectionFactory {
    private static final Object[][] versions = new Object[][]{{"3", new org.postgresql.core.v3.ConnectionFactoryImpl()}, {"2", new ConnectionFactoryImpl()}};

    public static ProtocolConnection openConnection(HostSpec[] hostSpecs, String user, String database, Properties info, Logger logger2) throws SQLException {
        String protoName = PGProperty.PROTOCOL_VERSION.get(info);
        for (Object[] version : versions) {
            ConnectionFactory factory;
            ProtocolConnection connection;
            String versionProtoName = (String)version[0];
            if (protoName != null && !protoName.equals(versionProtoName) || (connection = (factory = (ConnectionFactory)version[1]).openConnectionImpl(hostSpecs, user, database, info, logger2)) == null) continue;
            return connection;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract ProtocolConnection openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4, Logger var5) throws SQLException;

    protected void closeStream(PGStream newStream) {
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

