/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.contour;

import com.projity.configuration.CalculationPreference;
import com.projity.pm.assignment.contour.AbstractContourBucket;
import java.io.Serializable;

public class PersonalContourBucket
extends AbstractContourBucket
implements Serializable {
    static final long serialVersionUID = 99779271628737L;
    private long duration = 0L;

    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getBucketDuration(long l) {
        return this.duration;
    }

    protected PersonalContourBucket(long l, double d) {
        this.duration = l;
        this.units = d;
    }

    public static PersonalContourBucket getInstance(long l, double d) {
        if (l < 0L) {
            System.out.println("bug negative bucket");
        }
        return new PersonalContourBucket(l, d);
    }

    private PersonalContourBucket(AbstractContourBucket abstractContourBucket, long l) {
        this.duration = abstractContourBucket.getBucketDuration(l);
        this.units = abstractContourBucket.getUnits();
    }

    @Override
    public double getEffectiveUnits(double d) {
        return this.units;
    }

    public PersonalContourBucket(PersonalContourBucket personalContourBucket) {
        this(personalContourBucket.duration, personalContourBucket.units);
    }

    public long calcWork() {
        return (long)(this.units * (double)this.duration);
    }

    public String toString() {
        return "[duration] " + this.duration / 3600000L + "h\n[units] " + this.units;
    }

    @Override
    public double weightedSum() {
        return this.units * (double)this.duration;
    }

    public PersonalContourBucket adjustUnits(double d) {
        return new PersonalContourBucket(this.duration, this.units * d);
    }

    public PersonalContourBucket adjustWork(double d) {
        if (!CalculationPreference.getActive().isNonWorkContourPeriodsStayFixedLength() || this.units != 0.0) {
            return new PersonalContourBucket((long)((double)this.duration * d), this.units / d);
        }
        return this;
    }

    public PersonalContourBucket adjustDuration(long l) {
        return new PersonalContourBucket(this.duration + l, this.units);
    }

    public static PersonalContourBucket getInstance(AbstractContourBucket abstractContourBucket, long l) {
        return new PersonalContourBucket(abstractContourBucket, l);
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

