/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet;

import com.projity.field.Field;
import com.projity.pm.graphic.Renderer;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParams;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParamsImpl;
import com.projity.pm.graphic.spreadsheet.SpreadSheetUtils;
import com.projity.pm.graphic.spreadsheet.renderer.OfflineRenderer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.table.TableColumn;

public class SpreadSheetRenderer
extends Renderer {
    protected SpreadSheetParams params;
    private int idColMargin = 2;
    private int colMargin = 2;
    private int idColumnIndex = 0;

    public SpreadSheetRenderer(GraphParams graphParams) {
        super(graphParams);
        this.params = (SpreadSheetParams)graphParams;
    }

    public SpreadSheetRenderer() {
    }

    @Override
    public void paint(Graphics graphics) {
        this.paint(graphics, -1, -1);
    }

    public void paint(Graphics graphics, int n, int n2) {
        Object object;
        Object object2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n3 = this.params.getSpreadSheetBounds().y;
        int n4 = this.params.getRowHeight();
        int n5 = 0;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        int n8 = Integer.MAX_VALUE;
        Rectangle rectangle = this.params.getSpreadSheetBounds();
        if (n != -1) {
            SpreadSheetParamsImpl.PageInfo pageInfo = this.params.getColPageInfo(n2);
            object2 = this.params.getRowPageInfo(n);
            n7 = pageInfo.getStart();
            n8 = pageInfo.getEnd();
            n5 = ((SpreadSheetParamsImpl.PageInfo)object2).getStart();
            n6 = ((SpreadSheetParamsImpl.PageInfo)object2).getEnd();
            object = ((SpreadSheetParamsImpl)this.params).getSpreadsheetPrintBounds(n, n2, false);
            rectangle = new Rectangle(rectangle.x, rectangle.y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
        object2 = this.graphInfo.getCache().getIterator(n5);
        for (int i = n5; object2.hasNext() && i <= n6; ++i) {
            object = (GraphicNode)object2.next();
            this.paintRow(graphics2D, i, n5, n3, n7, n8, (GraphicNode)object, rectangle);
            n3 += n4;
        }
        this.paintColumnHeader(graphics2D, n7, n8, rectangle);
    }

    protected int getColMargin(int n) {
        return this.idColumnIndex == n ? this.idColMargin : this.colMargin;
    }

    protected void paintColumnHeader(Graphics2D graphics2D, int n, int n2, Rectangle rectangle) {
        int n3 = rectangle.x;
        int n4 = rectangle.y - this.params.getConfiguration().getColumnHeaderHeight();
        Iterator iterator = this.params.getColumnIterator();
        for (int i = 0; iterator.hasNext() && i <= n2; ++i) {
            TableColumn tableColumn = (TableColumn)iterator.next();
            if (i < n) continue;
            int n5 = tableColumn.getPreferredWidth() + 2 * this.getColMargin(i);
            OfflineRenderer offlineRenderer = (OfflineRenderer)tableColumn.getHeaderRenderer();
            if (offlineRenderer != null) {
                JComponent jComponent = (JComponent)offlineRenderer.getComponent(((Field)this.params.getFieldArray().get(i)).getName(), null, (Field)this.params.getFieldArray().get(i), this.params);
                boolean bl = jComponent.isOpaque();
                jComponent.setOpaque(false);
                jComponent.setSize(n5, this.params.getConfiguration().getColumnHeaderHeight());
                graphics2D.translate(n3, n4);
                jComponent.doLayout();
                jComponent.print(graphics2D);
                graphics2D.translate(-n3, -n4);
                jComponent.setOpaque(bl);
            }
            graphics2D.draw(new Line2D.Double(n3 += n5, n4, n3, rectangle.getMaxY()));
        }
    }

    protected void paintRow(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, GraphicNode graphicNode, Rectangle rectangle) {
        int n6 = rectangle.x;
        Iterator iterator = this.params.getColumnIterator();
        for (int i = 0; iterator.hasNext() && i <= n5; ++i) {
            TableColumn tableColumn = (TableColumn)iterator.next();
            if (i < n4) continue;
            Object object = SpreadSheetUtils.getValueAt(graphicNode.getNode(), i, this.params.getCache(), this.params.getColumnModel(), this.params.getFieldContext());
            Field field = (Field)this.params.getFieldArray().get(i);
            int n7 = tableColumn.getPreferredWidth();
            int n8 = n7 + 2 * this.getColMargin(i);
            OfflineRenderer offlineRenderer = (OfflineRenderer)tableColumn.getCellRenderer();
            JComponent jComponent = (JComponent)offlineRenderer.getComponent(object, graphicNode, field, this.params);
            boolean bl = jComponent.isOpaque();
            jComponent.setOpaque(false);
            jComponent.setSize(n7, this.params.getRowHeight());
            graphics2D.translate(n6 + this.getColMargin(i), n3);
            jComponent.doLayout();
            jComponent.print(graphics2D);
            graphics2D.translate(-n6 - this.getColMargin(i), -n3);
            jComponent.setOpaque(bl);
            n6 += n8;
        }
        if (n != n2) {
            graphics2D.draw(new Line2D.Double(0.0, n3, n6, n3));
        }
    }
}

