/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.renderer;

import com.projity.field.Field;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParams;
import com.projity.pm.graphic.spreadsheet.renderer.IndicatorsComponent;
import com.projity.pm.graphic.spreadsheet.renderer.OfflineRenderer;
import com.projity.pm.graphic.spreadsheet.renderer.ResourceIndicatorsComponent;
import com.projity.pm.graphic.spreadsheet.renderer.TaskIndicatorsComponent;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class IndicatorsRenderer
extends DefaultTableCellRenderer
implements OfflineRenderer {
    private static final long serialVersionUID = 190987129201L;
    protected static JLabel cellHeader;
    protected IndicatorsComponent indicatorsComponent;

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.indicatorsComponent == null) {
            if (TaskIndicatorsComponent.acceptTask(object)) {
                this.indicatorsComponent = new TaskIndicatorsComponent();
            } else if (ResourceIndicatorsComponent.acceptResource(object)) {
                this.indicatorsComponent = new ResourceIndicatorsComponent();
            }
        }
        if (this.indicatorsComponent != null && this.indicatorsComponent.acceptValue(object)) {
            JPanel jPanel = new JPanel();
            if (jTable != null) {
                jPanel.setBackground(jTable.getBackground());
            }
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            StringBuffer stringBuffer = new StringBuffer();
            this.indicatorsComponent.setIndicators(object, jPanel, stringBuffer, bl, bl2);
            if (stringBuffer.length() == 0) {
                if (jTable == null) {
                    this.setText("");
                    return this;
                }
                return super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
            }
            stringBuffer.insert(0, "<html>");
            stringBuffer.append("</html>");
            jPanel.setToolTipText(stringBuffer.toString());
            return jPanel;
        }
        if (jTable == null) {
            this.setText("");
            return this;
        }
        return super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
    }

    public static JLabel getCellHeader() {
        if (cellHeader == null) {
            cellHeader = new JLabel(IconManager.getIcon("infomation.icon"));
        }
        return cellHeader;
    }

    @Override
    public Component getComponent(Object object, GraphicNode graphicNode, Field field, SpreadSheetParams spreadSheetParams) {
        Component component = this.getTableCellRendererComponent(null, object, false, false, -1, -1);
        return component;
    }
}

