/*
 * Decompiled with CFR 0.152.
 */
package org.openproj.util;

import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.BrowserControl;
import com.projity.util.VersionUtils;
import groovy.lang.GroovyClassLoader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.openproj.util.UpdateCheckerFormula;

public class UpdateChecker {
    private static final int UPDATE_CHECKER_VERSION = 1;
    private static final String updateAddress = "http://projectlibre.org/versions-1";
    private static final String downloadAddress = "http://sourceforge.net/projects/projectlibre/files/latest/download";

    private static void checkForUpdate() {
        if (!Preferences.userNodeForPackage(UpdateChecker.class).getBoolean("checkForUpdates", true)) {
            return;
        }
        String string = VersionUtils.getVersion();
        if (string == null) {
            string = "0";
        }
        try {
            URL uRL = new URL("http://projectlibre.org/versions-1?version=" + URLEncoder.encode(string == null ? "0" : string, "UTF-8") + "&locale=" + URLEncoder.encode(Locale.getDefault().toString(), "UTF-8") + "&timeZone=" + URLEncoder.encode(TimeZone.getDefault().getID().toString(), "UTF-8") + "&osName=" + URLEncoder.encode(System.getProperty("os.name"), "UTF-8") + "&osVersion=" + URLEncoder.encode(System.getProperty("os.version"), "UTF-8") + "&osArch=" + URLEncoder.encode(System.getProperty("os.arch"), "UTF-8") + "&javaVersion=" + URLEncoder.encode(System.getProperty("java.version"), "UTF-8") + "&javaVendor=" + URLEncoder.encode(System.getProperty("java.vendor"), "UTF-8") + "&validation=" + URLEncoder.encode(System.getProperty("projectlibre.validation", "0"), "UTF-8") + "&runNumber=" + URLEncoder.encode(System.getProperty("projectlibre.runNumber", "0"), "UTF-8") + "&firstRun=" + URLEncoder.encode(System.getProperty("projectlibre.firstRun", "0"), "UTF-8") + "&openprojRunNumber=" + URLEncoder.encode(System.getProperty("projectlibre.openprojRunNumber", "0"), "UTF-8") + "&openprojFirstRun=" + URLEncoder.encode(System.getProperty("projectlibre.openprojFirstRun", "0"), "UTF-8") + "&email=" + URLEncoder.encode(System.getProperty("projectlibre.userEmail", "0"), "UTF-8"));
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = bufferedReader.readLine();
            if (string == null) {
                bufferedReader.close();
                return;
            }
            UpdateCheckerFormula updateCheckerFormula = new UpdateCheckerFormula();
            if (updateCheckerFormula.mainCompare(string, string2) >= 0) {
                bufferedReader.close();
                return;
            }
            if (updateCheckerFormula.mainCompare(Preferences.userNodeForPackage(UpdateChecker.class).get("lastVersionChecked", "-1"), string2) >= 0) {
                int n = Preferences.userNodeForPackage(Class.forName("com.projity.main.Main")).getInt("projectlibreRunNumber", 0);
                int n2 = Integer.parseInt(Messages.getString("UpdateDialog.showEvery"));
                int n3 = Integer.parseInt(Messages.getString("UpdateDialog.showEveryStagger"));
                if ((n - n3) % n2 != 0) {
                    bufferedReader.close();
                    return;
                }
            }
            String string3 = bufferedReader.readLine();
            StringBuffer stringBuffer = new StringBuffer();
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null && !string4.trim().toUpperCase().equals("%UPDATECHECKER")) {
            }
            if (string4 != null) {
                while ((string4 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string4).append('\n');
                }
            }
            bufferedReader.close();
            UpdateCheckerFormula updateCheckerFormula2 = UpdateChecker.getFormula(stringBuffer.toString().trim());
            if (updateCheckerFormula2.mainCompare(string, string2) < 0) {
                final String string5 = MessageFormat.format(Messages.getString("Text.newVersion"), string2, string);
                Preferences.userNodeForPackage(UpdateChecker.class).put("lastVersionChecked", string2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Alert.okCancel(string5)) {
                            BrowserControl.displayURL(UpdateChecker.downloadAddress);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static UpdateCheckerFormula getFormula(String string) {
        if (string.length() == 0) {
            return new UpdateCheckerFormula();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package org.openproj.util;\n");
        stringBuffer.append("public class UpdateCheckerFormulaImpl extends UpdateCheckerFormula{\n");
        stringBuffer.append("\tpublic int mainCompare(String currentVersion,String latestVersion){\n");
        stringBuffer.append("\t\t").append(string).append('\n');
        stringBuffer.append("\t}\n");
        stringBuffer.append("}\n");
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(UpdateChecker.class.getClassLoader());
        try {
            Class clazz = groovyClassLoader.parseClass(stringBuffer.toString());
            return (UpdateCheckerFormula)clazz.newInstance();
        }
        catch (Exception exception) {
            return new UpdateCheckerFormula();
        }
    }

    public static void checkForUpdateInBackground() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                UpdateChecker.checkForUpdate();
            }
        }).start();
    }
}

