/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FieldUtil;
import org.apache.solr.search.facet.HLLAgg;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UniqueSlotAcc;

class UniqueSinglevaluedSlotAcc
extends UniqueSlotAcc {
    SortedDocValues topLevel;
    SortedDocValues[] subDvs;
    OrdinalMap ordMap;
    LongValues toGlobal;
    SortedDocValues subDv;

    public UniqueSinglevaluedSlotAcc(FacetContext fcontext, SchemaField field, int numSlots, HLLAgg.HLLFactory factory) throws IOException {
        super(fcontext, field, numSlots, factory);
    }

    @Override
    public void resetIterators() throws IOException {
        super.resetIterators();
        this.topLevel = FieldUtil.getSortedDocValues(this.fcontext.qcontext, this.field, null);
        this.nTerms = this.topLevel.getValueCount();
        if (this.topLevel instanceof MultiDocValues.MultiSortedDocValues) {
            this.ordMap = ((MultiDocValues.MultiSortedDocValues)this.topLevel).mapping;
            this.subDvs = ((MultiDocValues.MultiSortedDocValues)this.topLevel).values;
        } else {
            this.ordMap = null;
            this.subDvs = null;
        }
    }

    @Override
    protected BytesRef lookupOrd(int ord) throws IOException {
        return this.topLevel.lookupOrd(ord);
    }

    @Override
    public void setNextReader(LeafReaderContext readerContext) throws IOException {
        super.setNextReader(readerContext);
        if (this.subDvs != null) {
            this.subDv = this.subDvs[readerContext.ord];
            this.toGlobal = this.ordMap.getGlobalOrds(readerContext.ord);
            assert (this.toGlobal != null);
        } else {
            assert (readerContext.ord == 0 || this.topLevel.getValueCount() == 0);
            this.subDv = this.topLevel;
        }
        assert (this.subDv.docID() == -1);
    }

    @Override
    public void collect(int doc, int slotNum, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
        if (doc > this.subDv.docID()) {
            this.subDv.advance(doc);
        }
        if (doc == this.subDv.docID()) {
            int segOrd = this.subDv.ordValue();
            int ord = this.toGlobal == null ? segOrd : (int)this.toGlobal.get((long)segOrd);
            this.collectOrdToSlot(slotNum, ord);
        }
    }

    protected void collectOrdToSlot(int slotNum, int ord) {
        FixedBitSet bits = this.arr[slotNum];
        if (bits == null) {
            this.arr[slotNum] = bits = new FixedBitSet(this.nTerms);
        }
        bits.set(ord);
    }
}

