/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.listeners.json;

import com.carrotsearch.ant.tasks.junit4.ForkedJvmInfo;
import com.carrotsearch.ant.tasks.junit4.JUnit4;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Charsets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Strings;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscribe;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Resources;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedQuitEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedSuiteResultEvent;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonWriter;
import com.carrotsearch.ant.tasks.junit4.listeners.AggregatedEventListener;
import com.carrotsearch.ant.tasks.junit4.listeners.json.JsonReport$OutputMethod;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;

public class JsonReport
implements AggregatedEventListener {
    private JUnit4 junit4;
    private File targetFile;
    private String jsonpMethod;
    private JsonWriter jsonWriter;
    private String projectName;
    private Map slaves = new TreeMap();
    private OutputStreamWriter writer;
    private JsonReport$OutputMethod method;
    private boolean outputStreams = true;

    public void setFile(File file) {
        String string = file.getName().toLowerCase(Locale.ROOT);
        this.method = string.matches(".*\\.htm(l)?$") ? JsonReport$OutputMethod.HTML : (string.matches(".*\\.jsonp") ? JsonReport$OutputMethod.JSONP : JsonReport$OutputMethod.JSON);
        this.targetFile = file;
    }

    public void setJsonpMethod(String string) {
        this.jsonpMethod = Strings.emptyToNull(string);
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public void setOutputStreams(boolean bl) {
        this.outputStreams = bl;
    }

    @Override
    public void setOuter(JUnit4 jUnit4) {
        this.junit4 = jUnit4;
        if (this.targetFile == null) {
            throw new BuildException("'file' attribute is required (target file name ending in .html, .json or .jsonp).");
        }
        if (this.method == JsonReport$OutputMethod.HTML) {
            if (Strings.isNullOrEmpty(this.jsonpMethod)) {
                this.setJsonpMethod("testData");
            } else if (!"testData".equals(this.jsonpMethod)) {
                throw new BuildException("JSONP method must be empty or equal 'testData' for HTML output.");
            }
        }
        if (this.method == JsonReport$OutputMethod.JSONP && Strings.isNullOrEmpty(this.jsonpMethod)) {
            this.setJsonpMethod("testData");
        }
        try {
            Files.createParentDirs(this.targetFile);
            File file = this.targetFile;
            if (this.method == JsonReport$OutputMethod.HTML) {
                file = new File(this.removeExtension(this.targetFile.getAbsolutePath()) + ".jsonp");
            }
            this.writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), Charsets.UTF_8);
            if (!Strings.isNullOrEmpty(this.jsonpMethod)) {
                this.writer.write(this.jsonpMethod);
                this.writer.write("(");
            }
            this.jsonWriter = new JsonWriter(this.writer);
            this.jsonWriter.setHtmlSafe(false);
            this.jsonWriter.setIndent("  ");
            this.jsonWriter.beginObject();
            this.jsonWriter.name("junit4");
            this.jsonWriter.beginObject();
            this.jsonWriter.name("tests.seed");
            this.jsonWriter.value(jUnit4.getSeed());
            this.jsonWriter.name("project.name");
            this.jsonWriter.value(this.getProjectName());
            this.jsonWriter.endObject();
            this.jsonWriter.name("suites");
            this.jsonWriter.beginArray();
        }
        catch (IOException iOException) {
            throw new BuildException("Could not emit JSON report.", (Throwable)iOException);
        }
    }

    private String removeExtension(String string) {
        if (string.indexOf(".") > 0) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        return string;
    }

    private String getProjectName() {
        String string = Strings.emptyToNull(this.projectName);
        if (string == null) {
            string = Strings.emptyToNull(this.junit4.getProject().getName());
        }
        if (string == null) {
            string = "(unnamed project)";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void onSuiteResult(AggregatedSuiteResultEvent aggregatedSuiteResultEvent) {
        block7: {
            try {
                if (this.jsonWriter == null) {
                    return;
                }
                this.slaves.put(aggregatedSuiteResultEvent.getSlave().id, aggregatedSuiteResultEvent.getSlave());
                aggregatedSuiteResultEvent.serialize(this.jsonWriter, this.outputStreams);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.junit4.log("Error serializing to JSON file: " + Throwables.getStackTraceAsString(exception), 1);
                if (this.jsonWriter == null) break block7;
                try {
                    this.jsonWriter.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.jsonWriter = null;
                }
            }
        }
    }

    @Subscribe
    public void onQuit(AggregatedQuitEvent aggregatedQuitEvent) {
        if (this.jsonWriter == null) {
            return;
        }
        try {
            this.jsonWriter.endArray();
            this.jsonWriter.name("slaves");
            this.jsonWriter.beginObject();
            for (Map.Entry entry : this.slaves.entrySet()) {
                this.jsonWriter.name(Integer.toString((Integer)entry.getKey()));
                ((ForkedJvmInfo)entry.getValue()).serialize(this.jsonWriter);
            }
            this.jsonWriter.endObject();
            this.jsonWriter.endObject();
            this.jsonWriter.flush();
            if (!Strings.isNullOrEmpty(this.jsonpMethod)) {
                this.writer.write(");");
            }
            this.jsonWriter.close();
            this.jsonWriter = null;
            this.writer = null;
            if (this.method == JsonReport$OutputMethod.HTML) {
                this.copyScaffolding(this.targetFile);
            }
        }
        catch (IOException iOException) {
            this.junit4.log(iOException, 0);
        }
    }

    private void copyScaffolding(File file) {
        String[] stringArray;
        String string = "com/carrotsearch/ant/tasks/junit4/templates/json/";
        File file2 = file.getParentFile();
        ClassLoader classLoader = this.getClass().getClassLoader();
        String string2 = Resources.toString(classLoader.getResource(string + "index.html"), Charsets.UTF_8);
        string2 = string2.replaceAll(Pattern.quote("tests-output.jsonp"), this.removeExtension(file.getName()) + ".jsonp");
        Files.write(string2, file, Charsets.UTF_8);
        for (String string3 : stringArray = new String[]{"js/jquery-1.7.1.min.js", "js/script.js", "js/jquery.pathchange.js", "img/pass.png", "img/error.png", "img/stderr.png", "img/arrow-up.png", "img/stdout.png", "img/indicator.png", "img/failure.png", "img/omited.png", "img/arrow-down.png", "css/style.css"}) {
            URL uRL;
            File file3 = new File(file2, string3);
            if (!file3.getParentFile().exists()) {
                file3.getParentFile().mkdirs();
            }
            if ((uRL = classLoader.getResource(string + string3)) == null) {
                throw new IOException("Could not find the required report resource: " + string3);
            }
            Files.write(Resources.toByteArray(uRL), file3);
        }
    }
}

