/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.blockterms.BlockTermsReader;
import org.apache.lucene.codecs.blockterms.BlockTermsWriter;
import org.apache.lucene.codecs.blockterms.FixedGapTermsIndexReader;
import org.apache.lucene.codecs.blockterms.FixedGapTermsIndexWriter;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsReader;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public final class LuceneFixedGap
extends PostingsFormat {
    final int termIndexInterval;
    static final String FREQ_EXTENSION = "frq";
    static final String PROX_EXTENSION = "prx";

    public LuceneFixedGap() {
        this(32);
    }

    public LuceneFixedGap(int termIndexInterval) {
        super("LuceneFixedGap");
        this.termIndexInterval = termIndexInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        FixedGapTermsIndexWriter indexWriter;
        Lucene50PostingsWriter docs = new Lucene50PostingsWriter(state);
        boolean success = false;
        try {
            indexWriter = new FixedGapTermsIndexWriter(state, this.termIndexInterval);
            success = true;
        }
        finally {
            if (!success) {
                docs.close();
            }
        }
        success = false;
        try {
            BlockTermsWriter ret = new BlockTermsWriter((TermsIndexWriterBase)indexWriter, state, (PostingsWriterBase)docs);
            success = true;
            BlockTermsWriter blockTermsWriter = ret;
            return blockTermsWriter;
        }
        finally {
            if (!success) {
                try {
                    docs.close();
                }
                finally {
                    indexWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        FixedGapTermsIndexReader indexReader;
        Lucene50PostingsReader postings = new Lucene50PostingsReader(state);
        boolean success = false;
        try {
            indexReader = new FixedGapTermsIndexReader(state);
            success = true;
        }
        finally {
            if (!success) {
                postings.close();
            }
        }
        success = false;
        try {
            BlockTermsReader ret = new BlockTermsReader((TermsIndexReaderBase)indexReader, (PostingsReaderBase)postings, state);
            success = true;
            BlockTermsReader blockTermsReader = ret;
            return blockTermsReader;
        }
        finally {
            if (!success) {
                try {
                    postings.close();
                }
                finally {
                    indexReader.close();
                }
            }
        }
    }
}

