/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.autoscaling.ComputedType;
import org.apache.solr.client.solrj.cloud.autoscaling.Condition;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Preference;
import org.apache.solr.client.solrj.cloud.autoscaling.RangeVal;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaCount;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.SealedClause;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VariableBase;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class Clause
implements MapWriter,
Comparable<Clause> {
    private static final Set<String> IGNORE_TAGS = new HashSet<String>(Arrays.asList("replica", "collection", "shard", "strict", "type"));
    final boolean hasComputedValue;
    final Map<String, Object> original;
    Condition collection;
    Condition shard;
    Condition replica;
    Condition tag;
    Condition globalTag;
    final Replica.Type type;
    boolean strict;
    public static final String METRICS_PREFIX = "metrics:";

    protected Clause(Clause clause, Function<Condition, Object> computedValueEvaluator) {
        this.original = clause.original;
        this.type = clause.type;
        this.collection = clause.collection;
        this.shard = clause.shard;
        this.tag = this.evaluateValue(clause.tag, computedValueEvaluator);
        this.replica = this.evaluateValue(clause.replica, computedValueEvaluator);
        this.globalTag = this.evaluateValue(clause.globalTag, computedValueEvaluator);
        this.hasComputedValue = clause.hasComputedValue;
        this.strict = clause.strict;
    }

    Clause(Map<String, Object> original, Condition tag, Condition globalTag, boolean isStrict) {
        this.original = original;
        this.tag = tag;
        this.globalTag = globalTag;
        this.globalTag.clause = this;
        this.type = null;
        this.hasComputedValue = false;
        this.strict = isStrict;
    }

    private Clause(Map<String, Object> m) {
        List<String> ss;
        this.original = Utils.getDeepCopy(m, 10);
        String type = (String)m.get("type");
        this.type = type == null || "#ANY".equals(type) ? null : Replica.Type.valueOf(type.toUpperCase(Locale.ROOT));
        this.strict = Boolean.parseBoolean(String.valueOf(m.getOrDefault("strict", "true")));
        Optional<String> globalTagName = m.keySet().stream().filter(Policy.GLOBAL_ONLY_TAGS::contains).findFirst();
        if (globalTagName.isPresent()) {
            this.globalTag = this.parse(globalTagName.get(), m);
            if (m.size() > 2) {
                throw new RuntimeException("Only one extra tag supported for the tag " + globalTagName.get() + " in " + Utils.toJSONString(m));
            }
            this.tag = this.parse(m.keySet().stream().filter(s -> !((String)globalTagName.get()).equals(s) && !IGNORE_TAGS.contains(s)).findFirst().get(), m);
        } else {
            this.collection = this.parse("collection", m);
            this.shard = this.parse("shard", m);
            if (m.get("replica") == null) {
                throw new IllegalArgumentException(StrUtils.formatString("'replica' is required in {0}", Utils.toJSONString(m)));
            }
            this.replica = this.parse("replica", m);
            if (this.replica.op == Operand.WILDCARD) {
                throw new IllegalArgumentException("replica val cannot be null" + Utils.toJSONString(m));
            }
            m.forEach(this::parseCondition);
        }
        if (this.tag == null) {
            throw new RuntimeException("Invalid op, must have one and only one tag other than collection, shard,replica " + Utils.toJSONString(m));
        }
        if (this.tag.name.startsWith(METRICS_PREFIX) && ((ss = StrUtils.splitSmart(this.tag.name, ':')).size() < 3 || ss.size() > 4)) {
            throw new RuntimeException("Invalid metrics: param in " + Utils.toJSONString(m) + " must have at 2 or 3 segments after 'metrics:' separated by ':'");
        }
        this.doPostValidate(this.collection, this.shard, this.replica, this.tag, this.globalTag);
        this.hasComputedValue = this.hasComputedValue();
    }

    private void doPostValidate(Condition ... conditions) {
        for (Condition condition : conditions) {
            String err;
            if (condition == null || (err = condition.varType.postValidate(condition)) == null) continue;
            throw new IllegalArgumentException(StrUtils.formatString("Error in clause : {0}, caused by : {1}", Utils.toJSONString(this.original), err));
        }
    }

    public static Clause create(String json) {
        return Clause.create((Map)Utils.fromJSONString(json));
    }

    public static Clause create(Map<String, Object> m) {
        Clause clause = new Clause(m);
        return clause.hasComputedValue() ? clause : clause.getSealedClause(null);
    }

    public static String parseString(Object val) {
        if (val instanceof Condition) {
            val = ((Condition)val).val;
        }
        return val == null ? null : String.valueOf(val);
    }

    public Condition getCollection() {
        return this.collection;
    }

    public Condition getShard() {
        return this.shard;
    }

    public Condition getReplica() {
        return this.replica;
    }

    public Condition getTag() {
        return this.tag;
    }

    public Condition getGlobalTag() {
        return this.globalTag;
    }

    Condition evaluateValue(Condition condition, Function<Condition, Object> computedValueEvaluator) {
        if (condition == null) {
            return null;
        }
        if (condition.computedType == null) {
            return condition;
        }
        Object val = computedValueEvaluator.apply(condition);
        val = condition.op.readRuleValue(new Condition(condition.name, val, condition.op, null, null));
        return new Condition(condition.name, val, condition.op, null, this);
    }

    public boolean doesOverride(Clause that) {
        return this.collection.equals(that.collection) && this.tag.name.equals(that.tag.name);
    }

    public boolean isPerCollectiontag() {
        return this.globalTag == null;
    }

    void parseCondition(String s, Object o) {
        if (IGNORE_TAGS.contains(s)) {
            return;
        }
        if (this.tag != null) {
            throw new IllegalArgumentException("Only one tag other than collection, shard, replica is possible");
        }
        this.tag = this.parse(s, Collections.singletonMap(s, o));
    }

    private int compareTypes(Replica.Type t1, Replica.Type t2) {
        if (t1 == null && t2 == null) {
            return 0;
        }
        if (t1 != null && t2 == null) {
            return -1;
        }
        if (t1 == null) {
            return 1;
        }
        return 0;
    }

    private boolean hasComputedValue() {
        if (this.replica != null && this.replica.computedType != null) {
            return true;
        }
        if (this.tag != null && this.tag.computedType != null) {
            return true;
        }
        return this.globalTag != null && this.globalTag.computedType != null;
    }

    @Override
    public int compareTo(Clause that) {
        int v = Integer.compare(this.tag.op.priority, that.tag.op.priority);
        if (v != 0) {
            return v;
        }
        if (this.isPerCollectiontag() && that.isPerCollectiontag()) {
            v = Integer.compare(this.replica.op.priority, that.replica.op.priority);
            if (v == 0) {
                Double thisVal = this.replica.val instanceof RangeVal ? ((RangeVal)this.replica.val).max.doubleValue() : ((Double)this.replica.val).doubleValue();
                Double thatVal = that.replica.val instanceof RangeVal ? ((RangeVal)that.replica.val).max.doubleValue() : ((Double)that.replica.val).doubleValue();
                v = Preference.compareWithTolerance(thisVal, thatVal, 1);
                int n = v = this.replica.op == Operand.LESS_THAN ? v : v * -1;
            }
            if (v == 0) {
                v = this.compareTypes(this.type, that.type);
            }
            return v;
        }
        return 0;
    }

    void addTags(Collection<String> params) {
        if (this.globalTag != null && !params.contains(this.globalTag.name)) {
            params.add(this.globalTag.name);
        }
        if (this.tag != null && !params.contains(this.tag.name)) {
            params.add(this.tag.name);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Clause)) {
            return false;
        }
        Clause that = (Clause)o;
        return Objects.equals(this.original, that.original);
    }

    boolean isReplicaZero() {
        return this.replica != null && this.replica.getOperand() == Operand.EQUAL && this.replica.val instanceof Double && Preference.compareWithTolerance(0.0, (Double)this.replica.val, 1) == 0;
    }

    public SealedClause getSealedClause(Function<Condition, Object> computedValueEvaluator) {
        return this instanceof SealedClause ? (SealedClause)this : new SealedClause(this, computedValueEvaluator);
    }

    Condition parse(String s, Map<String, Object> m) {
        Object expectedVal = null;
        ComputedType computedType = null;
        Object val = m.get(s);
        Variable.Type varType = VariableBase.getTagType(s);
        if (varType.meta.isHidden()) {
            this.throwExp(m, "''{0}'' is not allowed", varType.tagName);
        }
        try {
            String conditionName = s.trim();
            Operand operand = null;
            if (val == null) {
                operand = Operand.WILDCARD;
                expectedVal = "#ANY";
            } else if (val instanceof List) {
                if (!varType.meta.supportArrayVals()) {
                    this.throwExp(m, "array values are not supported for {0}", conditionName);
                }
                expectedVal = this.readListVal(m, (List)val, varType, conditionName);
                operand = Operand.IN;
            } else if (val instanceof String) {
                String strVal = ((String)val).trim();
                val = strVal;
                operand = this.getOperand(strVal);
                strVal = strVal.substring(Operand.EQUAL == operand || Operand.WILDCARD == operand ? 0 : 1);
                for (ComputedType t : ComputedType.values()) {
                    String changedVal = t.match(strVal);
                    if (changedVal == null) continue;
                    computedType = t;
                    strVal = changedVal;
                    if (varType != null && varType.supportedComputedTypes.contains((Object)computedType)) continue;
                    this.throwExp(m, "''{0}'' is not allowed for variable :  ''{1}''", new Object[]{t, conditionName});
                }
                if (computedType == null && ((String)val).charAt(0) == '#' && !varType.wildCards.contains(val)) {
                    this.throwExp(m, "''{0}'' is not an allowed value for ''{1}'', supported value is : {2} ", val, conditionName, varType.wildCards);
                }
                operand = varType == null ? operand : varType.getOperand(operand, strVal, computedType);
                expectedVal = Clause.validate(s, new Condition(s, strVal, operand, computedType, null), true);
            } else if (val instanceof Number) {
                operand = Operand.EQUAL;
                operand = varType.getOperand(operand, val, null);
                expectedVal = Clause.validate(s, new Condition(s, val, operand, null, null), true);
            }
            return new Condition(conditionName, expectedVal, operand, computedType, this);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.throwExp(m, "Invalid tag : {0} ", s);
            return null;
        }
    }

    public void throwExp(Map<String, Object> clause, String msg, Object ... args) {
        throw new IllegalArgumentException("syntax error in clause :" + Utils.toJSONString(clause) + " , msg:  " + StrUtils.formatString(msg, args));
    }

    private List readListVal(Map m, List val, Variable.Type varType, String conditionName) {
        List list = val;
        if ((list = list.stream().map(it -> varType.validate(conditionName, it, true)).map(it -> {
            if (it instanceof String) {
                String trim = ((String)it).trim();
                if (trim.isEmpty()) {
                    throw new IllegalArgumentException(StrUtils.formatString("{0} cannot have an empty string value in clause : {1}", conditionName, Utils.toJSONString(m)));
                }
                return trim;
            }
            return it;
        }).filter(it -> it != null).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException(StrUtils.formatString("{0} cannot have an empty list value in clause : {1}", conditionName, Utils.toJSONString(m)));
        }
        for (Object o : list) {
            if (!(o instanceof String) || this.getOperand((String)o) == Operand.EQUAL) continue;
            throw new IllegalArgumentException(StrUtils.formatString("No operators are supported in collection values in condition : {0} in clause : {1}", conditionName, Utils.toJSONString(m)));
        }
        if (list.size() < 2) {
            throw new IllegalArgumentException(StrUtils.formatString("Array should have more than one value in  condition : {0} in clause : {1}", conditionName, Utils.toJSONString(m)));
        }
        return list;
    }

    private Operand getOperand(String strVal) {
        Operand operand = "#ANY".equals(strVal) || "#EACH".equals(strVal) ? Operand.WILDCARD : (strVal.startsWith(Operand.NOT_EQUAL.operand) ? Operand.NOT_EQUAL : (strVal.startsWith(Operand.GREATER_THAN.operand) ? Operand.GREATER_THAN : (strVal.startsWith(Operand.LESS_THAN.operand) ? Operand.LESS_THAN : Operand.EQUAL)));
        return operand;
    }

    List<Violation> testGroupNodes(Policy.Session session, double[] deviations) {
        ComputedValueEvaluator eval = new ComputedValueEvaluator(session);
        eval.collName = (String)this.collection.getValue();
        Violation.Ctx ctx = new Violation.Ctx(this, session.matrix, eval);
        HashSet<Object> tags = new HashSet<Object>();
        for (Row row : session.matrix) {
            Object val;
            eval.node = row.node;
            Condition tag = this.tag;
            if (tag.computedType != null) {
                tag = this.evaluateValue(tag, eval);
            }
            if ((val = row.getVal(tag.name)) == null || !tag.isPass(val)) continue;
            if (tag.op == Operand.LESS_THAN || tag.op == Operand.GREATER_THAN) {
                tags.add(this.tag);
                continue;
            }
            tags.add(val);
        }
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        Set<String> shards = this.getShardNames(session, eval);
        for (String s : shards) {
            ReplicaCount replicaCount = new ReplicaCount();
            eval.shardName = s;
            for (Object e : tags) {
                replicaCount.reset();
                for (Row row : session.matrix) {
                    eval.node = row.node;
                    if (e instanceof Condition) {
                        Condition tag = (Condition)e;
                        if (tag.computedType != null) {
                            tag = this.evaluateValue(tag, eval);
                        }
                        if (!tag.isPass(row)) {
                            continue;
                        }
                    } else if (!e.equals(row.getVal(this.tag.name))) continue;
                    this.addReplicaCountsForNode(eval, replicaCount, row);
                }
                SealedClause sealedClause = this.getSealedClause(eval);
                if (!sealedClause.replica.isPass(replicaCount)) {
                    ReplicaCount replicaCountCopy = replicaCount.copy();
                    Violation violation = new Violation(sealedClause, eval.collName, eval.shardName, null, replicaCountCopy, sealedClause.getReplica().replicaCountDelta(replicaCountCopy), e);
                    ctx.resetAndAddViolation(e, replicaCountCopy, violation);
                    sealedClause.addViolatingReplicas(sealedClause.tag, eval, ctx, this.tag.name, e, violation, session);
                    continue;
                }
                this.computeDeviation(deviations, replicaCount, sealedClause);
            }
        }
        return ctx.allViolations;
    }

    private void computeDeviation(double[] deviations, ReplicaCount replicaCount, SealedClause sealedClause) {
        if (deviations != null && sealedClause.replica.op == Operand.RANGE_EQUAL) {
            Long actualCount = replicaCount.getVal(this.type);
            Double realDelta = ((RangeVal)sealedClause.replica.val).realDelta(((Number)actualCount).doubleValue());
            realDelta = this.isReplicaZero() ? -1.0 * realDelta : realDelta;
            deviations[0] = deviations[0] + Math.abs(realDelta);
        }
    }

    void addViolatingReplicas(Condition tag, ComputedValueEvaluator eval, Violation.Ctx ctx, String tagName, Object tagVal, Violation violation, Policy.Session session) {
        if (tag.varType.addViolatingReplicas(ctx)) {
            return;
        }
        for (Row row : session.matrix) {
            if (!tagVal.equals(row.getVal(tagName))) continue;
            row.forEachReplica(eval.collName, ri -> {
                if ("#ANY".equals(eval.shardName) || eval.shardName.equals(ri.getShard())) {
                    violation.addReplica(new Violation.ReplicaInfoAndErr((ReplicaInfo)ri).withDelta(tag.delta(row.getVal(tag.name))));
                }
            });
        }
    }

    private void addReplicaCountsForNode(ComputedValueEvaluator computedValueEvaluator, ReplicaCount replicaCount, Row node) {
        node.forEachReplica((String)this.collection.getValue(), ri -> {
            if ("#ANY".equals(computedValueEvaluator.shardName) || computedValueEvaluator.shardName.equals(ri.getShard())) {
                replicaCount.increment((ReplicaInfo)ri);
            }
        });
    }

    List<Violation> testPerNode(Policy.Session session, double[] deviations) {
        ComputedValueEvaluator eval = new ComputedValueEvaluator(session);
        eval.collName = (String)this.collection.getValue();
        Violation.Ctx ctx = new Violation.Ctx(this, session.matrix, eval);
        Set<String> shards = this.getShardNames(session, eval);
        for (String s : shards) {
            ReplicaCount replicaCount = new ReplicaCount();
            eval.shardName = s;
            for (Row row : session.matrix) {
                replicaCount.reset();
                eval.node = row.node;
                Condition tag = this.tag;
                if (tag.computedType != null) {
                    tag = this.evaluateValue(tag, eval);
                }
                if (!tag.isPass(row)) continue;
                this.addReplicaCountsForNode(eval, replicaCount, row);
                SealedClause sealedClause = this.getSealedClause(eval);
                if (!sealedClause.replica.isPass(replicaCount)) {
                    ReplicaCount replicaCountCopy = replicaCount.copy();
                    Violation violation = new Violation(sealedClause, eval.collName, eval.shardName, eval.node, replicaCountCopy, sealedClause.getReplica().replicaCountDelta(replicaCountCopy), eval.node);
                    ctx.resetAndAddViolation(row.node, replicaCountCopy, violation);
                    sealedClause.addViolatingReplicas(sealedClause.tag, eval, ctx, "node", row.node, violation, session);
                    continue;
                }
                this.computeDeviation(deviations, replicaCount, sealedClause);
            }
        }
        return ctx.allViolations;
    }

    private Set<String> getShardNames(Policy.Session session, ComputedValueEvaluator eval) {
        HashSet<String> shards = new HashSet<String>();
        if (this.isShardAbsent()) {
            shards.add("#ANY");
        } else {
            for (Row row : session.matrix) {
                row.forEachShard(eval.collName, (shard, r) -> {
                    if (this.shard.isPass(shard)) {
                        shards.add((String)shard);
                    }
                });
            }
        }
        return shards;
    }

    boolean isShardAbsent() {
        return "#ANY".equals(this.shard.val);
    }

    public List<Violation> test(Policy.Session session, double[] deviations) {
        if (this.isPerCollectiontag()) {
            return this.tag.varType == Variable.Type.NODE || this.tag.varType.meta.isNodeSpecificVal() && this.replica.computedType == null ? this.testPerNode(session, deviations) : this.testGroupNodes(session, deviations);
        }
        ComputedValueEvaluator computedValueEvaluator = new ComputedValueEvaluator(session);
        Violation.Ctx ctx = new Violation.Ctx(this, session.matrix, computedValueEvaluator);
        for (Row r : session.matrix) {
            computedValueEvaluator.node = r.node;
            SealedClause sealedClause = this.getSealedClause(computedValueEvaluator);
            if (sealedClause.getGlobalTag().isPass(r)) continue;
            ctx.resetAndAddViolation(r.node, null, new Violation(sealedClause, null, null, r.node, r.getVal(sealedClause.globalTag.name), sealedClause.globalTag.delta(r.getVal(this.globalTag.name)), r.node));
            this.addViolatingReplicas(sealedClause.globalTag, computedValueEvaluator, ctx, Variable.Type.CORES.tagName, r.node, ctx.currentViolation, session);
        }
        return ctx.allViolations;
    }

    public boolean isMatch(ReplicaInfo r, String collection, String shard) {
        if (this.type != null && r.getType() != this.type) {
            return false;
        }
        if (r.getCollection().equals(collection)) {
            if (this.shard == null || this.shard.val.equals("#ANY")) {
                return true;
            }
            if (this.shard.val.equals("#EACH") && r.getShard().equals(shard)) {
                return true;
            }
            return this.shard.val.equals(r.getShard()) && r.getShard().equals(shard);
        }
        return false;
    }

    boolean matchShard(String replicaShard, String shardInContext) {
        if (this.shard == null || this.shard.val.equals("#ANY")) {
            return true;
        }
        if (this.shard.val.equals("#EACH") && replicaShard.equals(shardInContext)) {
            return true;
        }
        return this.shard.val.equals(replicaShard);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String toString() {
        return Utils.toJSONString(this.original);
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        for (Map.Entry<String, Object> e : this.original.entrySet()) {
            ew.put(e.getKey(), e.getValue());
        }
    }

    public static Object validate(String name, Object val, boolean isRuleVal) {
        if (val == null) {
            return null;
        }
        Variable.Type info = VariableBase.getTagType(name);
        if (info == null) {
            throw new RuntimeException("Unknown type :" + name);
        }
        return info.validate(name, val, isRuleVal);
    }

    public static Long parseLong(String name, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        Number num = null;
        if (val instanceof String) {
            try {
                num = Long.parseLong(((String)val).trim());
            }
            catch (NumberFormatException e) {
                try {
                    num = Double.parseDouble((String)val);
                }
                catch (NumberFormatException e1) {
                    throw new RuntimeException(name + ": " + val + "not a valid number", e);
                }
            }
        } else if (val instanceof Number) {
            num = (Number)val;
        }
        if (num != null) {
            return num.longValue();
        }
        throw new RuntimeException(name + ": " + val + "not a valid number");
    }

    public static Double parseDouble(String name, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof RangeVal) {
            val = ((RangeVal)val).actual;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        Number num = null;
        if (val instanceof String) {
            try {
                num = Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(name + ": " + val + "not a valid number", e);
            }
        } else if (val instanceof Number) {
            num = (Number)val;
        }
        if (num != null) {
            return num.doubleValue();
        }
        throw new RuntimeException(name + ": " + val + "not a valid number");
    }

    public static class ComputedValueEvaluator
    implements Function<Condition, Object> {
        final Policy.Session session;
        String collName = null;
        String shardName = null;
        String node = null;

        public ComputedValueEvaluator(Policy.Session session) {
            this.session = session;
        }

        @Override
        public Object apply(Condition computedCondition) {
            return computedCondition.varType.computeValue(this.session, computedCondition, this.collName, this.shardName, this.node);
        }
    }

    static enum TestStatus {
        NOT_APPLICABLE,
        FAIL,
        PASS;

    }
}

