/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluatorException;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class EmpiricalDistributionEvaluator
extends RecursiveNumericEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public EmpiricalDistributionEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (!(value instanceof List)) {
            throw new StreamEvaluatorException("List value expected but found type %s for value %s", value.getClass().getName(), value.toString());
        }
        EmpiricalDistribution empiricalDistribution = new EmpiricalDistribution();
        double[] backingValues = ((List)value).stream().mapToDouble(innerValue -> ((Number)innerValue).doubleValue()).sorted().toArray();
        empiricalDistribution.load(backingValues);
        return empiricalDistribution;
    }
}

