<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_proxy_hcheck - Serveur HTTP Apache Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_proxy_hcheck</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_proxy_hcheck.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_proxy_hcheck.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Check up dynamique des membres du groupe de rpartition de charge
(quipiers) pour <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code></td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>proxy_hcheck_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_proxy_hcheck.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.21 du serveur HTTP Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module permet d'effectuer un check up dynamique des membres du groupe
    de rpartition de charge (quipiers). Ce check up peut tre activ pour un
    ou plusieurs quipiers et il est indpendant des requtes de mandataire
    inverse proprement dites.</p>

    <p>Pour fonctionner, ce module <em>ncessite</em> le chargement pralable de
    <code class="module"><a href="../mod/mod_watchdog.html">mod_watchdog</a></code>.</p>

<div class="note"><h3>Paramtres</h3>
  <p>Le mcanisme de check up est activ via l'utilisation de paramtres
  supplmentaires de la directive <code class="directive"><a href="../mod/mod_proxy.html#balancermember">BalancerMember</a></code> configurs de manire standard
  via la directive <code class="directive"><a href="../mod/mod_proxy.html#proxypass">ProxyPass</a></code> :</p>

  <p>Ce module dfinit un nouveau drapeau d'tat <a href="mod_proxy.html#status_table">status</a> pour BalancerMember :
  "<code>C</code>". Lorsque l'quipier est mis hors service suite  un
  disfonctionnement dtermin par le module de check up, ce drapeau est activ
  et peut tre lu (et modifi) via le <code>balancer-manager</code>.</p>

    <table>
    <tr><th>Paramtre</th>
        <th>Dfaut</th>
        <th>Description</th></tr>
    <tr><td>hcmethod</td>
        <td>None</td>
        <td>Aucun check up dynamique n'est effectu. Les choix possibles sont :
        	<table>
        		<tr><th>Method</th><th>Description</th><th>Note</th></tr>
        		<tr><td>None</td><td>Aucun check up dynamique effectu</td><td /></tr>
        		<tr><td>TCP</td><td>Vrifie qu'un socket vers le serveur
			d'arrire-plan peut tre cr ; par exemple "es-tu en
			tat de fonctionner"</td><td /></tr>
        		<tr><td>OPTIONS</td><td>Envoie une requte <code>HTTP
			OPTIONS</code> au serveur d'arrire-plan</td><td>*</td></tr>
        		<tr><td>HEAD</td><td>Envoie une requte <code>HTTP
			HEAD</code> au serveur d'arrire-plan</td><td>*</td></tr>
        		<tr><td>GET</td><td>Envoie une requte <code>HTTP
			GET</code> au serveur d'arrire-plan</td><td>*</td></tr>

				<tr><td colspan="3" /></tr>
				<tr><td colspan="3">*: si hcexpr n'est pas
				utilis, un retour HTTP 2xx ou 3xx sera
				interprt comme un passage avec succs du check
				up.</td></tr>
        	</table>
        </td></tr>
    <tr><td>hcpasses</td>
        <td>1</td>
        <td>Nombre de check up  passer avec succs avant de remettre en service
	l'quipier</td></tr>
    <tr><td>hcfails</td>
        <td>1</td>
        <td>Nombre de check up chous avant mettre hors service l'quipier</td></tr>
    <tr><td>hcinterval</td>
        <td>30</td>
        <td>Intervalle entre deux check up en secondes (par dfaut effectu
	toutes les 30 secondes)</td></tr>
    <tr><td>hcuri</td>
        <td>&nbsp;</td>
        <td>URI supplmentaire  ajouter  l'URL de l'quipier pour le check up.</td></tr>
    <tr><td>hctemplate</td>
        <td>&nbsp;</td>
        <td>Nom du modle cr via <code class="directive"><a href="#proxyhctemplate">ProxyHCTemplate</a></code> 
	utiliser pour dfinir les paramtres de check up de cet quipier</td></tr>
    <tr><td>hcexpr</td>
        <td>&nbsp;</td>
        <td>Nom de l'expression cre via <code class="directive"><a href="#proxyhcexpr">ProxyHCExpr</a></code>
	utilise pour analyser les en-ttes de la rponse du check up.<br />
            <em>Si ce paramtre est absent, un tat HTTP de 2xx  3xx est
	    interprt comme un check up russi.</em></td></tr>
    </table>
</div>

</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#examples">Exemples d'utilisation</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#proxyhcexpr">ProxyHCExpr</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyhctemplate">ProxyHCTemplate</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyhctpsize">ProxyHCTPsize</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_proxy_hcheck">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_proxy_hcheck">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples d'utilisation</a></h2>

	
    <p>L'exemple suivant montre comment configurer le check up pour diffrents
    serveurs d'arrire-plan :</p>

	
	<pre class="prettyprint lang-config">ProxyHCExpr ok234 {%{REQUEST_STATUS} =~ /^[234]/}
ProxyHCExpr gdown {%{REQUEST_STATUS} =~ /^[5]/}
ProxyHCExpr in_maint {hc('body') !~ /Under maintenance/}

&lt;Proxy balancer://foo&gt;
  BalancerMember http://www.example.com/  hcmethod=GET hcexpr=in_maint hcuri=/status.php
  BalancerMember http://www2.example.com/ hcmethod=HEAD hcexpr=ok234 hcinterval=10
  BalancerMember http://www3.example.com/ hcmethod=TCP hcinterval=5 hcpasses=2 hcfails=3
  BalancerMember http://www4.example.com/
&lt;/Proxy&gt;

ProxyPass "/" "balancer://foo"
ProxyPassReverse "/" "balancer://foo"</pre>


<p>Dans ce scnario, on teste l'quipier <code>http://www.example.com/</code> en lui
envoyant une requte <code>GET /status.php</code> et en regardant si la rponse
contient la chane <em>Under maintenance</em>. Si c'est le cas, le check up est
considr comme ayant chou et l'quipier est mis hors service. Ce check up
dynamique est effectu toutes les 30 secondes, ce qui correspond  la valeur par
dfaut.</p>

<p>On teste l'quipier <code>http://www2.example.com/</code> en lui envoyant
simplement une requte <code>HEAD</code> toutes les 10 secondes et en vrifiant
que la rponse HTTP est bien un code d'tat de 2xx, 3xx ou 4xx. On teste
l'quipier <code>http://www3.example.com/</code>  en vrifiant simplement toutes
les 5 secondes que le socket vers ce serveur est bien oprationnel. Si ce
serveur est marqu "hors service", il lui faudra 2 check up russis pour tre
ractiv et participer  nouveau  la rpartition de charge. Si  ce moment-l
il choue  3 check up successifs, il sera  nouveau mis hors service. Enfin,
l'quipier <code>http://www4.example.com/</code> ne fait l'objet d'aucun check
up.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="proxyhcexpr" id="proxyhcexpr">Directive</a> <a name="ProxyHCExpr" id="ProxyHCExpr">ProxyHCExpr</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Cre et nomme une expression conditionnelle  utiliser pour
dterminer la sant d'un serveur d'arrire-plan en fonction de sa valeur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyHCExpr <em>name</em> {<em>ap_expr expression</em>}</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy_hcheck</td></tr>
</table>
    <p>La directive <code class="directive">ProxyHCExpr</code> permet de crer et nommer
    une expression conditionnelle dont la valeur calcule en fonction des
    en-ttes de la rponse du serveur d'arrire-plan permettra d'valuer la
    sant de ce dernier. Cette expression nomme peut alors tre assigne aux
    serveurs d'arrire-plan via le paramtre <code>hcexpr</code>.</p>

    <div class="example"><h3>ProxyHCExpr: interprte les rponses 2xx/3xx/4xx comme des
    check up russis</h3><pre class="prettyprint lang-config">ProxyHCExpr ok234 {%{REQUEST_STATUS} =~ /^[234]/}
ProxyPass "/apps"     "balancer://foo"

&lt;Proxy balancer://foo&gt;
  BalancerMember http://www2.example.com/  hcmethod=HEAD hcexpr=ok234 hcinterval=10
&lt;/Proxy&gt;</pre>
</div>

    <div class="note">
    L'<a href="../expr.html">expression</a> peut utiliser des accolades ("{}")
    comme dlimiteurs en plus des guillemets normaux.
    </div>

    <p>Si l'on utilise une mthode de check up (par exemple <code>GET</code>)
    qui gnre un corps de rponse, ce corps peut lui-mme tre auscult via
    <code>ap_expr</code> en utilisant la fonction associe aux expressions
    <code>hc()</code> spcifique  ce module.</p>

    <p>Dans l'exemple suivant, on envoie une requte <code>GET</code> au serveur
    d'arrire-plan, et si le corps de la rponse contient la chane <em>Under
    maintenance</em>, ce serveur d'arrire-plan est mis hors service.</p>

    <div class="example"><h3>ProxyHCExpr: auscultation du corps de la rponse</h3><pre class="prettyprint lang-config">ProxyHCExpr in_maint {hc('body') !~ /Under maintenance/}
ProxyPass "/apps"     "balancer://foo"

&lt;Proxy balancer://foo&gt;
  BalancerMember http://www.example.com/ hcexpr=in_maint hcmethod=get hcuri=/status.php
&lt;/Proxy&gt;</pre>
</div>

    <p><em>NOTE:</em> Comme le corps de la rponse peut tre assez grand, il est
    recommand de privilgier un check up bas sur les codes d'tat.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="proxyhctemplate" id="proxyhctemplate">Directive</a> <a name="ProxyHCTemplate" id="ProxyHCTemplate">ProxyHCTemplate</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Cre et nomme un modle permettant de dfinir diffrents
paramtres de check up</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyHCTemplate <em>name</em> <em>parameter</em>=<em>setting</em> [...]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy_hcheck</td></tr>
</table>
    <p>La directive <code class="directive">ProxyHCTemplate</code> permet de crer et
    nommer un modle de paramtres de check up qui peut alors tre assign aux
    quipiers via le paramtre <code>hctemplate</code>.</p>

    <div class="example"><h3>ProxyHCTemplate</h3><pre class="prettyprint lang-config">ProxyHCTemplate tcp5 hcmethod=tcp hcinterval=5
ProxyPass "/apps"     "balancer://foo"

&lt;Proxy balancer://foo&gt;
  BalancerMember http://www2.example.com/ hctemplate=tcp5
&lt;/Proxy&gt;</pre>
</div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="proxyhctpsize" id="proxyhctpsize">Directive</a> <a name="ProxyHCTPsize" id="ProxyHCTPsize">ProxyHCTPsize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la taille totale, pour l'ensemble du
serveur, du jeu de threads utilis pour le check up des
quipiers</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyHCTPsize <em>size</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyHCTPsize 16</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy_hcheck</td></tr>
</table>
    <p>Si Apache httpd et APR ont t compils avec le support des threads, le
    module de check up peut confier ce travail  un jeu de threads associ au
    processus Watchdog, ce qui permet l'excution des check up en parallle. La
    directive <code class="directive">ProxyHCTPsize</code> permet de dterminer la
    taille de ce jeu de threads. Une valeur de <code>0</code> signifie qu'aucun
    jeu de threads ne sera utilis, et le check up des diffrents quipiers sera
    alors effectu squentiellement.</p>

    <div class="example"><h3>ProxyHCTPsize</h3><pre class="prettyprint lang-config">ProxyHCTPsize 32</pre>
</div>


</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_proxy_hcheck.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_proxy_hcheck.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_proxy_hcheck.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>