<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Contrle d'accs - Serveur HTTP Apache Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">How-To / Tutoriels</a></div><div id="page-content"><div id="preamble"><h1>Contrle d'accs</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/howto/access.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../es/howto/access.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="../fr/howto/access.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>

    <p>Le contrle d'accs fait rfrence  tout concept de contrle
    d'accs  une ressource quelconque. Il est distinct du processus d'<a href="auth.html">authentification et d'autorisation</a>.</p>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#related">Modules et directives concerns</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#host">Contrle d'accs en fonction de l'hte du
client</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#env">Contrle d'accs en fonction de variables
arbitraires</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewrite">Utilisation de mod_rewrite pour le contrle
d'accs</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#moreinformation">Informations complmentaires</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="related" id="related">Modules et directives concerns</a></h2>

    <p>Plusieurs modules peuvent intervenir dans le contrle d'accs.
    Les plus importants sont <code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code> et
    <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code>. Ce document illustre aussi comment
    utiliser <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> pour le contrle
    d'accs.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="host" id="host">Contrle d'accs en fonction de l'hte du
client</a></h2>
    <p>
    Si vous souhaitez restreindre l'accs  certaines parties de votre
    site web en fonction de l'addresse de l'hte de vos visiteurs, le
    plus simple pour y parvenir consiste  utiliser le module
    <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code>.
    </p>

    <p>La directive <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> permet d'accorder ou
    d'interdire l'accs  certaines ressources de diffrentes manires.
    Ces critres d'accs, en conjonction avec les directives <code class="directive"><a href="../mod/mod_authz_core.html#requireall">RequireAll</a></code>, <code class="directive"><a href="../mod/mod_authz_core.html#requireany">RequireAny</a></code>, et <code class="directive"><a href="../mod/mod_authz_core.html#requirenone">RequireNone</a></code>, peuvent tre
    combins d'une manire suffisamment complexe pour
    satisfaire votre politique de contrle d'accs.</p>

    <div class="warning"><p>
    Les directives <code class="directive"><a href="../mod/mod_access_compat.html#allow">Allow</a></code>, <code class="directive"><a href="../mod/mod_access_compat.html#deny">Deny</a></code>, et <code class="directive"><a href="../mod/mod_access_compat.html#order">Order</a></code> fournies par le module
    <code class="module"><a href="../mod/mod_access_compat.html">mod_access_compat</a></code> sont obsoltes, et sont appeles 
    disparatre dans les versions futures. Il est donc dconseill de
    les utiliser, et de se fier aux tutoriels qui recommandent leur
    utilisation.
    </p></div>

    <p>Les directives Require s'utilisent comme suit :</p>

    <pre class="prettyprint lang-config">Require host address
Require ip ip.address</pre>


    <p>Dans la premire forme, <var>nom-hte</var> est un nom de domaine
    pleinement qualifi (fqdn), ou un nom de domaine partiel ; vous
    pouvez spcifier plusieurs noms de domaines, si vous le dsirez.</p>

    <p>Dans la seconde forme, <var>adresse-ip</var> est une adresse IP
    complte, une adresse IP partielle, une paire rseau/masque de
    sous-rseau ou une spcification CIDR de la forme rseau/nnn. Il est
    possible de spcifier des adresses IPv4 ou IPv6.</p>

    <p>Voir <a href="../mod/mod_authz_host.html#requiredirectives">la
    documentation de mod_authz_host</a> pour d'autres exemples de cette
    syntaxe.</p>

    <p>Vous pouvez insrer le mot-cl <code>not</code> pour inverser un
    critre particulier. Notez que le mot <code>not</code> tant la
    ngation d'une valeur, il ne peut pas tre utilis pour autoriser
    ou interdire une requte, car <em>non vrai</em> ne
    sera pas interpret par httpd comme <em>faux</em>. Ainsi, pour interdire la
    visite d'une page  l'aide d'une ngation, le bloc doit contenir un
    lment valu  vrai ou faux.
    Par exemple, si quelqu'un est en train d'inonder
    votre forum de messages indsirables, vous pouvez ajouter cette ligne pour lui refuser
    l'accs :</p>

    <pre class="prettyprint lang-config">&lt;RequireAll&gt;
    Require all granted
    Require not ip 10.252.46.165
&lt;/RequireAll&gt;</pre>


    <p>Les visiteurs possdant cette adresse (<code>10.252.46.165</code>) ne pourront pas voir le
    contenu concern par cette directive. Si vous voulez interdire
    l'accs  une machine en fonction de son nom, vous pouvez ajouter
    ceci :</p>

    <pre class="prettyprint lang-config">Require not host <var>host.example.com</var>
    </pre>


    <p>Et si vous voulez interdire l'accs  un domaine particulier,
    vous pouvez spcifier des adresses IP partielles ou des noms de
    domaine, comme ceci :</p>

    <pre class="prettyprint lang-config">Require not ip 192.168.205
Require not host phishers.example.com moreidiots.example
Require not host gov</pre>


    <p>Les directives <code class="directive"><a href="../mod/mod_authz_core.html#requireall">RequireAll</a></code>, <code class="directive"><a href="../mod/mod_authz_core.html#requireany">RequireAny</a></code>, et <code class="directive"><a href="../mod/mod_authz_core.html#requirenone">RequireNone</a></code> permettent galement de prciser des
    critres d'accs plus complexes.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="env" id="env">Contrle d'accs en fonction de variables
arbitraires</a></h2>

    <p>Vous pouvez accorder ou refuser l'accs en fonction de variables
    d'environnement arbitraires ou de valeurs d'en-ttes de la requte
    en utilisant la directive <code class="directive"><a href="../mod/core.html#if">&lt;If&gt;</a></code>. Par exemple, pour interdire l'accs en
    fonction du user-agent (le type de navigateur), vous pouvez
    spcifier ceci :</p>

    <pre class="prettyprint lang-config">&lt;If "%{HTTP_USER_AGENT} == 'BadBot'"&gt;
    Require all denied
&lt;/If&gt;</pre>


    <p>La syntaxe <code>expr</code> de la directive <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> permet de rcrire
    l'exemple prcdent de la manire suivante :</p>


    <pre class="prettyprint lang-config">Require expr %{HTTP_USER_AGENT} != 'BadBot'</pre>


    <div class="note"><h3>Avertissement :</h3>
    <p>Contrler l'accs en fonction de l'en-tte
    <code>User-Agent</code> n'est pas une technique fiable, car cet
    en-tte peut tre dfini  une valeur quelconque, selon le bon
    vouloir de l'utilisateur.</p>
    </div>

    <p>Voir le document  propos des <a href="../expr.html">expressions</a> pour une description plus
    approfondie des syntaxes d'expressions et des variables disponibles.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="rewrite" id="rewrite">Utilisation de mod_rewrite pour le contrle
d'accs</a></h2>

    <p>Le drapeau <code>[F]</code> de la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> permet d'envoyer une
    rponse de type 403 Forbidden. Il vous permet donc d'interdire
    l'accs  une ressource en fonction d'un critre arbitraire.</p>

    <p>Par exemple, pour bloquer l'accs  une ressources entre 20h et
    7h du matin, vous pouvez utiliser <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> :</p>

    <pre class="prettyprint lang-config">RewriteEngine On
RewriteCond "%{TIME_HOUR}" "&gt;=20" [OR]
RewriteCond "%{TIME_HOUR}" "&lt;07"
RewriteRule "^/fridge"     "-" [F]</pre>


    <p>Toute requte arrivant aprs 20h ou avant 7h du matin provoquera
    l'envoi d'une rponse de type 403 Forbidden. Vous pouvez utiliser
    cette technique pour vrifier toutes sortes de critres. En outre,
    si vous le prfrez, vous pouvez rediriger ou rcrire la requte.</p>

    <p>Notez que la directive <code class="directive"><a href="../mod/core.html#if">&lt;If&gt;</a></code>, introduite  partir de la version 2.4,
    permet de remplacer le module <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> dans de
    nombreuses situations o il tait traditionnellement utilis, et
    il sera probablement prfrable pour vous de tenter de l'utiliser
    avant de vous tourner vers mod_rewrite.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="moreinformation" id="moreinformation">Informations complmentaires</a></h2>

    <p>Le <a href="../expr.html">moteur d'expressions</a> vous fournit
    une grande puissance d'action en fonction de variables du serveur
    arbitraires, et il vous est conseill de consulter le document
    correspondant pour plus de dtails.</p>

    <p>De mme, vous devez lire la documentation du module
    <code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code> pour des exemples de combinaison de
    critres d'accs multiples, et en particulier la manire dont ces
    derniers interagissent.</p>

    <p>Voir aussi le How-To <a href="auth.html">Authentification and
    autorisation</a>.</p>
</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/howto/access.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../es/howto/access.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="../fr/howto/access.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/howto/access.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>