/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.Registry;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mac.BaseMac;
import gnu.javax.crypto.mac.HMacFactory;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.OMAC;
import gnu.javax.crypto.mac.TMMH16;
import gnu.javax.crypto.mac.UHash32;
import gnu.javax.crypto.mac.UMac32;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MacFactory
implements Registry {
    private static Set names;

    private MacFactory() {
    }

    public static IMac getInstance(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        if ((name = name.toLowerCase()).startsWith("hmac-")) {
            return HMacFactory.getInstance(name);
        }
        if (name.startsWith("omac-")) {
            IBlockCipher cipher = CipherFactory.getInstance(name = name.substring("omac-".length()));
            if (cipher == null) {
                return null;
            }
            return new OMAC(cipher);
        }
        BaseMac result = null;
        if (name.equalsIgnoreCase("uhash32")) {
            result = new UHash32();
        } else if (name.equalsIgnoreCase("umac32")) {
            result = new UMac32();
        } else if (name.equalsIgnoreCase("tmmh16")) {
            result = new TMMH16();
        }
        if (result != null && !result.selfTest()) {
            throw new InternalError(result.name());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set getNames() {
        Class<MacFactory> clazz = MacFactory.class;
        synchronized (MacFactory.class) {
            if (names == null) {
                HashSet<String> hs = new HashSet<String>();
                hs.addAll(HMacFactory.getNames());
                hs.add("uhash32");
                hs.add("umac32");
                hs.add("tmmh16");
                Iterator it = CipherFactory.getNames().iterator();
                while (it.hasNext()) {
                    hs.add("omac-" + it.next());
                }
                names = Collections.unmodifiableSet(hs);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return names;
        }
    }
}

