/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.EventQueue;

class EventDispatchThread
extends Thread {
    private static final int DEFAULT_PRIORITY = 6;
    private static int dispatchThreadNum;
    private EventQueue queue;

    EventDispatchThread(EventQueue queue) {
        this.setName("AWT-EventQueue-" + ++dispatchThreadNum);
        this.queue = queue;
        int priority = 6;
        try {
            String priorityString = System.getProperty("gnu.awt.dispatchthread.priority");
            if (priorityString != null) {
                priority = Integer.parseInt(priorityString);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.setPriority(priority);
        this.setDaemon(false);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    AWTEvent evt = this.queue.getNextEvent();
                    this.queue.dispatchEvent(evt);
                }
            }
            catch (ThreadDeath threadDeath) {
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Throwable x) {
                System.err.println("Exception during event dispatch:");
                x.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }
}

