/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.component.AbstractApiEndpoint;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodHelper;
import org.apache.camel.util.component.ApiName;
import org.apache.camel.util.component.PropertyNamesInterceptor;
import org.apache.camel.util.component.ResultInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiConsumerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ApiConsumerHelper.class);

    private ApiConsumerHelper() {
    }

    public static <E extends Enum<E>, T> ApiMethod findMethod(AbstractApiEndpoint<E, T> endpoint, PropertyNamesInterceptor propertyNamesInterceptor) {
        ApiMethod result;
        HashSet<String> argNames = new HashSet<String>();
        argNames.addAll(endpoint.getEndpointPropertyNames());
        propertyNamesInterceptor.interceptPropertyNames(argNames);
        String[] argNamesArray = argNames.toArray(new String[argNames.size()]);
        List<ApiMethod> filteredMethods = endpoint.methodHelper.filterMethods(endpoint.getCandidates(), ApiMethodHelper.MatchType.SUPER_SET, argNamesArray);
        if (filteredMethods.isEmpty()) {
            ApiMethodHelper<ApiMethod> methodHelper = endpoint.getMethodHelper();
            throw new IllegalArgumentException(String.format("Missing properties for %s/%s, need one or more from %s", ((ApiName)((Object)((Enum)endpoint.getApiName()))).getName(), endpoint.getMethodName(), methodHelper.getMissingProperties(endpoint.getMethodName(), argNames)));
        }
        if (filteredMethods.size() == 1) {
            result = filteredMethods.get(0);
        } else {
            result = ApiMethodHelper.getHighestPriorityMethod(filteredMethods);
            LOG.warn(String.format("Using highest priority operation %s from operations %s for endpoint %s", result, filteredMethods, endpoint.getEndpointUri()));
        }
        return result;
    }

    public static <T extends DefaultConsumer> int getResultsProcessed(T consumer, Object result, boolean splitResult) throws Exception {
        Object resultArray;
        if (result != null && splitResult && (resultArray = ((ResultInterceptor)((Object)consumer)).splitResult(result)) != result && resultArray.getClass().isArray()) {
            int length = Array.getLength(resultArray);
            for (int i = 0; i < length; ++i) {
                ApiConsumerHelper.processResult(consumer, result, Array.get(resultArray, i));
            }
            return length;
        }
        ApiConsumerHelper.processResult(consumer, result, result);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends DefaultConsumer> void processResult(T consumer, Object methodResult, Object result) throws Exception {
        Exchange exchange = consumer.getEndpoint().createExchange();
        exchange.getIn().setBody(result);
        ((ResultInterceptor)((Object)consumer)).interceptResult(methodResult, exchange);
        try {
            consumer.getProcessor().process(exchange);
        }
        finally {
            Exception exception = exchange.getException();
            if (exception != null) {
                consumer.getExceptionHandler().handleException("Error processing exchange", exchange, exception);
            }
        }
    }
}

