/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.Closeable;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentType;

public interface XContentParser
extends Closeable {
    public XContentType contentType();

    public Token nextToken() throws IOException;

    public void skipChildren() throws IOException;

    public Token currentToken();

    public String currentName() throws IOException;

    public Map<String, Object> map() throws IOException;

    public Map<String, Object> mapOrdered() throws IOException;

    public Map<String, String> mapStrings() throws IOException;

    public Map<String, String> mapStringsOrdered() throws IOException;

    public List<Object> list() throws IOException;

    public List<Object> listOrderedMap() throws IOException;

    public String text() throws IOException;

    public String textOrNull() throws IOException;

    public CharBuffer charBufferOrNull() throws IOException;

    public CharBuffer charBuffer() throws IOException;

    public Object objectText() throws IOException;

    public Object objectBytes() throws IOException;

    public boolean hasTextCharacters();

    public char[] textCharacters() throws IOException;

    public int textLength() throws IOException;

    public int textOffset() throws IOException;

    public Number numberValue() throws IOException;

    public NumberType numberType() throws IOException;

    public short shortValue(boolean var1) throws IOException;

    public int intValue(boolean var1) throws IOException;

    public long longValue(boolean var1) throws IOException;

    public float floatValue(boolean var1) throws IOException;

    public double doubleValue(boolean var1) throws IOException;

    public short shortValue() throws IOException;

    public int intValue() throws IOException;

    public long longValue() throws IOException;

    public float floatValue() throws IOException;

    public double doubleValue() throws IOException;

    public boolean isBooleanValue() throws IOException;

    public boolean booleanValue() throws IOException;

    @Deprecated
    public boolean isBooleanValueLenient() throws IOException;

    @Deprecated
    public boolean booleanValueLenient() throws IOException;

    public byte[] binaryValue() throws IOException;

    public XContentLocation getTokenLocation();

    public <T> T namedObject(Class<T> var1, String var2, Object var3) throws IOException;

    public NamedXContentRegistry getXContentRegistry();

    public boolean isClosed();

    public DeprecationHandler getDeprecationHandler();

    public static enum NumberType {
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }

    public static enum Token {
        START_OBJECT{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        END_OBJECT{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        START_ARRAY{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        END_ARRAY{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        FIELD_NAME{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        VALUE_STRING{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_NUMBER{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_BOOLEAN{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_EMBEDDED_OBJECT{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_NULL{

            @Override
            public boolean isValue() {
                return false;
            }
        };


        public abstract boolean isValue();
    }
}

