/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ack.ClusterStateUpdateRequest;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.transport.TransportMessage;

public class CreateIndexClusterStateUpdateRequest
extends ClusterStateUpdateRequest<CreateIndexClusterStateUpdateRequest> {
    private final TransportMessage originalMessage;
    private final String cause;
    private final String index;
    private final String providedName;
    private final boolean updateAllTypes;
    private Index recoverFrom;
    private ResizeType resizeType;
    private boolean copySettings;
    private IndexMetaData.State state = IndexMetaData.State.OPEN;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private final Map<String, String> mappings = new HashMap<String, String>();
    private final Set<Alias> aliases = new HashSet<Alias>();
    private final Set<ClusterBlock> blocks = new HashSet<ClusterBlock>();
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;

    public CreateIndexClusterStateUpdateRequest(TransportMessage originalMessage, String cause, String index, String providedName, boolean updateAllTypes) {
        this.originalMessage = originalMessage;
        this.cause = cause;
        this.index = index;
        this.updateAllTypes = updateAllTypes;
        this.providedName = providedName;
    }

    public CreateIndexClusterStateUpdateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest mappings(Map<String, String> mappings) {
        this.mappings.putAll(mappings);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest aliases(Set<Alias> aliases) {
        this.aliases.addAll(aliases);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest blocks(Set<ClusterBlock> blocks) {
        this.blocks.addAll(blocks);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest state(IndexMetaData.State state) {
        this.state = state;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest recoverFrom(Index recoverFrom) {
        this.recoverFrom = recoverFrom;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest resizeType(ResizeType resizeType) {
        this.resizeType = resizeType;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest copySettings(boolean copySettings) {
        this.copySettings = copySettings;
        return this;
    }

    public TransportMessage originalMessage() {
        return this.originalMessage;
    }

    public String cause() {
        return this.cause;
    }

    public String index() {
        return this.index;
    }

    public IndexMetaData.State state() {
        return this.state;
    }

    public Settings settings() {
        return this.settings;
    }

    public Map<String, String> mappings() {
        return this.mappings;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public Set<ClusterBlock> blocks() {
        return this.blocks;
    }

    public Index recoverFrom() {
        return this.recoverFrom;
    }

    public boolean updateAllTypes() {
        return this.updateAllTypes;
    }

    public String getProvidedName() {
        return this.providedName;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public ResizeType resizeType() {
        return this.resizeType;
    }

    public boolean copySettings() {
        return this.copySettings;
    }
}

