/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.search.MultiValueMode;

public final class UidIndexFieldData
implements IndexFieldData<AtomicFieldData> {
    private final Index index;
    private final BytesRef prefix;
    private final IndexFieldData<?> idFieldData;

    public UidIndexFieldData(Index index, String type, IndexFieldData<?> idFieldData) {
        this.index = index;
        BytesRefBuilder prefix = new BytesRefBuilder();
        prefix.append(new BytesRef((CharSequence)type));
        prefix.append((byte)35);
        this.prefix = prefix.toBytesRef();
        this.idFieldData = idFieldData;
    }

    @Override
    public Index index() {
        return this.index;
    }

    @Override
    public String getFieldName() {
        return "_uid";
    }

    @Override
    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
    }

    @Override
    public AtomicFieldData load(LeafReaderContext context) {
        return new UidAtomicFieldData(this.prefix, (AtomicFieldData)this.idFieldData.load(context));
    }

    @Override
    public AtomicFieldData loadDirect(LeafReaderContext context) throws Exception {
        return new UidAtomicFieldData(this.prefix, (AtomicFieldData)this.idFieldData.loadDirect(context));
    }

    @Override
    public void clear() {
        this.idFieldData.clear();
    }

    static final class UidAtomicFieldData
    implements AtomicFieldData {
        private final BytesRef prefix;
        private final AtomicFieldData idFieldData;

        UidAtomicFieldData(BytesRef prefix, AtomicFieldData idFieldData) {
            this.prefix = prefix;
            this.idFieldData = idFieldData;
        }

        @Override
        public ScriptDocValues<?> getScriptValues() {
            return new ScriptDocValues.Strings(this.getBytesValues());
        }

        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public void close() {
            this.idFieldData.close();
        }

        @Override
        public SortedBinaryDocValues getBytesValues() {
            final SortedBinaryDocValues idValues = this.idFieldData.getBytesValues();
            return new SortedBinaryDocValues(){
                private final BytesRefBuilder scratch = new BytesRefBuilder();

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return idValues.advanceExact(doc);
                }

                @Override
                public int docValueCount() {
                    return idValues.docValueCount();
                }

                @Override
                public BytesRef nextValue() throws IOException {
                    BytesRef nextID = idValues.nextValue();
                    this.scratch.copyBytes(prefix);
                    this.scratch.append(nextID);
                    return this.scratch.get();
                }
            };
        }
    }
}

