/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LatLonShapeBoundingBoxQuery;
import org.apache.lucene.document.LatLonShapeLineQuery;
import org.apache.lucene.document.LatLonShapePolygonQuery;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Tessellator;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class LatLonShape {
    public static final int BYTES = 8;
    protected static final FieldType TYPE = new FieldType();

    private LatLonShape() {
    }

    public static Field[] createIndexableFields(String fieldName, Polygon polygon) {
        List<Tessellator.Triangle> tessellation = Tessellator.tessellate(polygon);
        ArrayList<LatLonTriangle> fields = new ArrayList<LatLonTriangle>();
        for (Tessellator.Triangle t : tessellation) {
            fields.add(new LatLonTriangle(fieldName, t));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field[] createIndexableFields(String fieldName, Line line) {
        int numPoints = line.numPoints();
        ArrayList<LatLonTriangle> fields = new ArrayList<LatLonTriangle>(numPoints - 1);
        int i = 0;
        for (int j = 1; j < numPoints; ++j) {
            double temp;
            double aLat = line.getLat(i);
            double aLon = line.getLon(i);
            double bLat = line.getLat(j);
            double bLon = line.getLon(j);
            if (aLat > bLat) {
                temp = aLat;
                aLat = bLat;
                bLat = temp;
                temp = aLon;
                aLon = bLon;
                bLon = temp;
            } else if (aLat == bLat && aLon > bLon) {
                temp = aLat;
                aLat = bLat;
                bLat = temp;
                temp = aLon;
                aLon = bLon;
                bLon = temp;
            }
            fields.add(new LatLonTriangle(fieldName, aLat, aLon, bLat, bLon, aLat, aLon));
            ++i;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field[] createIndexableFields(String fieldName, double lat, double lon) {
        return new Field[]{new LatLonTriangle(fieldName, lat, lon, lat, lon, lat, lon)};
    }

    public static Query newBoxQuery(String field, QueryRelation queryRelation, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        return new LatLonShapeBoundingBoxQuery(field, queryRelation, minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    public static Query newLineQuery(String field, QueryRelation queryRelation, Line ... lines) {
        return new LatLonShapeLineQuery(field, queryRelation, lines);
    }

    public static Query newPolygonQuery(String field, QueryRelation queryRelation, Polygon ... polygons) {
        return new LatLonShapePolygonQuery(field, queryRelation, polygons);
    }

    public static void encodeTriangleBoxVal(int encodedVal, byte[] bytes, int offset) {
        long val = encodedVal ^ Integer.MIN_VALUE;
        val &= 0xFFFFFFFFL;
        NumericUtils.longToSortableBytes((long)(val ^= Long.MIN_VALUE), (byte[])bytes, (int)offset);
    }

    public static int decodeTriangleBoxVal(byte[] encoded, int offset) {
        long val = NumericUtils.sortableBytesToLong((byte[])encoded, (int)offset);
        int result = (int)(val & 0xFFFFFFFFFFFFFFFFL);
        return result ^ Integer.MIN_VALUE;
    }

    static {
        TYPE.setDimensions(7, 4, 8);
        TYPE.freeze();
    }

    public static enum QueryRelation {
        INTERSECTS,
        WITHIN,
        DISJOINT;

    }

    private static class LatLonTriangle
    extends Field {
        LatLonTriangle(String name, double aLat, double aLon, double bLat, double bLon, double cLat, double cLon) {
            super(name, (IndexableFieldType)TYPE);
            this.setTriangleValue(GeoEncodingUtils.encodeLongitude((double)aLon), GeoEncodingUtils.encodeLatitude((double)aLat), GeoEncodingUtils.encodeLongitude((double)bLon), GeoEncodingUtils.encodeLatitude((double)bLat), GeoEncodingUtils.encodeLongitude((double)cLon), GeoEncodingUtils.encodeLatitude((double)cLat));
        }

        LatLonTriangle(String name, Tessellator.Triangle t) {
            super(name, (IndexableFieldType)TYPE);
            this.setTriangleValue(t.getEncodedX(0), t.getEncodedY(0), t.getEncodedX(1), t.getEncodedY(1), t.getEncodedX(2), t.getEncodedY(2));
        }

        public void setTriangleValue(int aX, int aY, int bX, int bY, int cX, int cY) {
            byte[] bytes;
            if (this.fieldsData == null) {
                bytes = new byte[56];
                this.fieldsData = new BytesRef(bytes);
            } else {
                bytes = ((BytesRef)this.fieldsData).bytes;
            }
            int minX = StrictMath.min(aX, StrictMath.min(bX, cX));
            int minY = StrictMath.min(aY, StrictMath.min(bY, cY));
            int maxX = StrictMath.max(aX, StrictMath.max(bX, cX));
            int maxY = StrictMath.max(aY, StrictMath.max(bY, cY));
            this.encodeTriangle(bytes, minY, minX, maxY, maxX, aX, aY, bX, bY, cX, cY);
        }

        private void encodeTriangle(byte[] bytes, int minY, int minX, int maxY, int maxX, int aX, int aY, int bX, int bY, int cX, int cY) {
            LatLonShape.encodeTriangleBoxVal(minY, bytes, 0);
            LatLonShape.encodeTriangleBoxVal(minX, bytes, 8);
            LatLonShape.encodeTriangleBoxVal(maxY, bytes, 16);
            LatLonShape.encodeTriangleBoxVal(maxX, bytes, 24);
            long a = (long)aX << 32 | (long)aY & 0xFFFFFFFFL;
            long b = (long)bX << 32 | (long)bY & 0xFFFFFFFFL;
            long c = (long)cX << 32 | (long)cY & 0xFFFFFFFFL;
            NumericUtils.longToSortableBytes((long)a, (byte[])bytes, (int)32);
            NumericUtils.longToSortableBytes((long)b, (byte[])bytes, (int)40);
            NumericUtils.longToSortableBytes((long)c, (byte[])bytes, (int)48);
        }
    }
}

