/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.GIOP.v1_2;

import gnu.CORBA.CDR.AbstractCdrInput;
import gnu.CORBA.CDR.AbstractCdrOutput;
import gnu.CORBA.GIOP.CodeSetServiceContext;
import gnu.CORBA.GIOP.ServiceContext;
import java.io.IOException;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;

public class RequestHeader
extends gnu.CORBA.GIOP.v1_0.RequestHeader {
    private static final long serialVersionUID = 1L;
    public static final short KeyAddr = 0;
    public static final short ProfileAddr = 1;
    public static final short ReferenceAddr = 2;
    public byte response_flags = (byte)3;
    public short AddressingDisposition;

    public RequestHeader() {
        this.service_context = new ServiceContext[]{CodeSetServiceContext.STANDARD};
    }

    public void setResponseExpected(boolean expected) {
        this.response_expected = expected;
        this.response_flags = expected ? (byte)(this.response_flags | 3) : (byte)(this.response_flags & 0xFFFFFFFC);
    }

    public boolean isResponseExpected() {
        return this.response_expected || (this.response_flags & 3) == 3;
    }

    public void read(AbstractCdrInput in) {
        try {
            this.request_id = in.read_ulong();
            this.response_flags = (byte)in.read();
            in.skip(3L);
            this.AddressingDisposition = in.read_ushort();
            switch (this.AddressingDisposition) {
                case 0: {
                    this.object_key = in.read_sequence();
                    break;
                }
                case 1: {
                    throw new NO_IMPLEMENT("Object addressing by IOP tagged profile");
                }
                case 2: {
                    throw new NO_IMPLEMENT("Object addressing by IOR addressing info");
                }
                default: {
                    MARSHAL m = new MARSHAL("Unknow addressing method in request, " + this.AddressingDisposition);
                    m.minor = 1195573272;
                    throw m;
                }
            }
            this.operation = in.read_string();
            this.service_context = ServiceContext.readSequence(in);
            in.setCodeSet(CodeSetServiceContext.find(this.service_context));
        }
        catch (IOException ex) {
            MARSHAL t = new MARSHAL();
            t.minor = 1195573250;
            t.initCause(ex);
            throw t;
        }
    }

    public String toString() {
        return "Request " + this.request_id + ", call '" + this.operation + "' on " + this.bytes(this.object_key) + ", " + (this.response_expected ? "wait response" : "one way") + " addressed by " + " method " + this.AddressingDisposition + "." + this.contexts();
    }

    public void write(AbstractCdrOutput out) {
        out.write_ulong(this.request_id);
        out.write(this.response_flags);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write_ushort((short)0);
        out.write_sequence(this.object_key);
        out.write_string(this.operation);
        ServiceContext.writeSequence(out, this.service_context);
        out.setCodeSet(CodeSetServiceContext.find(this.service_context));
    }
}

