/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.event;

import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.transport.JdwpCommandPacket;
import gnu.classpath.jdwp.transport.JdwpPacket;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Event {
    public static final int EVENT_CLASS = 1;
    public static final int EVENT_THREAD = 2;
    public static final int EVENT_LOCATION = 3;
    public static final int EVENT_INSTANCE = 4;
    public static final int EVENT_FIELD = 5;
    public static final int EVENT_EXCEPTION_CLASS = 6;
    public static final int EVENT_EXCEPTION_CAUGHT = 7;
    private byte _eventKind;

    public Event(byte kind) {
        this._eventKind = kind;
    }

    public byte getEventKind() {
        return this._eventKind;
    }

    protected abstract void _writeData(DataOutputStream var1) throws IOException;

    public abstract Object getParameter(int var1);

    public static JdwpPacket toPacket(DataOutputStream dos, Event[] events, EventRequest[] requests, byte suspendPolicy) {
        JdwpCommandPacket pkt;
        try {
            dos.writeByte(suspendPolicy);
            dos.writeInt(events.length);
            int i = 0;
            while (i < events.length) {
                Event._toData(dos, events[i], requests[i]);
                ++i;
            }
            pkt = new JdwpCommandPacket(64, 100);
        }
        catch (IOException iOException) {
            pkt = null;
        }
        return pkt;
    }

    private static void _toData(DataOutputStream dos, Event event, EventRequest request) throws IOException {
        dos.writeByte(event._eventKind);
        dos.writeInt(request.getId());
        event._writeData(dos);
    }
}

