/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.tools.jarsigner.Main;
import gnu.classpath.tools.jarsigner.Messages;
import gnu.classpath.tools.jarsigner.SFHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;

public class JarSigner {
    private static final Logger log = Logger.getLogger(JarSigner.class.getName());
    private Main main;

    JarSigner(Main main) {
        this.main = main;
    }

    void start() throws Exception {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        JarFile jarFile = new JarFile(this.main.getJarFileName());
        SFHelper sfHelper = new SFHelper(jarFile);
        sfHelper.startSigning();
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            String jeName = je.getName();
            if (jeName.equals("META-INF/MANIFEST.MF") || jeName.endsWith(File.separator)) continue;
            sfHelper.updateEntry(je);
            if (!this.main.isVerbose()) continue;
            System.out.println(String.valueOf(Messages.getString("JarSigner.1")) + jeName);
        }
        sfHelper.finishSigning(this.main.isSectionsOnly());
        if (this.main.isVerbose()) {
            System.out.println(String.valueOf(Messages.getString("JarSigner.2")) + "META-INF/MANIFEST.MF");
        }
        File signedJarFile = File.createTempFile("gcp-", ".jar");
        FileOutputStream fos = new FileOutputStream(signedJarFile);
        JarOutputStream outSignedJarFile = new JarOutputStream((OutputStream)fos, sfHelper.getManifest());
        Enumeration<JarEntry> e2 = jarFile.entries();
        while (e2.hasMoreElements()) {
            JarEntry je = e2.nextElement();
            String jeName = je.getName();
            if (jeName.equals("META-INF/MANIFEST.MF") || jeName.endsWith(File.separator)) continue;
            log.finest("Processing " + jeName);
            JarEntry newEntry = new JarEntry(jeName);
            newEntry.setTime(je.getTime());
            outSignedJarFile.putNextEntry(newEntry);
            InputStream jeis = jarFile.getInputStream(je);
            this.copyFromTo(jeis, outSignedJarFile);
        }
        String signaturesFileName = this.main.getSigFileName();
        String sfFileName = "META-INF/" + signaturesFileName + ".SF";
        if (Configuration.DEBUG) {
            log.fine("Processing " + sfFileName);
        }
        JarEntry sfEntry = new JarEntry(sfFileName);
        sfEntry.setTime(System.currentTimeMillis());
        outSignedJarFile.putNextEntry(sfEntry);
        sfHelper.writeSF(outSignedJarFile);
        if (Configuration.DEBUG) {
            log.fine("Created .SF file");
        }
        if (this.main.isVerbose()) {
            System.out.println(String.valueOf(Messages.getString("JarSigner.8")) + sfFileName);
        }
        String dsaFileName = "META-INF/" + signaturesFileName + ".DSA";
        if (Configuration.DEBUG) {
            log.fine("Processing " + dsaFileName);
        }
        JarEntry dsaEntry = new JarEntry(dsaFileName);
        dsaEntry.setTime(System.currentTimeMillis());
        outSignedJarFile.putNextEntry(dsaEntry);
        sfHelper.writeDSA(outSignedJarFile, this.main.getSignerPrivateKey(), this.main.getSignerCertificateChain(), this.main.isInternalSF());
        if (Configuration.DEBUG) {
            log.fine("Created .DSA file");
        }
        if (this.main.isVerbose()) {
            System.out.println(String.valueOf(Messages.getString("JarSigner.8")) + dsaFileName);
        }
        outSignedJarFile.close();
        fos.close();
        signedJarFile.renameTo(new File(this.main.getSignedJarFileName()));
        if (Configuration.DEBUG) {
            log.fine("Renamed signed JAR file");
        }
        if (this.main.isVerbose()) {
            System.out.println(String.valueOf(SystemProperties.getProperty((String)"line.separator")) + Messages.getString("JarSigner.14"));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    private void copyFromTo(InputStream in, JarOutputStream out) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        while ((n = in.read(buffer)) != -1) {
            if (n <= 0) continue;
            out.write(buffer, 0, n);
        }
    }
}

