/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui;

import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.JavaClass;
import jadx.api.JavaPackage;
import jadx.api.ResourceFile;
import jadx.gui.settings.JadxSettings;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.swing.ProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(JadxWrapper.class);
    private final JadxSettings settings;
    private JadxDecompiler decompiler;
    private File openFile;

    public JadxWrapper(JadxSettings settings) {
        this.settings = settings;
    }

    public void openFile(File file) {
        this.openFile = file;
        try {
            this.decompiler = new JadxDecompiler(this.settings.toJadxArgs());
            this.decompiler.getArgs().setInputFiles(Collections.singletonList(file));
            this.decompiler.load();
        }
        catch (Exception e) {
            LOG.error("Error load file: {}", (Object)file, (Object)e);
        }
    }

    public void saveAll(final File dir, final ProgressMonitor progressMonitor) {
        Runnable save = new Runnable(){

            @Override
            public void run() {
                try {
                    JadxWrapper.this.decompiler.getArgs().setRootDir(dir);
                    ThreadPoolExecutor ex = (ThreadPoolExecutor)JadxWrapper.this.decompiler.getSaveExecutor();
                    ex.shutdown();
                    while (ex.isTerminating()) {
                        long total = ex.getTaskCount();
                        long done = ex.getCompletedTaskCount();
                        progressMonitor.setProgress((int)((double)done * 100.0 / (double)total));
                        Thread.sleep(500L);
                    }
                    progressMonitor.close();
                    LOG.info("decompilation complete, freeing memory ...");
                    JadxWrapper.this.decompiler.getClasses().forEach(JavaClass::unload);
                    LOG.info("done");
                }
                catch (InterruptedException e) {
                    LOG.error("Save interrupted", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        };
        new Thread(save).start();
    }

    public List<JavaClass> getClasses() {
        return this.decompiler.getClasses();
    }

    public List<JavaClass> getIncludedClasses() {
        List classList = this.decompiler.getClasses();
        String excludedPackages = this.settings.getExcludedPackages().trim();
        if (excludedPackages.length() == 0) {
            return classList;
        }
        String[] excluded = excludedPackages.split("[ ]+");
        return classList.stream().filter(cls -> {
            for (String exclude : excluded) {
                if (!cls.getFullName().startsWith(exclude)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public List<JavaPackage> getPackages() {
        return this.decompiler.getPackages();
    }

    public List<ResourceFile> getResources() {
        return this.decompiler.getResources();
    }

    public File getOpenFile() {
        return this.openFile;
    }

    public JadxArgs getArgs() {
        return this.decompiler.getArgs();
    }
}

