/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory.soft;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.memory.AbstractMemoryCache;
import org.apache.commons.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs.engine.memory.util.SoftReferenceElementDescriptor;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SoftReferenceMemoryCache<K, V>
extends AbstractMemoryCache<K, V> {
    private static final Log log = LogFactory.getLog(SoftReferenceMemoryCache.class);
    private LinkedBlockingQueue<ICacheElement<K, V>> strongReferences;

    @Override
    public synchronized void initialize(CompositeCache<K, V> hub) {
        super.initialize(hub);
        this.strongReferences = new LinkedBlockingQueue();
        log.info("initialized Soft Reference Memory Cache for " + this.getCacheName());
    }

    @Override
    public ConcurrentMap<K, MemoryElementDescriptor<K, V>> createMap() {
        return new ConcurrentHashMap();
    }

    @Override
    public Set<K> getKeySet() {
        HashSet keys = new HashSet();
        for (Map.Entry e : this.map.entrySet()) {
            SoftReferenceElementDescriptor sred = (SoftReferenceElementDescriptor)e.getValue();
            if (sred.getCacheElement() == null) continue;
            keys.add(e.getKey());
        }
        return keys;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (MemoryElementDescriptor me : this.map.values()) {
            SoftReferenceElementDescriptor sred = (SoftReferenceElementDescriptor)me;
            if (sred.getCacheElement() == null) continue;
            ++size;
        }
        return size;
    }

    @Override
    public IStats getStatistics() {
        IStats stats = super.getStatistics();
        stats.setTypeName("Soft Reference Memory Cache");
        List<IStatElement<?>> elems = stats.getStatElements();
        int emptyrefs = this.map.size() - this.getSize();
        elems.add(new StatElement<Integer>("Empty References", emptyrefs));
        elems.add(new StatElement<Integer>("Strong References", this.strongReferences.size()));
        return stats;
    }

    @Override
    protected void lockedGetElement(MemoryElementDescriptor<K, V> me) {
        ICacheElement<K, V> val = me.getCacheElement();
        val.getElementAttributes().setLastAccessTimeNow();
        this.strongReferences.add(val);
        this.trimStrongReferences();
    }

    @Override
    protected void lockedRemoveElement(MemoryElementDescriptor<K, V> me) {
        this.strongReferences.remove(me.getCacheElement());
    }

    @Override
    protected void lockedRemoveAll() {
        this.strongReferences.clear();
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        this.putCnt.incrementAndGet();
        ce.getElementAttributes().setLastAccessTimeNow();
        this.lock.lock();
        try {
            this.map.put(ce.getKey(), new SoftReferenceElementDescriptor<K, V>(ce));
            this.strongReferences.add(ce);
            this.trimStrongReferences();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void trimStrongReferences() {
        int startsize;
        int max = this.getCacheAttributes().getMaxObjects();
        for (int cursize = startsize = this.strongReferences.size(); cursize > max; --cursize) {
            ICacheElement<K, V> ce = this.strongReferences.poll();
            this.waterfal(ce);
        }
    }

    @Override
    public int freeElements(int numberToFree) throws IOException {
        return 0;
    }
}

