/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.office;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.report.JFreeReport;
import org.libreoffice.report.pentaho.model.OfficeDocument;
import org.libreoffice.report.pentaho.model.OfficeStylesCollection;
import org.libreoffice.report.pentaho.parser.office.BodyReadHandler;
import org.libreoffice.report.pentaho.parser.office.FontFaceDeclsReadHandler;
import org.libreoffice.report.pentaho.parser.office.MasterStylesReadHandler;
import org.libreoffice.report.pentaho.parser.style.OfficeStylesReadHandler;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DocumentContentReadHandler
extends AbstractXmlReadHandler {
    private static final Log LOGGER = LogFactory.getLog(DocumentContentReadHandler.class);
    private OfficeDocument report;
    private FontFaceDeclsReadHandler fontFaceReadHandler;
    private BodyReadHandler bodyReadHandler;
    private OfficeStylesCollection officeStylesCollection;

    protected void startParsing(Attributes attributes) throws SAXException {
        super.startParsing(attributes);
        this.report = this.parseContentXml();
        this.report.setVirtual(true);
        this.report.setType("document-content");
        this.report.setNamespace("urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        this.report.setVirtual(true);
        this.officeStylesCollection = this.parseStylesXml();
    }

    private OfficeStylesCollection parseStylesXml() {
        ResourceKey resourceKey = this.getRootHandler().getContext();
        ResourceManager resourceManager = this.getRootHandler().getResourceManager();
        try {
            ResourceKey resourceKey2 = resourceManager.deriveKey(resourceKey, "styles.xml");
            Resource resource = resourceManager.create(resourceKey2, resourceKey, OfficeStylesCollection.class);
            OfficeStylesCollection officeStylesCollection = (OfficeStylesCollection)resource.getResource();
            if (officeStylesCollection != null) {
                return officeStylesCollection;
            }
        }
        catch (ResourceKeyCreationException resourceKeyCreationException) {
            LOGGER.debug("Failed to create resource-key for 'styles.xml'. Ignoring.", resourceKeyCreationException);
        }
        catch (ResourceException resourceException) {
            LOGGER.debug("Failed to parse resource for 'styles.xml'. Ignoring.", resourceException);
        }
        return new OfficeStylesCollection();
    }

    private OfficeDocument parseContentXml() {
        if (!"urn:oasis:names:tc:opendocument:xmlns:office:1.0".equals(this.getUri()) || "document-content".equals(this.getTagName())) {
            return new OfficeDocument();
        }
        ResourceKey resourceKey = this.getRootHandler().getContext();
        ResourceManager resourceManager = this.getRootHandler().getResourceManager();
        try {
            ResourceKey resourceKey2 = resourceManager.deriveKey(resourceKey, "content.xml");
            Resource resource = resourceManager.create(resourceKey2, resourceKey, JFreeReport.class);
            OfficeDocument officeDocument = (OfficeDocument)resource.getResource();
            if (officeDocument != null) {
                return officeDocument;
            }
        }
        catch (ResourceKeyCreationException resourceKeyCreationException) {
            LOGGER.debug("Failed to create resource-key for 'content.xml'. Ignoring.");
        }
        catch (ResourceException resourceException) {
            LOGGER.debug("Failed to parse resource for 'content.xml'. Ignoring.");
        }
        return new OfficeDocument();
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        if ("urn:oasis:names:tc:opendocument:xmlns:office:1.0".equals(string)) {
            if ("font-face-decls".equals(string2)) {
                if (this.fontFaceReadHandler == null) {
                    this.fontFaceReadHandler = new FontFaceDeclsReadHandler(this.officeStylesCollection.getFontFaceDecls());
                }
                return this.fontFaceReadHandler;
            }
            if ("automatic-styles".equals(string2)) {
                return new OfficeStylesReadHandler(this.officeStylesCollection.getAutomaticStyles());
            }
            if ("styles".equals(string2)) {
                return new OfficeStylesReadHandler(this.officeStylesCollection.getCommonStyles());
            }
            if ("master-styles".equals(string2)) {
                return new MasterStylesReadHandler(this.officeStylesCollection.getMasterStyles());
            }
            if ("body".equals(string2)) {
                this.bodyReadHandler = new BodyReadHandler();
                return this.bodyReadHandler;
            }
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        this.report.setStylesCollection(this.officeStylesCollection);
        if (this.bodyReadHandler != null) {
            this.report.addNode(this.bodyReadHandler.getElement());
        }
    }

    public Object getObject() throws SAXException {
        return this.report;
    }
}

