/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.merge;

import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.MergeException;
import org.openoffice.xmerge.merger.Difference;
import org.openoffice.xmerge.merger.Iterator;
import org.openoffice.xmerge.merger.MergeAlgorithm;
import org.openoffice.xmerge.merger.NodeMergeAlgorithm;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentMerge
implements MergeAlgorithm {
    private final NodeMergeAlgorithm subDocumentMerge;
    protected ConverterCapabilities cc_;

    public DocumentMerge(ConverterCapabilities converterCapabilities, NodeMergeAlgorithm nodeMergeAlgorithm) {
        this.cc_ = converterCapabilities;
        this.subDocumentMerge = nodeMergeAlgorithm;
    }

    public void applyDifference(Iterator iterator, Iterator iterator2, Difference[] differenceArray) throws MergeException {
        int n = -1;
        boolean bl = false;
        for (Difference difference : differenceArray) {
            if (difference.getOrgPosition() > n) {
                n = difference.getOrgPosition();
                bl = difference.getOperation() == 2;
                continue;
            }
            if (difference.getOrgPosition() == n) {
                if (difference.getOperation() == 2) {
                    bl = true;
                    continue;
                }
                if (difference.getOperation() != 1 || !bl) continue;
                throw new MergeException("Differences array is not sorted. Delete before Add");
            }
            throw new MergeException("Differences array need to be sorted.");
        }
        iterator.start();
        int n2 = 0;
        iterator2.start();
        int n3 = 0;
        block6: for (Difference difference : differenceArray) {
            int n4 = difference.getOperation();
            switch (n4) {
                case 2: {
                    while (n2 < difference.getOrgPosition()) {
                        ++n2;
                        iterator.next();
                    }
                    this.removeNode((Node)iterator.currentElement());
                    continue block6;
                }
                case 1: {
                    while (n3 < difference.getModPosition()) {
                        ++n3;
                        iterator2.next();
                    }
                    while (n2 < difference.getOrgPosition()) {
                        ++n2;
                        iterator.next();
                    }
                    if (n2 > iterator.elementCount() - 1) {
                        this.appendNode((Node)iterator.currentElement(), (Node)iterator2.currentElement());
                        continue block6;
                    }
                    this.insertNode((Node)iterator.currentElement(), (Node)iterator2.currentElement());
                    continue block6;
                }
                case 3: {
                    while (n3 < difference.getModPosition()) {
                        ++n3;
                        iterator2.next();
                    }
                    while (n2 < difference.getOrgPosition()) {
                        ++n2;
                        iterator.next();
                    }
                    if (this.subDocumentMerge == null) {
                        this.replaceElement((Element)iterator.currentElement(), (Element)iterator2.currentElement());
                        continue block6;
                    }
                    this.subDocumentMerge.merge((Element)iterator.currentElement(), (Element)iterator2.currentElement());
                    continue block6;
                }
            }
        }
    }

    protected void removeNode(Node node) {
        Node node2 = node.getParentNode();
        node2.removeChild(node);
    }

    private void appendNode(Node node, Node node2) {
        Node node3 = XmlUtil.deepClone(node, node2);
        Node node4 = node.getParentNode();
        node4.appendChild(node3);
    }

    private void insertNode(Node node, Node node2) {
        Node node3 = XmlUtil.deepClone(node, node2);
        Node node4 = node.getParentNode();
        node4.insertBefore(node3, node);
    }

    private void replaceElement(Element element, Element element2) {
        Node node = XmlUtil.deepClone(element, element2);
        Node node2 = element.getParentNode();
        node2.replaceChild(node, element);
    }
}

