/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataDeploymentException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataInstallationException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataReadException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.apache.maven.repository.legacy.UpdateCheckManager;
import org.apache.maven.repository.legacy.WagonManager;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=RepositoryMetadataManager.class)
public class DefaultRepositoryMetadataManager
extends AbstractLogEnabled
implements RepositoryMetadataManager {
    @Requirement
    private WagonManager wagonManager;
    @Requirement
    private UpdateCheckManager updateCheckManager;

    public void resolve(RepositoryMetadata metadata, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws RepositoryMetadataResolutionException {
        DefaultRepositoryRequest request = new DefaultRepositoryRequest();
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        this.resolve(metadata, (RepositoryRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(RepositoryMetadata metadata, RepositoryRequest request) throws RepositoryMetadataResolutionException {
        ArtifactRepository localRepo = request.getLocalRepository();
        List remoteRepositories = request.getRemoteRepositories();
        if (!request.isOffline()) {
            Date localCopyLastModified = null;
            if (metadata.getBaseVersion() != null) {
                localCopyLastModified = this.getLocalCopyLastModified(localRepo, metadata);
            }
            for (ArtifactRepository repository : remoteRepositories) {
                File file;
                block23: {
                    boolean update;
                    ArtifactRepositoryPolicy policy = metadata.getPolicy(repository);
                    file = new File(localRepo.getBasedir(), localRepo.pathOfLocalRepositoryMetadata((ArtifactMetadata)metadata, repository));
                    if (!policy.isEnabled()) {
                        update = false;
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Skipping update check for " + metadata.getKey() + " (" + file + ") from disabled repository " + repository.getId() + " (" + repository.getUrl() + ")");
                        }
                    } else if (request.isForceUpdate()) {
                        update = true;
                    } else if (localCopyLastModified != null && !policy.checkOutOfDate(localCopyLastModified)) {
                        update = false;
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Skipping update check for " + metadata.getKey() + " (" + file + ") from repository " + repository.getId() + " (" + repository.getUrl() + ") in favor of local copy");
                        }
                    } else {
                        update = this.updateCheckManager.isUpdateRequired(metadata, repository, file);
                    }
                    if (update) {
                        this.getLogger().info(metadata.getKey() + ": checking for updates from " + repository.getId());
                        try {
                            this.wagonManager.getArtifactMetadata((ArtifactMetadata)metadata, repository, file, policy.getChecksumPolicy());
                        }
                        catch (ResourceDoesNotExistException e) {
                            this.getLogger().debug(metadata + " could not be found on repository: " + repository.getId());
                            if (!file.exists() || file.delete()) break block23;
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            file.delete();
                        }
                        catch (TransferFailedException e) {
                            this.getLogger().warn(metadata + " could not be retrieved from repository: " + repository.getId() + " due to an error: " + e.getMessage());
                            this.getLogger().debug("Exception", (Throwable)e);
                        }
                        finally {
                            this.updateCheckManager.touch(metadata, repository, file);
                        }
                    }
                }
                if (!file.exists()) continue;
                file.setLastModified(System.currentTimeMillis());
            }
        }
        try {
            this.mergeMetadata(metadata, remoteRepositories, localRepo);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataResolutionException("Unable to store local copy of metadata: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private Date getLocalCopyLastModified(ArtifactRepository localRepository, RepositoryMetadata metadata) {
        String metadataPath = localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)metadata, localRepository);
        File metadataFile = new File(localRepository.getBasedir(), metadataPath);
        return metadataFile.isFile() ? new Date(metadataFile.lastModified()) : null;
    }

    private void mergeMetadata(RepositoryMetadata metadata, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws RepositoryMetadataStoreException {
        HashMap<ArtifactRepository, Metadata> previousMetadata = new HashMap<ArtifactRepository, Metadata>();
        ArtifactRepository selected = null;
        for (ArtifactRepository repository : remoteRepositories) {
            ArtifactRepositoryPolicy policy = metadata.getPolicy(repository);
            if (!policy.isEnabled() || !this.loadMetadata(metadata, repository, localRepository, previousMetadata)) continue;
            metadata.setRepository(repository);
            selected = repository;
        }
        if (this.loadMetadata(metadata, localRepository, localRepository, previousMetadata)) {
            metadata.setRepository(null);
            selected = localRepository;
        }
        this.updateSnapshotMetadata(metadata, previousMetadata, selected, localRepository);
    }

    private void updateSnapshotMetadata(RepositoryMetadata metadata, Map<ArtifactRepository, Metadata> previousMetadata, ArtifactRepository selected, ArtifactRepository localRepository) throws RepositoryMetadataStoreException {
        if (metadata.isSnapshot()) {
            Metadata prevMetadata = metadata.getMetadata();
            for (ArtifactRepository repository : previousMetadata.keySet()) {
                Metadata m = previousMetadata.get(repository);
                if (repository.equals(selected)) {
                    if (m.getVersioning() == null) {
                        m.setVersioning(new Versioning());
                    }
                    if (m.getVersioning().getSnapshot() != null) continue;
                    m.getVersioning().setSnapshot(new Snapshot());
                    continue;
                }
                if (m.getVersioning() == null || m.getVersioning().getSnapshot() == null || !m.getVersioning().getSnapshot().isLocalCopy()) continue;
                m.getVersioning().getSnapshot().setLocalCopy(false);
                metadata.setMetadata(m);
                metadata.storeInLocalRepository(localRepository, repository);
            }
            metadata.setMetadata(prevMetadata);
        }
    }

    private boolean loadMetadata(RepositoryMetadata repoMetadata, ArtifactRepository remoteRepository, ArtifactRepository localRepository, Map<ArtifactRepository, Metadata> previousMetadata) {
        boolean setRepository = false;
        File metadataFile = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)repoMetadata, remoteRepository));
        if (metadataFile.exists()) {
            Metadata metadata;
            try {
                metadata = this.readMetadata(metadataFile);
            }
            catch (RepositoryMetadataReadException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().warn(e.getMessage(), (Throwable)e);
                } else {
                    this.getLogger().warn(e.getMessage());
                }
                return setRepository;
            }
            if (repoMetadata.isSnapshot() && previousMetadata != null) {
                previousMetadata.put(remoteRepository, metadata);
            }
            if (repoMetadata.getMetadata() != null) {
                setRepository = repoMetadata.getMetadata().merge(metadata);
            } else {
                repoMetadata.setMetadata(metadata);
                setRepository = true;
            }
        }
        return setRepository;
    }

    protected Metadata readMetadata(File mappingFile) throws RepositoryMetadataReadException {
        Metadata result;
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)mappingFile);){
            MetadataXpp3Reader mappingReader = new MetadataXpp3Reader();
            result = mappingReader.read((Reader)reader, false);
        }
        catch (FileNotFoundException e) {
            throw new RepositoryMetadataReadException("Cannot read metadata from '" + mappingFile + "'", e);
        }
        catch (IOException | XmlPullParserException e) {
            throw new RepositoryMetadataReadException("Cannot read metadata from '" + mappingFile + "': " + e.getMessage(), (Exception)e);
        }
        return result;
    }

    private void fixTimestamp(File metadataFile, Metadata metadata, Metadata reference) {
        Object versioningRef;
        boolean changed = false;
        if (metadata != null && reference != null) {
            Versioning versioning = metadata.getVersioning();
            versioningRef = reference.getVersioning();
            if (versioning != null && versioningRef != null) {
                String lastUpdated = versioning.getLastUpdated();
                String now = versioningRef.getLastUpdated();
                if (lastUpdated != null && now != null && now.compareTo(lastUpdated) < 0) {
                    this.getLogger().warn("The last updated timestamp in " + metadataFile + " refers to the future (now = " + now + ", lastUpdated = " + lastUpdated + "). Please verify that the clocks of all" + " deploying machines are reasonably synchronized.");
                    versioning.setLastUpdated(now);
                    changed = true;
                }
            }
        }
        if (changed) {
            this.getLogger().debug("Repairing metadata in " + metadataFile);
            try {
                XmlStreamWriter writer = WriterFactory.newXmlWriter((File)metadataFile);
                versioningRef = null;
                try {
                    new MetadataXpp3Writer().write((Writer)writer, metadata);
                }
                catch (Throwable throwable) {
                    versioningRef = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (versioningRef != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)versioningRef).addSuppressed(x2);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                String msg = "Could not write fixed metadata to " + metadataFile + ": " + e.getMessage();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().warn(msg, (Throwable)e);
                }
                this.getLogger().warn(msg);
            }
        }
    }

    public void resolveAlways(RepositoryMetadata metadata, ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataResolutionException {
        File file;
        try {
            file = this.getArtifactMetadataFromDeploymentRepository((ArtifactMetadata)metadata, localRepository, remoteRepository);
        }
        catch (TransferFailedException e) {
            throw new RepositoryMetadataResolutionException(metadata + " could not be retrieved from repository: " + remoteRepository.getId() + " due to an error: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            if (file.exists()) {
                Metadata prevMetadata = this.readMetadata(file);
                metadata.setMetadata(prevMetadata);
            }
        }
        catch (RepositoryMetadataReadException e) {
            throw new RepositoryMetadataResolutionException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getArtifactMetadataFromDeploymentRepository(ArtifactMetadata metadata, ArtifactRepository localRepo, ArtifactRepository remoteRepository) throws TransferFailedException {
        File file;
        block8: {
            file = new File(localRepo.getBasedir(), localRepo.pathOfLocalRepositoryMetadata(metadata, remoteRepository));
            try {
                this.wagonManager.getArtifactMetadataFromDeploymentRepository(metadata, remoteRepository, file, "warn");
            }
            catch (ResourceDoesNotExistException e) {
                this.getLogger().info(metadata + " could not be found on repository: " + remoteRepository.getId() + ", so will be created");
                if (!file.exists() || file.delete()) break block8;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                file.delete();
            }
            finally {
                if (metadata instanceof RepositoryMetadata) {
                    this.updateCheckManager.touch((RepositoryMetadata)metadata, remoteRepository, file);
                }
            }
        }
        return file;
    }

    public void deploy(ArtifactMetadata metadata, ArtifactRepository localRepository, ArtifactRepository deploymentRepository) throws RepositoryMetadataDeploymentException {
        File file;
        if (metadata instanceof RepositoryMetadata) {
            this.getLogger().info("Retrieving previous metadata from " + deploymentRepository.getId());
            try {
                file = this.getArtifactMetadataFromDeploymentRepository(metadata, localRepository, deploymentRepository);
            }
            catch (TransferFailedException e) {
                throw new RepositoryMetadataDeploymentException(metadata + " could not be retrieved from repository: " + deploymentRepository.getId() + " due to an error: " + e.getMessage(), (Exception)((Object)e));
            }
            if (file.isFile()) {
                try {
                    this.fixTimestamp(file, this.readMetadata(file), ((RepositoryMetadata)metadata).getMetadata());
                }
                catch (RepositoryMetadataReadException e) {}
            }
        } else {
            file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(metadata, deploymentRepository));
        }
        try {
            metadata.storeInLocalRepository(localRepository, deploymentRepository);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataDeploymentException("Error installing metadata: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            this.wagonManager.putArtifactMetadata(file, metadata, deploymentRepository);
        }
        catch (TransferFailedException e) {
            throw new RepositoryMetadataDeploymentException("Error while deploying metadata: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void install(ArtifactMetadata metadata, ArtifactRepository localRepository) throws RepositoryMetadataInstallationException {
        try {
            metadata.storeInLocalRepository(localRepository, localRepository);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataInstallationException("Error installing metadata: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

