/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.openide.util.Utilities;

public class LinkSupport {
    private LinkSupport() {
    }

    public static String getOriginalFile(String linkPath) {
        return LinkSupport.getOriginalFile(linkPath, 10);
    }

    public static String resolveWindowsLink(String linkPath) {
        if (Utilities.isWindows()) {
            File file = new File(linkPath);
            if (file.exists() ? !LinkSupport.isLinkFile(linkPath) : !(file = new File(linkPath + ".lnk")).exists()) {
                return linkPath;
            }
            String resolved = LinkSupport.getOriginalFile(file.getAbsolutePath());
            if (resolved != null) {
                return resolved;
            }
        }
        return linkPath;
    }

    public static boolean isLinkFile(String linkPath) {
        try {
            new LinkReader(linkPath);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static String getOriginalFile(String linkPath, int level) {
        LinkReader lr;
        if (--level == 0) {
            return null;
        }
        try {
            lr = new LinkReader(linkPath);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        linkPath = lr.getSource();
        if (linkPath == null) {
            return null;
        }
        File linkFile = new File(linkPath);
        if (linkFile.exists()) {
            if (linkPath.endsWith(".lnk")) {
                return LinkSupport.getOriginalFile(linkPath, level);
            }
            if (LinkSupport.isLinkFile(linkPath)) {
                return LinkSupport.getOriginalFile(linkPath, level);
            }
            return linkFile.getAbsolutePath();
        }
        if (new File(linkPath + ".lnk").exists()) {
            return LinkSupport.getOriginalFile(linkPath + ".lnk", level);
        }
        return linkPath;
    }

    private static class LinkReader {
        private RandomAccessFile reader;
        private String sourcePath;
        private String path;
        private boolean isLSB = true;
        private boolean isShellItemPresent;
        private boolean isDescriptionPresent;
        private boolean isRelativePathPresent;

        public LinkReader(String objFileName) throws FileNotFoundException, IOException {
            this.reader = new RandomAccessFile(objFileName, "r");
            this.path = objFileName;
            this.readMagic();
        }

        public String getSource() {
            return this.sourcePath;
        }

        private boolean readCygwinLink() throws IOException {
            int i;
            int length;
            StringBuilder buf = new StringBuilder();
            int first = this.reader.readShort() & 0xFFFF;
            if (first == 65534) {
                length = (int)(this.reader.length() - 12L) / 2;
                if (length > 512) {
                    return false;
                }
                while (length > 0) {
                    --length;
                    byte ch1 = this.reader.readByte();
                    byte ch2 = this.reader.readByte();
                    if (ch1 != 0 || ch2 != 0) {
                        char c = (char)(ch1 + (ch2 << 8));
                        buf.append(c);
                        continue;
                    }
                    break;
                }
            } else {
                this.reader.seek(10L);
                if (length > 512) {
                    return false;
                }
                for (length = (int)(this.reader.length() - 10L); length > 0; --length) {
                    byte ch = this.reader.readByte();
                    char c = (char)ch;
                    if (c != '\u0000' && c != '\r' && c != '\n') {
                        buf.append(c);
                        continue;
                    }
                    break;
                }
            }
            this.sourcePath = buf.toString();
            if (this.sourcePath.startsWith("/")) {
                i = this.path.indexOf("\\bin\\");
                if (i < 0) {
                    i = this.path.indexOf("/bin/");
                }
                if (i < 0) {
                    i = this.path.indexOf("\\etc\\");
                }
                if (i < 0) {
                    i = this.path.indexOf("/etc/");
                }
                if (i > 0) {
                    this.sourcePath = this.path.substring(0, i) + this.sourcePath;
                }
                if ((i = this.sourcePath.indexOf("/usr/bin/")) > 0) {
                    this.sourcePath = this.sourcePath.substring(0, i + 1) + this.sourcePath.substring(i + 5);
                }
            } else if (this.sourcePath.length() <= 2 || this.sourcePath.charAt(1) != ':') {
                i = this.path.lastIndexOf("\\");
                if (i < 0) {
                    i = this.path.lastIndexOf("/");
                }
                if (i > 0) {
                    this.sourcePath = this.path.substring(0, i + 1) + this.sourcePath;
                }
            }
            return true;
        }

        private void readMagic() throws IOException {
            byte[] bytes = new byte[4];
            try {
                this.reader.readFully(bytes);
                if (this.isWindowsLinkMagic(bytes) ? this.readWindowsLink(bytes) : this.isCygwinLinkMagic(bytes) && this.readCygwinLink()) {
                    return;
                }
                throw new IOException();
            }
            finally {
                this.dispose();
            }
        }

        public void dispose() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                this.reader = null;
            }
        }

        private boolean isWindowsLinkMagic(byte[] bytes) {
            return bytes[0] == 76 && bytes[1] == 0 && bytes[2] == 0 && bytes[3] == 0;
        }

        private boolean isCygwinLinkMagic(byte[] bytes) throws IOException {
            if (bytes[0] == 33 && bytes[1] == 60 && bytes[2] == 115 && bytes[3] == 121) {
                bytes = new byte[6];
                this.reader.readFully(bytes);
                if (bytes[0] == 109 && bytes[1] == 108 && bytes[2] == 105 && bytes[3] == 110 && bytes[4] == 107 && bytes[5] == 62) {
                    return true;
                }
            }
            return false;
        }

        private void readFlags(byte[] bytes) {
            byte flag = bytes[0];
            if ((flag & 1) != 0) {
                this.isShellItemPresent = true;
            }
            if ((flag & 4) != 0) {
                this.isDescriptionPresent = true;
            }
            if ((flag & 8) != 0) {
                this.isRelativePathPresent = true;
            }
        }

        private long readNumber(int size) throws IOException {
            byte[] bytes = new byte[size];
            long n = 0L;
            this.reader.readFully(bytes);
            for (int i = 0; i < size; ++i) {
                long u = this.isLSB ? (long)(0xFF & bytes[i]) : (long)(0xFF & bytes[size - i - 1]);
                n |= u << i * 8;
            }
            return n;
        }

        private String getString(int length) throws IOException {
            byte[] bytes = new byte[length];
            this.reader.readFully(bytes);
            StringBuilder str = new StringBuilder(length);
            for (int i = 0; i < length && bytes[i] != 0; ++i) {
                str.append((char)bytes[i]);
            }
            return str.toString();
        }

        private boolean readWindowsLink(byte[] bytes) throws IOException {
            int size;
            this.reader.seek(20L);
            this.reader.readFully(bytes);
            this.readFlags(bytes);
            int position = 76;
            this.reader.seek(position);
            if (this.isShellItemPresent) {
                size = (int)this.readNumber(2);
                this.reader.seek(position += size);
            }
            if ((size = (int)this.readNumber(2)) == 0) {
                this.reader.seek(position += 2);
            } else {
                this.reader.seek(position);
            }
            if (this.isDescriptionPresent) {
                size = (int)this.readNumber(2);
                String description = this.getString(size);
                this.reader.seek(position += size + 2);
                if (this.reader.length() == (long)position) {
                    this.sourcePath = description;
                    return true;
                }
            }
            if (this.isRelativePathPresent) {
                size = (int)this.readNumber(2);
                this.sourcePath = this.getString(size);
                if (this.sourcePath.length() > 1 && this.sourcePath.charAt(1) != ':') {
                    int i = this.path.lastIndexOf(92);
                    if (i < 0) {
                        i = this.path.lastIndexOf(47);
                    }
                    if (i > 0) {
                        this.sourcePath = this.path.substring(0, i + 1) + this.sourcePath;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

