/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.jsch;

import com.jcraft.jsch.SocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openide.util.Exceptions;

public final class MeasurableSocketFactory
implements SocketFactory {
    private static final MeasurableSocketFactory instance = new MeasurableSocketFactory();
    private final CopyOnWriteArrayList<IOListener> listeners = new CopyOnWriteArrayList();

    private MeasurableSocketFactory() {
    }

    public static MeasurableSocketFactory getInstance() {
        return instance;
    }

    public void addIOListener(IOListener listener) {
        this.listeners.add(listener);
    }

    public void removeIOListener(IOListener listener) {
        this.listeners.remove(listener);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = null;
        try {
            socket = new Socket(host, port);
        }
        catch (UnknownHostException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw ex;
        }
        return socket;
    }

    public InputStream getInputStream(Socket socket) throws IOException {
        return new MyIS(socket.getInputStream());
    }

    public OutputStream getOutputStream(Socket socket) throws IOException {
        return new MyOS(socket.getOutputStream());
    }

    private void fireDownload(int bytes) {
        for (IOListener l : this.listeners) {
            l.bytesDownloaded(bytes);
        }
    }

    private void fireUpload(int bytes) {
        for (IOListener l : this.listeners) {
            l.bytesUploaded(bytes);
        }
    }

    private final class MyOS
    extends OutputStream {
        private final OutputStream out;

        MyOS(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            MeasurableSocketFactory.this.fireUpload(1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
            MeasurableSocketFactory.this.fireUpload(b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            MeasurableSocketFactory.this.fireUpload(len);
        }

        @Override
        public void close() throws IOException {
            try {
                this.out.flush();
            }
            finally {
                this.out.close();
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }
    }

    private final class MyIS
    extends InputStream {
        private final InputStream in;

        MyIS(InputStream is) {
            this.in = is;
        }

        @Override
        public int read() throws IOException {
            int res = this.in.read();
            MeasurableSocketFactory.this.fireDownload(res);
            return res;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int res = this.in.read(b);
            MeasurableSocketFactory.this.fireDownload(res);
            return res;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int res = this.in.read(b, off, len);
            MeasurableSocketFactory.this.fireDownload(res);
            return res;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.in.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }
    }

    public static interface IOListener {
        public void bytesUploaded(int var1);

        public void bytesDownloaded(int var1);
    }
}

