/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.VisualReplicator;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridBagCustomizer;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridBagInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridCustomizer;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AddAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteColumnAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteColumnContentAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteComponentAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteRowAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteRowContentAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.EncloseInContainerAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridActionPerformer;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.InsertColumnAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.InsertRowAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.SplitColumnAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.SplitRowAction;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.nodes.Node;

public class GridBagManager
implements GridManager {
    private Container container;
    private GridBagInfoProvider info;
    private GridCustomizer customizer;
    private VisualReplicator replicator;
    private Map<Component, RADVisualComponent> componentMap = new IdentityHashMap<Component, RADVisualComponent>();
    private LayoutSupportManager layoutManager;

    public GridBagManager(VisualReplicator replicator) {
        this.replicator = replicator;
        RADVisualContainer metacont = (RADVisualContainer)replicator.getTopMetaComponent();
        Object bean = replicator.getClonedComponent(metacont);
        this.container = metacont.getContainerDelegate(bean);
        if (!(this.container.getLayout() instanceof GridBagLayout)) {
            throw new IllegalArgumentException();
        }
        this.layoutManager = metacont.getLayoutSupport();
        this.info = new GridBagInfoProvider(this.container, this.layoutManager);
        this.updateComponentMap();
    }

    private void updateComponentMap() {
        this.componentMap.clear();
        RADVisualContainer metacont = (RADVisualContainer)this.replicator.getTopMetaComponent();
        for (RADVisualComponent metacomp : metacont.getSubComponents()) {
            this.componentMap.put((Component)this.replicator.getClonedComponent(metacomp), metacomp);
        }
    }

    private RADVisualComponent getMetaComponent(Component component) {
        RADVisualComponent metacomp = this.componentMap.get(component);
        if (metacomp == null) {
            this.updateComponentMap();
            metacomp = this.componentMap.get(component);
        }
        return metacomp;
    }

    private Node.Property getProperty(Component component, String propertyName) {
        RADVisualComponent metacomp = this.getMetaComponent(component);
        for (Node.Property property : metacomp.getConstraintsProperties()) {
            String name = property.getName();
            if (!name.endsWith(propertyName)) continue;
            return property;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public GridBagInfoProvider getGridInfo() {
        return this.info;
    }

    private void setProperty(Component component, String propertyName, Object value) {
        Node.Property property = this.getProperty(component, propertyName);
        try {
            property.setValue(value);
        }
        catch (IllegalAccessException iaex) {
            FormUtils.LOGGER.log(Level.WARNING, iaex.getMessage(), iaex);
        }
        catch (InvocationTargetException itex) {
            FormUtils.LOGGER.log(Level.WARNING, itex.getMessage(), itex);
        }
    }

    private void setLayoutProperty(String propertyName, Object value) {
        Node.Property property = this.layoutManager.getLayoutProperty(propertyName);
        try {
            property.setValue(value);
        }
        catch (IllegalAccessException iaex) {
            FormUtils.LOGGER.log(Level.WARNING, iaex.getMessage(), iaex);
        }
        catch (InvocationTargetException itex) {
            FormUtils.LOGGER.log(Level.WARNING, itex.getMessage(), itex);
        }
    }

    @Override
    public void setGridX(Component component, int gridX) {
        this.setProperty(component, "gridx", gridX);
    }

    @Override
    public void setGridY(Component component, int gridY) {
        this.setProperty(component, "gridy", gridY);
    }

    public void updateGridX(Component component, int gridXDiff) {
        int oldGridX = this.info.getGridX(component);
        if (oldGridX + gridXDiff > 0) {
            this.setProperty(component, "gridx", oldGridX + gridXDiff);
        } else {
            this.setProperty(component, "gridx", 0);
        }
    }

    public void updateGridY(Component component, int gridYDiff) {
        int oldGridY = this.info.getGridY(component);
        if (oldGridY + gridYDiff > 0) {
            this.setProperty(component, "gridy", oldGridY + gridYDiff);
        } else {
            this.setProperty(component, "gridy", 0);
        }
    }

    @Override
    public void setGridWidth(Component component, int gridWidth) {
        this.setProperty(component, "gridwidth", gridWidth);
    }

    @Override
    public void setGridHeight(Component component, int gridHeight) {
        this.setProperty(component, "gridheight", gridHeight);
    }

    public void updateGridWidth(Component component, int gridWDiff) {
        int oldGridW = this.info.getGridWidth(component);
        if (oldGridW + gridWDiff > 1) {
            this.setProperty(component, "gridwidth", oldGridW + gridWDiff);
        } else {
            this.setProperty(component, "gridwidth", 1);
        }
    }

    public void updateGridHeight(Component component, int gridHDiff) {
        int oldGridH = this.info.getGridHeight(component);
        if (oldGridH + gridHDiff > 1) {
            this.setProperty(component, "gridheight", oldGridH + gridHDiff);
        } else {
            this.setProperty(component, "gridheight", 1);
        }
    }

    @Override
    public void setGridPosition(Component component, int gridX, int gridY, int gridWidth, int gridHeight) {
        boolean widthAbsolute = !this.info.getGridWidthRemainder(component) && !this.info.getGridWidthRelative(component);
        boolean heightAbsolute = !this.info.getGridHeightRemainder(component) && !this.info.getGridHeightRelative(component);
        int oldGridX = this.info.getGridX(component);
        int oldGridY = this.info.getGridY(component);
        int oldGridWidth = this.info.getGridWidth(component);
        int oldGridHeight = this.info.getGridHeight(component);
        int oldXEnd = oldGridX + oldGridWidth;
        int oldYEnd = oldGridY + oldGridHeight;
        this.setGridX(component, gridX);
        this.setGridY(component, gridY);
        if (widthAbsolute && oldGridWidth != gridWidth || oldXEnd != gridX + gridWidth) {
            this.setGridWidth(component, gridWidth);
        }
        if (heightAbsolute && oldGridHeight != gridHeight || oldYEnd != gridY + gridHeight) {
            this.setGridHeight(component, gridHeight);
        }
    }

    @Override
    public void addComponent(Component component, int gridX, int gridY, int gridWidth, int gridHeight) {
        if (!GridUtils.isPaddingComponent(component)) {
            throw new IllegalArgumentException();
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridX;
        c.gridy = gridY;
        c.gridwidth = gridWidth;
        c.gridheight = gridHeight;
        this.container.add(component, c);
        this.container.doLayout();
    }

    @Override
    public List<GridAction> designerActions(GridAction.Context context) {
        ArrayList<GridAction> actions = new ArrayList<GridAction>();
        if (context == GridAction.Context.COLUMN) {
            AbstractGridAction action = new InsertColumnAction(false);
            actions.add(action);
            action = new InsertColumnAction(true);
            actions.add(action);
            action = new DeleteColumnAction();
            actions.add(action);
            action = new DeleteColumnContentAction();
            actions.add(action);
            action = new SplitColumnAction();
            actions.add(action);
        } else if (context == GridAction.Context.ROW) {
            AbstractGridAction action = new InsertRowAction(false);
            actions.add(action);
            action = new InsertRowAction(true);
            actions.add(action);
            action = new DeleteRowAction();
            actions.add(action);
            action = new DeleteRowContentAction();
            actions.add(action);
            action = new SplitRowAction();
            actions.add(action);
        } else if (context == GridAction.Context.COMPONENT) {
            AbstractGridAction action = new DeleteComponentAction();
            actions.add(action);
            action = new EncloseInContainerAction();
            actions.add(action);
        } else if (context == GridAction.Context.CELL) {
            AddAction action = new AddAction(this.replicator);
            actions.add(action);
        }
        return actions;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void removeComponent(Component component) {
        if (!GridUtils.isPaddingComponent(component)) {
            RADVisualComponent metacomp = this.getMetaComponent(component);
            metacomp.getFormModel().removeComponent(metacomp, true);
        }
        this.container.remove(component);
    }

    @Override
    public void insertColumn(int newColumnIndex) {
        boolean gapSupport = this.info.hasGaps();
        if (gapSupport) {
            int gapWidth = FormLoaderSettings.getInstance().getGapWidth();
            int gapHeight = FormLoaderSettings.getInstance().getGapHeight();
            int gappedColumns = (this.info.getGapXArrayLength() + 1) / 2;
            int gappedRows = (this.info.getGapYArrayLength() + 1) / 2;
            this.setGapArrays(gapWidth, gapHeight, gappedColumns + 1, gappedRows);
        }
        for (Component component : this.getContainer().getComponents()) {
            int x = this.info.getGridX(component);
            int width = this.info.getGridWidth(component);
            int newX = x;
            int newWidth = width;
            if (x >= newColumnIndex) {
                newX += gapSupport ? 2 : 1;
            } else if (x + width > newColumnIndex) {
                newWidth += gapSupport ? 2 : 1;
            }
            if (x == newX && width == newWidth) continue;
            int y = this.info.getGridY(component);
            int height = this.info.getGridHeight(component);
            boolean widthRemainder = this.info.getGridWidthRemainder(component);
            boolean widthRelative = this.info.getGridWidthRelative(component);
            this.setGridPosition(component, newX, y, newWidth, height);
            if (widthRemainder) {
                this.setGridWidth(component, 0);
            }
            if (!widthRelative) continue;
            this.setGridWidth(component, -1);
        }
    }

    @Override
    public void deleteColumn(int columnIndex) {
        boolean gapSupport = this.info.hasGaps();
        if (gapSupport) {
            int gapWidth = FormLoaderSettings.getInstance().getGapWidth();
            int gapHeight = FormLoaderSettings.getInstance().getGapHeight();
            int gappedColumns = (this.info.getGapXArrayLength() + 1) / 2;
            int gappedRows = (this.info.getGapYArrayLength() + 1) / 2;
            this.setGapArrays(gapWidth, gapHeight, gappedColumns - 1, gappedRows);
        }
        for (Component component : this.getContainer().getComponents()) {
            int x = this.info.getGridX(component);
            int width = this.info.getGridWidth(component);
            if (x == columnIndex && width == 1) {
                this.removeComponent(component);
                continue;
            }
            int newX = x;
            int newWidth = width;
            if (x > columnIndex) {
                newX -= gapSupport ? 2 : 1;
            } else if (x + width > columnIndex) {
                newWidth -= gapSupport ? 2 : 1;
            }
            if (x == newX && width == newWidth) continue;
            int y = this.info.getGridY(component);
            int height = this.info.getGridHeight(component);
            boolean widthRemainder = this.info.getGridWidthRemainder(component);
            boolean widthRelative = this.info.getGridWidthRelative(component);
            this.setGridPosition(component, newX, y, newWidth, height);
            if (widthRemainder) {
                this.setGridWidth(component, 0);
            }
            if (!widthRelative) continue;
            this.setGridWidth(component, -1);
        }
    }

    @Override
    public void insertRow(int newRowIndex) {
        boolean gapSupport = this.info.hasGaps();
        if (gapSupport) {
            int gapWidth = FormLoaderSettings.getInstance().getGapWidth();
            int gapHeight = FormLoaderSettings.getInstance().getGapHeight();
            int gappedColumns = (this.info.getGapXArrayLength() + 1) / 2;
            int gappedRows = (this.info.getGapYArrayLength() + 1) / 2;
            this.setGapArrays(gapWidth, gapHeight, gappedColumns, gappedRows + 1);
        }
        for (Component component : this.getContainer().getComponents()) {
            int y = this.info.getGridY(component);
            int height = this.info.getGridHeight(component);
            int newY = y;
            int newHeight = height;
            if (y >= newRowIndex) {
                newY += gapSupport ? 2 : 1;
            } else if (y + height > newRowIndex) {
                newHeight += gapSupport ? 2 : 1;
            }
            if (y == newY && height == newHeight) continue;
            int x = this.info.getGridX(component);
            int width = this.info.getGridWidth(component);
            boolean heightRemainder = this.info.getGridHeightRemainder(component);
            boolean heightRelative = this.info.getGridHeightRelative(component);
            this.setGridPosition(component, x, newY, width, newHeight);
            if (heightRemainder) {
                this.setGridHeight(component, 0);
            }
            if (!heightRelative) continue;
            this.setGridHeight(component, -1);
        }
    }

    @Override
    public void deleteRow(int rowIndex) {
        boolean gapSupport = this.info.hasGaps();
        if (gapSupport) {
            int gapWidth = FormLoaderSettings.getInstance().getGapWidth();
            int gapHeight = FormLoaderSettings.getInstance().getGapHeight();
            int gappedColumns = (this.info.getGapXArrayLength() + 1) / 2;
            int gappedRows = (this.info.getGapYArrayLength() + 1) / 2;
            this.setGapArrays(gapWidth, gapHeight, gappedColumns, gappedRows - 1);
        }
        for (Component component : this.getContainer().getComponents()) {
            int y = this.info.getGridY(component);
            int height = this.info.getGridHeight(component);
            if (y == rowIndex && height == 1) {
                this.removeComponent(component);
                continue;
            }
            int newY = y;
            int newHeight = height;
            if (y > rowIndex) {
                newY -= gapSupport ? 2 : 1;
            } else if (y + height > rowIndex) {
                newHeight -= gapSupport ? 2 : 1;
            }
            if (y == newY && height == newHeight) continue;
            int x = this.info.getGridX(component);
            int width = this.info.getGridWidth(component);
            boolean heightRemainder = this.info.getGridHeightRemainder(component);
            boolean heightRelative = this.info.getGridHeightRelative(component);
            this.setGridPosition(component, x, newY, width, newHeight);
            if (heightRemainder) {
                this.setGridHeight(component, 0);
            }
            if (!heightRelative) continue;
            this.setGridHeight(component, -1);
        }
    }

    @Override
    public void updateLayout(boolean includingSubcontainers) {
        RADVisualContainer metacont = (RADVisualContainer)this.replicator.getTopMetaComponent();
        if (includingSubcontainers) {
            for (RADVisualComponent metacomp : metacont.getSubComponents()) {
                if (!(metacomp instanceof RADVisualContainer)) continue;
                this.replicator.updateContainerLayout((RADVisualContainer)metacomp);
            }
        }
        this.replicator.updateContainerLayout(metacont);
    }

    @Override
    public GridCustomizer getCustomizer(GridActionPerformer performer) {
        if (this.customizer == null) {
            this.customizer = this.createCustomizer(performer);
        }
        return this.customizer;
    }

    private GridCustomizer createCustomizer(GridActionPerformer performer) {
        return new GridBagCustomizer(this, performer);
    }

    public void setAnchor(Component component, int anchor) {
        this.setProperty(component, "anchor", anchor);
    }

    public void setFill(Component component, int fill) {
        this.setProperty(component, "fill", fill);
    }

    public void setHorizontalFill(Component component, boolean fill) {
        int oldFill = this.info.getFill(component);
        if (fill) {
            switch (oldFill) {
                case 0: {
                    oldFill = 2;
                    break;
                }
                case 3: {
                    oldFill = 1;
                }
            }
        } else {
            switch (oldFill) {
                case 2: {
                    oldFill = 0;
                    break;
                }
                case 1: {
                    oldFill = 3;
                }
            }
        }
        this.setProperty(component, "fill", oldFill);
    }

    public void setVerticalFill(Component component, boolean fill) {
        int oldFill = this.info.getFill(component);
        if (fill) {
            switch (oldFill) {
                case 0: {
                    oldFill = 3;
                    break;
                }
                case 2: {
                    oldFill = 1;
                }
            }
        } else {
            switch (oldFill) {
                case 3: {
                    oldFill = 0;
                    break;
                }
                case 1: {
                    oldFill = 2;
                }
            }
        }
        this.setProperty(component, "fill", oldFill);
    }

    public void updateIPadX(Component component, int iPadXDiff) {
        int oldIPadX = this.info.getIPadX(component);
        if (oldIPadX + iPadXDiff > 0) {
            this.setProperty(component, "ipadx", oldIPadX + iPadXDiff);
        } else {
            this.setProperty(component, "ipadx", 0);
        }
    }

    public void updateIPadY(Component component, int iPadYDiff) {
        int oldIPadY = this.info.getIPadY(component);
        if (oldIPadY + iPadYDiff > 0) {
            this.setProperty(component, "ipady", oldIPadY + iPadYDiff);
        } else {
            this.setProperty(component, "ipady", 0);
        }
    }

    public void setIPadX(Component component, int iPadX) {
        this.setProperty(component, "ipadx", iPadX);
    }

    public void setIPadY(Component component, int iPadY) {
        this.setProperty(component, "ipady", iPadY);
    }

    public void updateInsets(Component component, Insets diff) {
        Insets insets = this.info.getInsets(component);
        insets.top = insets.top + diff.top >= 0 ? insets.top + diff.top : 0;
        insets.left = insets.left + diff.left >= 0 ? insets.left + diff.left : 0;
        insets.bottom = insets.bottom + diff.bottom >= 0 ? insets.bottom + diff.bottom : 0;
        insets.right = insets.right + diff.right >= 0 ? insets.right + diff.right : 0;
        this.setProperty(component, "insets", insets);
    }

    public void resetInsets(Component component, boolean top, boolean left, boolean bottom, boolean right) {
        Insets insets = this.info.getInsets(component);
        if (top) {
            insets.top = 0;
        }
        if (left) {
            insets.left = 0;
        }
        if (bottom) {
            insets.bottom = 0;
        }
        if (right) {
            insets.right = 0;
        }
        this.setProperty(component, "insets", insets);
    }

    public void setWeightX(Component component, double weight) {
        this.setProperty(component, "weightx", weight);
    }

    public void setWeightY(Component component, double weight) {
        this.setProperty(component, "weighty", weight);
    }

    public void updateWeightX(Component component, double diff) {
        double oldWeight = this.info.getWeightX(component);
        if (oldWeight + diff > 0.0) {
            this.setProperty(component, "weightx", oldWeight + diff);
        } else {
            this.setProperty(component, "weightx", 0.0);
        }
    }

    public void updateWeightY(Component component, double diff) {
        double oldWeight = this.info.getWeightY(component);
        if (oldWeight + diff > 0.0) {
            this.setProperty(component, "weighty", oldWeight + diff);
        } else {
            this.setProperty(component, "weighty", 0.0);
        }
    }

    @Override
    public void addGaps(int gapWidth, int gapHeight) {
        if (this.info.hasGaps()) {
            return;
        }
        FormLoaderSettings.getInstance().setGapWidth(gapWidth);
        FormLoaderSettings.getInstance().setGapHeight(gapHeight);
        int columnCount = this.info.getColumnCount();
        int rowCount = this.info.getRowCount();
        this.setGapArrays(gapWidth, gapHeight, columnCount, rowCount);
        for (Component component : this.getContainer().getComponents()) {
            int x = this.info.getGridX(component);
            int y = this.info.getGridY(component);
            int width = this.info.getGridWidth(component);
            int height = this.info.getGridHeight(component);
            int newX = 2 * x;
            int newY = 2 * y;
            int newWidth = width * 2 - 1;
            int newHeight = height * 2 - 1;
            boolean widthRemainder = this.info.getGridWidthRemainder(component);
            boolean heightRemainder = this.info.getGridHeightRemainder(component);
            this.setGridPosition(component, newX, newY, newWidth, newHeight);
            if (widthRemainder) {
                this.setGridWidth(component, 0);
            }
            if (!heightRemainder) continue;
            this.setGridHeight(component, 0);
        }
    }

    @Override
    public void removeGaps() {
        if (!this.info.hasGaps()) {
            return;
        }
        int gapXArrayLength = this.info.getGapXArrayLength();
        int gapYArrayLength = this.info.getGapYArrayLength();
        this.setLayoutProperty("columnWidths", null);
        this.setLayoutProperty("rowHeights", null);
        int maxX = -1;
        int maxY = -1;
        for (Component component : this.getContainer().getComponents()) {
            int x = this.info.getGridX(component);
            int y = this.info.getGridY(component);
            int width = this.info.getGridWidth(component);
            int height = this.info.getGridHeight(component);
            int newX = x / 2;
            int newY = y / 2;
            int newWidth = (width - 1) / 2 + 1;
            int newHeight = (height - 1) / 2 + 1;
            boolean widthRemainder = this.info.getGridWidthRemainder(component);
            boolean heightRemainder = this.info.getGridHeightRemainder(component);
            this.setGridPosition(component, newX, newY, newWidth, newHeight);
            if (widthRemainder) {
                this.setGridWidth(component, 0);
            }
            if (heightRemainder) {
                this.setGridHeight(component, 0);
            }
            if (maxX == -1 || newX + newWidth - 1 > maxX) {
                maxX = newX + newWidth - 1;
            }
            if (maxY != -1 && newY + newHeight - 1 <= maxY) continue;
            maxY = newY + newHeight - 1;
        }
    }

    void setGapArrays(int gapWidth, int gapHeight, int columnCount, int rowCount) {
        int gappedColumnCount = Math.max(2 * columnCount - 1, 1);
        int gappedRowCount = Math.max(2 * rowCount - 1, 1);
        int[] columnWidths = new int[gappedColumnCount];
        for (int i = 1; i < columnCount; ++i) {
            columnWidths[i * 2 - 1] = gapWidth;
        }
        int[] rowHeights = new int[gappedRowCount];
        for (int j = 1; j < rowCount; ++j) {
            rowHeights[j * 2 - 1] = gapHeight;
        }
        this.setLayoutProperty("columnWidths", columnWidths);
        this.setLayoutProperty("rowHeights", rowHeights);
    }

    @Override
    public void updateGaps(boolean updateComponents) {
        if (!this.info.hasGaps()) {
            return;
        }
        int gapWidth = FormLoaderSettings.getInstance().getGapWidth();
        int gapHeight = FormLoaderSettings.getInstance().getGapHeight();
        int columnCount = 0;
        int rowCount = 0;
        int lastGapColumnIndex = Math.max(this.info.getLastGapColumn() - 1, -1);
        int lastGapRowIndex = Math.max(this.info.getLastGapRow() - 1, -1);
        if (updateComponents) {
            GridUtils.removePaddingComponents(this);
            TreeSet<Integer> wrongPositionX = new TreeSet<Integer>();
            TreeSet<Integer> wrongPositionY = new TreeSet<Integer>();
            for (Component component : this.getContainer().getComponents()) {
                boolean relativeX = this.info.getGridXRelative(component);
                boolean relativeY = this.info.getGridYRelative(component);
                int x = this.info.getGridX(component);
                int y = this.info.getGridY(component);
                if (x <= lastGapColumnIndex && relativeX && this.info.isGapColumn(x)) {
                    wrongPositionX.add(x);
                }
                if (y <= lastGapRowIndex && relativeY && this.info.isGapRow(y)) {
                    wrongPositionY.add(y);
                }
                columnCount = Math.max(columnCount, x + 1);
                rowCount = Math.max(rowCount, y + 1);
            }
            if (columnCount > 0 && rowCount > 0) {
                int[] moveRightBy = new int[columnCount];
                int[] moveDownBy = new int[rowCount];
                Iterator iterX = wrongPositionX.iterator();
                while (iterX.hasNext()) {
                    int wrongX;
                    for (int i = wrongX = ((Integer)iterX.next()).intValue(); i < columnCount; ++i) {
                        if (i == wrongX) {
                            int n = i;
                            moveRightBy[n] = moveRightBy[n] + 1;
                            continue;
                        }
                        int n = i;
                        moveRightBy[n] = moveRightBy[n] + 2;
                    }
                }
                Component[] iterY = wrongPositionY.iterator();
                while (iterY.hasNext()) {
                    int wrongY;
                    for (int j = wrongY = ((Integer)iterY.next()).intValue(); j < rowCount; ++j) {
                        if (j == wrongY) {
                            int n = j;
                            moveDownBy[n] = moveDownBy[n] + 1;
                            continue;
                        }
                        int n = j;
                        moveDownBy[n] = moveDownBy[n] + 2;
                    }
                }
                for (Component component : this.getContainer().getComponents()) {
                    boolean remainderWidth = this.info.getGridWidthRemainder(component);
                    boolean remainderHeight = this.info.getGridHeightRemainder(component);
                    int x = this.info.getGridX(component);
                    int y = this.info.getGridY(component);
                    int width = this.info.getGridWidth(component);
                    int height = this.info.getGridHeight(component);
                    int newX = x + moveRightBy[x];
                    int newY = y + moveDownBy[y];
                    int newWidth = width;
                    int newHeight = height;
                    if (x > lastGapColumnIndex + 1) {
                        newX += x - (lastGapColumnIndex + 1);
                        newWidth = width * 2 - 1;
                    }
                    if (y > lastGapRowIndex + 1) {
                        newY += y - (lastGapRowIndex + 1);
                        newHeight = height * 2 - 1;
                    }
                    this.setGridPosition(component, newX, newY, newWidth, newHeight);
                    if (remainderWidth) {
                        this.setGridWidth(component, 0);
                    }
                    if (remainderHeight) {
                        this.setGridHeight(component, 0);
                    }
                    columnCount = Math.max(columnCount, newX + newWidth);
                    rowCount = Math.max(rowCount, newY + newHeight);
                }
                columnCount = Math.max(columnCount, lastGapColumnIndex + 1);
                rowCount = Math.max(rowCount, lastGapRowIndex + 1);
                int gapFreeColumnCount = (columnCount + 1 + (1 - columnCount % 2)) / 2;
                int gapFreeRowCount = (rowCount + 1 + (1 - rowCount % 2)) / 2;
                this.setGapArrays(gapWidth, gapHeight, gapFreeColumnCount, gapFreeRowCount);
                GridUtils.addPaddingComponents(this, columnCount, rowCount);
                GridUtils.revalidateGrid(this);
            }
        } else {
            columnCount = Math.max(this.info.getColumnCount(), lastGapColumnIndex + 1);
            rowCount = Math.max(this.info.getRowCount(), lastGapRowIndex + 1);
            int gapFreeColumnCount = (columnCount + 1 + (1 - columnCount % 2)) / 2;
            int gapFreeRowCount = (rowCount + 1 + (1 - rowCount % 2)) / 2;
            this.setGapArrays(gapWidth, gapHeight, gapFreeColumnCount, gapFreeRowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container encloseInContainer(Set<Component> components) {
        int i;
        Container clone;
        GridBagLayout layout = (GridBagLayout)this.container.getLayout();
        RADVisualContainer parent = null;
        FormModel formModel = null;
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = 0;
        int maxy = 0;
        boolean horizontalFill = false;
        boolean verticalFill = false;
        boolean weightx = false;
        boolean weighty = false;
        for (Component comp : components) {
            double wy;
            RADVisualComponent metaComp = this.componentMap.get(comp);
            parent = metaComp.getParentContainer();
            formModel = metaComp.getFormModel();
            int gridx = this.info.getGridX(comp);
            int gridy = this.info.getGridY(comp);
            int gridwidth = this.info.getGridWidth(comp);
            int gridheight = this.info.getGridHeight(comp);
            minx = Math.min(minx, gridx);
            miny = Math.min(miny, gridy);
            maxx = Math.max(maxx, gridx + gridwidth);
            maxy = Math.max(maxy, gridy + gridheight);
            int fill = this.info.getFill(comp);
            if (fill == 1) {
                horizontalFill = true;
                verticalFill = true;
            } else if (fill == 2) {
                horizontalFill = true;
            } else if (fill == 3) {
                verticalFill = true;
            }
            double wx = this.info.getWeightX(comp);
            if (wx != 0.0) {
                weightx = true;
            }
            if ((wy = this.info.getWeightY(comp)) == 0.0) continue;
            weighty = true;
        }
        double[][] weights = layout.getLayoutWeights();
        MetaComponentCreator creator = formModel.getComponentCreator();
        RADVisualContainer panel = (RADVisualContainer)creator.createComponent(new ClassSource("javax.swing.JPanel", new ClassSource.Entry[0]), (RADComponent)parent, null);
        boolean recording = formModel.isUndoRedoRecording();
        try {
            formModel.setUndoRedoRecording(false);
            creator.createComponent(new ClassSource("java.awt.GridBagLayout", new ClassSource.Entry[0]), (RADComponent)panel, null);
        }
        finally {
            formModel.setUndoRedoRecording(recording);
        }
        for (Component comp : components) {
            RADVisualComponent metaComp = this.componentMap.get(comp);
            creator.moveComponent(metaComp, panel);
        }
        if (minx != 0) {
            for (Component comp : components) {
                int gridx = this.info.getGridX(comp);
                this.setGridX(comp, gridx - minx);
            }
        }
        if (miny != 0) {
            for (Component comp : components) {
                int gridy = this.info.getGridY(comp);
                this.setGridY(comp, gridy - miny);
            }
        }
        if ((clone = (Container)this.replicator.getClonedComponent(panel)) == null) {
            clone = (Container)this.replicator.createClone(panel);
        }
        this.componentMap.put(clone, panel);
        this.setGridX(clone, minx);
        this.setGridY(clone, miny);
        this.setGridWidth(clone, maxx - minx);
        this.setGridHeight(clone, maxy - miny);
        if (horizontalFill && weightx) {
            double totalWeightX = 0.0;
            for (i = minx; i < maxx; ++i) {
                totalWeightX += weights[0][i];
            }
            this.setWeightX(clone, totalWeightX);
        }
        if (verticalFill && weighty) {
            double totalWeightY = 0.0;
            for (i = miny; i < maxy; ++i) {
                totalWeightY += weights[1][i];
            }
            this.setWeightY(clone, totalWeightY);
        }
        int fill = horizontalFill ? (verticalFill ? 1 : 2) : (verticalFill ? 3 : 0);
        this.setFill(clone, fill);
        return clone;
    }
}

