/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.semantic;

import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.editor.base.javadoc.JavadocImports;
import org.netbeans.modules.java.editor.base.options.MarkOccurencesSettingsNames;
import org.netbeans.modules.java.editor.base.semantic.FindLocalUsagesQuery;
import org.netbeans.modules.java.editor.base.semantic.MethodExitDetector;
import org.netbeans.modules.java.editor.base.semantic.Utilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;

public abstract class MarkOccurrencesHighlighterBase
extends JavaParserResultTask {
    private static final Set<Tree.Kind> TYPE_PATH_ELEMENT = EnumSet.of(Tree.Kind.IDENTIFIER, Tree.Kind.PRIMITIVE_TYPE, Tree.Kind.PARAMETERIZED_TYPE, Tree.Kind.MEMBER_SELECT, Tree.Kind.ARRAY_TYPE);
    private boolean canceled;
    private MethodExitDetector exitDetector;
    private FindLocalUsagesQuery localUsages;

    protected MarkOccurrencesHighlighterBase() {
        super(JavaSource.Phase.RESOLVED, TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    public void run(Parser.Result parseResult, SchedulerEvent event) {
        this.resume();
        CompilationInfo info = CompilationInfo.get((Parser.Result)parseResult);
        if (info == null) {
            return;
        }
        Document doc = parseResult.getSnapshot().getSource().getDocument(false);
        this.process(info, doc, event);
    }

    protected abstract void process(CompilationInfo var1, Document var2, SchedulerEvent var3);

    private boolean isIn(CompilationUnitTree cu, SourcePositions sp, Tree tree, int position) {
        return sp.getStartPosition(cu, tree) <= (long)position && (long)position <= sp.getEndPosition(cu, tree);
    }

    private boolean isIn(int caretPosition, Token span) {
        if (span == null) {
            return false;
        }
        return span.offset(null) <= caretPosition && caretPosition <= span.offset(null) + span.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<int[]> processImpl(CompilationInfo info, Preferences node, Document doc, int caretPosition) {
        MemberSelectTree memberSelectTree;
        ImportTree it;
        Element el;
        boolean insideJavadoc;
        Object type;
        caretPosition = info.getSnapshot().getEmbeddedOffset(caretPosition);
        TokenSequence cts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        if (cts != null) {
            cts.move(caretPosition);
            if (cts.moveNext() && cts.token().id() == JavaTokenId.IDENTIFIER && cts.offset() == caretPosition) {
                ++caretPosition;
            }
        }
        CompilationUnitTree cu = info.getCompilationUnit();
        TreeUtilities tu = info.getTreeUtilities();
        TreePath tp = tu.pathFor(caretPosition);
        if (tp.getParentPath() != null && tp.getParentPath().getLeaf().getKind() == Tree.Kind.ANNOTATED_TYPE) {
            tp = tp.getParentPath();
        }
        TreePath typePath = MarkOccurrencesHighlighterBase.findTypePath(tp);
        if (this.isCancelled()) {
            return null;
        }
        if (typePath != null && typePath.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD) {
            TreePath declPath = typePath.getParentPath();
            MethodTree decl = (MethodTree)declPath.getLeaf();
            type = decl.getReturnType();
            if (node.getBoolean(MarkOccurencesSettingsNames.EXIT, true) && this.isIn(cu, info.getTrees().getSourcePositions(), (Tree)type, caretPosition)) {
                MethodExitDetector med = new MethodExitDetector();
                this.setExitDetector(med);
                try {
                    List<int[]> list = med.process(info, doc, declPath, null);
                    return list;
                }
                finally {
                    this.setExitDetector(null);
                }
            }
            for (Tree tree : decl.getThrows()) {
                if (!node.getBoolean(MarkOccurencesSettingsNames.EXCEPTIONS, true) || !this.isIn(cu, info.getTrees().getSourcePositions(), tree, caretPosition)) continue;
                MethodExitDetector methodExitDetector = new MethodExitDetector();
                this.setExitDetector(methodExitDetector);
                try {
                    List<int[]> list = methodExitDetector.process(info, doc, declPath, Collections.singletonList(tree));
                    return list;
                }
                finally {
                    this.setExitDetector(null);
                }
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        if (node.getBoolean(MarkOccurencesSettingsNames.EXCEPTIONS, true) && typePath != null && (typePath.getParentPath().getLeaf().getKind() == Tree.Kind.UNION_TYPE && typePath.getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.VARIABLE && typePath.getParentPath().getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.CATCH || typePath.getParentPath().getLeaf().getKind() == Tree.Kind.VARIABLE && typePath.getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.CATCH)) {
            MethodExitDetector med = new MethodExitDetector();
            this.setExitDetector(med);
            try {
                TreePath tryPath = tu.getPathElementOfKind(Tree.Kind.TRY, typePath);
                if (tryPath != null) {
                    type = med.process(info, doc, new TreePath(tryPath, ((TryTree)tryPath.getLeaf()).getBlock()), Collections.singletonList(typePath.getLeaf()));
                    return type;
                }
            }
            finally {
                this.setExitDetector(null);
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        if (node.getBoolean(MarkOccurencesSettingsNames.IMPLEMENTS, true) || node.getBoolean(MarkOccurencesSettingsNames.OVERRIDES, true)) {
            int bodyStart;
            if (typePath != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)typePath.getParentPath().getLeaf().getKind())) {
                ClassTree ctree = (ClassTree)typePath.getParentPath().getLeaf();
                int bodyStart2 = Utilities.findBodyStart(info, ctree, cu, info.getTrees().getSourcePositions(), doc);
                boolean isExtends = ctree.getExtendsClause() == typePath.getLeaf();
                boolean isImplements = false;
                for (Tree tree : ctree.getImplementsClause()) {
                    if (tree != typePath.getLeaf()) continue;
                    isImplements = true;
                    break;
                }
                if (isExtends && node.getBoolean(MarkOccurencesSettingsNames.OVERRIDES, true) || isImplements && node.getBoolean(MarkOccurencesSettingsNames.IMPLEMENTS, true)) {
                    Element element = info.getTrees().getElement(typePath);
                    Element element2 = info.getTrees().getElement(typePath.getParentPath());
                    if (MarkOccurrencesHighlighterBase.isClass(element) && MarkOccurrencesHighlighterBase.isClass(element2)) {
                        return this.detectMethodsForClass(info, doc, typePath.getParentPath(), (TypeElement)element, (TypeElement)element2);
                    }
                }
            }
            if (this.isCancelled()) {
                return null;
            }
            TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            if (ts != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()) && caretPosition < (bodyStart = Utilities.findBodyStart(info, tp.getLeaf(), cu, info.getTrees().getSourcePositions(), doc))) {
                ts.move(caretPosition);
                if (ts.moveNext()) {
                    List<? extends Tree> superClasses;
                    Tree superClass;
                    if (node.getBoolean(MarkOccurencesSettingsNames.OVERRIDES, true) && ts.token().id() == JavaTokenId.EXTENDS && (superClass = ((ClassTree)tp.getLeaf()).getExtendsClause()) != null) {
                        Element superType = info.getTrees().getElement(new TreePath(tp, superClass));
                        Element element = info.getTrees().getElement(tp);
                        if (MarkOccurrencesHighlighterBase.isClass(superType) && MarkOccurrencesHighlighterBase.isClass(element)) {
                            return this.detectMethodsForClass(info, doc, tp, (TypeElement)superType, (TypeElement)element);
                        }
                    }
                    if (node.getBoolean(MarkOccurencesSettingsNames.IMPLEMENTS, true) && ts.token().id() == JavaTokenId.IMPLEMENTS && (superClasses = ((ClassTree)tp.getLeaf()).getImplementsClause()) != null) {
                        ArrayList<TypeElement> superTypes = new ArrayList<TypeElement>();
                        for (Tree tree : superClasses) {
                            Element superType;
                            if (tree == null || !MarkOccurrencesHighlighterBase.isClass(superType = info.getTrees().getElement(new TreePath(tp, tree)))) continue;
                            superTypes.add((TypeElement)superType);
                        }
                        Element element = info.getTrees().getElement(tp);
                        if (!superTypes.isEmpty() && MarkOccurrencesHighlighterBase.isClass(element)) {
                            return this.detectMethodsForClass(info, doc, tp, superTypes, (TypeElement)element);
                        }
                    }
                }
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        Tree tree = tp.getLeaf();
        if (node.getBoolean(MarkOccurencesSettingsNames.BREAK_CONTINUE, true)) {
            int[] span;
            if (tree.getKind() == Tree.Kind.BREAK || tree.getKind() == Tree.Kind.CONTINUE) {
                return this.detectBreakOrContinueTarget(info, doc, tp, caretPosition);
            }
            if (tree.getKind() == Tree.Kind.LABELED_STATEMENT && (span = Utilities.findIdentifierSpan(tp, info, doc))[0] <= caretPosition && caretPosition <= span[1]) {
                List<int[]> ret = this.detectLabel(info, doc, tp);
                ret.add(span);
                return ret;
            }
        }
        boolean bl = insideJavadoc = (el = JavadocImports.findReferencedElement(info, caretPosition)) != null;
        if (this.isCancelled()) {
            return null;
        }
        if (!insideJavadoc) {
            TreePath c;
            el = tp.getParentPath() != null && tp.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS ? (this.isIn(caretPosition, Utilities.findIdentifierSpan(info, doc, c = new TreePath(tp.getParentPath(), ((NewClassTree)tp.getParentPath().getLeaf()).getIdentifier()))) ? info.getTrees().getElement(tp.getParentPath()) : info.getTrees().getElement(tp)) : info.getTrees().getElement(tp);
        }
        if (el != null && el.getKind() != ElementKind.MODULE && el.asType().getKind() != TypeKind.OTHER && (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || this.isIn(caretPosition, Utilities.findIdentifierSpan(info, doc, tp))) && !Utilities.isNonCtorKeyword(tree) && (tree.getKind() != Tree.Kind.METHOD || this.isIn(caretPosition, Utilities.findIdentifierSpan(info, doc, tp))) && MarkOccurrencesHighlighterBase.isEnabled(node, el) || insideJavadoc && MarkOccurrencesHighlighterBase.isEnabled(node, el)) {
            FindLocalUsagesQuery fluq = new FindLocalUsagesQuery();
            this.setLocalUsages(fluq);
            try {
                ArrayList<int[]> arrayList = new ArrayList<int[]>();
                for (Token t : fluq.findUsages(el, info, doc)) {
                    int delta = t.id() == JavadocTokenId.IDENT && t.text().charAt(0) == '<' && t.text().charAt(t.length() - 1) == '>' ? 1 : 0;
                    arrayList.add(new int[]{t.offset(null) + delta, t.offset(null) + t.length() - delta});
                }
                ArrayList<int[]> arrayList2 = arrayList;
                return arrayList2;
            }
            finally {
                this.setLocalUsages(null);
            }
        }
        if (tp.getParentPath() != null && tp.getParentPath().getLeaf().getKind() == Tree.Kind.IMPORT && (it = (ImportTree)tp.getParentPath().getLeaf()).isStatic() && tp.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT && !"*".contentEquals((memberSelectTree = (MemberSelectTree)tp.getLeaf()).getIdentifier())) {
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            Token<JavaTokenId> tok = Utilities.getToken(info, doc, tp);
            if (tok != null) {
                arrayList.add(new int[]{tok.offset(null), tok.offset(null) + tok.length()});
            }
            if ((el = info.getTrees().getElement(new TreePath(tp, memberSelectTree.getExpression()))) != null) {
                FindLocalUsagesQuery fluq = new FindLocalUsagesQuery();
                this.setLocalUsages(fluq);
                try {
                    for (Element element : el.getEnclosedElements()) {
                        if (!element.getModifiers().contains((Object)Modifier.STATIC)) continue;
                        for (Token t : fluq.findUsages(element, info, doc)) {
                            arrayList.add(new int[]{t.offset(null), t.offset(null) + t.length()});
                        }
                    }
                    ArrayList<int[]> arrayList3 = arrayList;
                    return arrayList3;
                }
                finally {
                    this.setLocalUsages(null);
                }
            }
        }
        return null;
    }

    private static TreePath findTypePath(TreePath tp) {
        if (!TYPE_PATH_ELEMENT.contains((Object)tp.getLeaf().getKind())) {
            return null;
        }
        while (TYPE_PATH_ELEMENT.contains((Object)tp.getParentPath().getLeaf().getKind())) {
            tp = tp.getParentPath();
        }
        return tp;
    }

    private static boolean isClass(Element el) {
        return el != null && (el.getKind().isClass() || el.getKind().isInterface());
    }

    private static boolean isEnabled(Preferences node, Element el) {
        switch (el.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case TYPE_PARAMETER: {
                return node.getBoolean(MarkOccurencesSettingsNames.TYPES, true);
            }
            case CONSTRUCTOR: 
            case METHOD: {
                return node.getBoolean(MarkOccurencesSettingsNames.METHODS, true);
            }
            case ENUM_CONSTANT: {
                return node.getBoolean(MarkOccurencesSettingsNames.CONSTANTS, true);
            }
            case FIELD: {
                if (el.getModifiers().containsAll(EnumSet.of(Modifier.STATIC, Modifier.FINAL))) {
                    return node.getBoolean(MarkOccurencesSettingsNames.CONSTANTS, true);
                }
                return node.getBoolean(MarkOccurencesSettingsNames.FIELDS, true);
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: 
            case PARAMETER: 
            case EXCEPTION_PARAMETER: {
                return node.getBoolean(MarkOccurencesSettingsNames.LOCAL_VARIABLES, true);
            }
            case MODULE: 
            case PACKAGE: {
                return false;
            }
        }
        Logger.getLogger(MarkOccurrencesHighlighterBase.class.getName()).log(Level.INFO, "Unknow element type: {0}.", (Object)el.getKind());
        return true;
    }

    private final synchronized void setExitDetector(MethodExitDetector detector) {
        this.exitDetector = detector;
    }

    private final synchronized void setLocalUsages(FindLocalUsagesQuery localUsages) {
        this.localUsages = localUsages;
    }

    public final synchronized void cancel() {
        this.canceled = true;
        if (this.exitDetector != null) {
            this.exitDetector.cancel();
        }
        if (this.localUsages != null) {
            this.localUsages.cancel();
        }
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    private List<int[]> detectMethodsForClass(CompilationInfo info, Document document, TreePath clazz, TypeElement superType, TypeElement thisType) {
        return this.detectMethodsForClass(info, document, clazz, Collections.singletonList(superType), thisType);
    }

    private List<int[]> detectMethodsForClass(CompilationInfo info, Document document, TreePath clazz, List<TypeElement> superTypes, TypeElement thisType) {
        ArrayList<int[]> highlights = new ArrayList<int[]>();
        ClassTree clazzTree = (ClassTree)clazz.getLeaf();
        TypeElement jlObject = info.getElements().getTypeElement("java.lang.Object");
        block0: for (Tree tree : clazzTree.getMembers()) {
            if (this.isCancelled()) {
                return null;
            }
            if (tree.getKind() != Tree.Kind.METHOD) continue;
            TreePath path = new TreePath(clazz, tree);
            Element el = info.getTrees().getElement(path);
            if (el.getKind() != ElementKind.METHOD) continue;
            for (TypeElement superType : superTypes) {
                for (ExecutableElement ee : ElementFilter.methodsIn(info.getElements().getAllMembers(superType))) {
                    if (!info.getElements().overrides((ExecutableElement)el, ee, thisType) || !superType.getKind().isClass() && ee.getEnclosingElement().equals(jlObject)) continue;
                    Token<JavaTokenId> t = Utilities.getToken(info, document, path);
                    if (t == null) continue block0;
                    highlights.add(new int[]{t.offset(null), t.offset(null) + t.length()});
                    continue block0;
                }
            }
        }
        return highlights;
    }

    private List<int[]> detectBreakOrContinueTarget(CompilationInfo info, Document document, TreePath breakOrContinue, int caretPosition) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        StatementTree target = info.getTreeUtilities().getBreakContinueTarget(breakOrContinue);
        if (target == null) {
            return null;
        }
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move((int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), target));
        if (ts.moveNext()) {
            result.add(new int[]{ts.offset(), ts.offset() + ts.token().length()});
        }
        StatementTree statement = target.getKind() == Tree.Kind.LABELED_STATEMENT ? ((LabeledStatementTree)target).getStatement() : target;
        StatementTree block = null;
        switch (statement.getKind()) {
            case SWITCH: {
                block = statement;
                break;
            }
            case WHILE_LOOP: {
                if (((WhileLoopTree)statement).getStatement().getKind() != Tree.Kind.BLOCK) break;
                block = ((WhileLoopTree)statement).getStatement();
                break;
            }
            case FOR_LOOP: {
                if (((ForLoopTree)statement).getStatement().getKind() != Tree.Kind.BLOCK) break;
                block = ((ForLoopTree)statement).getStatement();
                break;
            }
            case ENHANCED_FOR_LOOP: {
                if (((EnhancedForLoopTree)statement).getStatement().getKind() != Tree.Kind.BLOCK) break;
                block = ((EnhancedForLoopTree)statement).getStatement();
                break;
            }
            case DO_WHILE_LOOP: {
                if (((DoWhileLoopTree)statement).getStatement().getKind() != Tree.Kind.BLOCK) break;
                block = ((DoWhileLoopTree)statement).getStatement();
            }
        }
        if (block != null) {
            ts.move((int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), block));
            if (ts.movePrevious() && ts.token().id() == JavaTokenId.RBRACE) {
                result.add(new int[]{ts.offset(), ts.offset() + ts.token().length()});
            }
        }
        if (target.getKind() == Tree.Kind.LABELED_STATEMENT && this.isIn(caretPosition, Utilities.findIdentifierSpan(info, document, breakOrContinue))) {
            result.addAll(this.detectLabel(info, document, info.getTrees().getPath(info.getCompilationUnit(), target)));
        }
        return result;
    }

    private List<int[]> detectLabel(final CompilationInfo info, final Document document, TreePath labeledStatement) {
        final ArrayList<int[]> result = new ArrayList<int[]>();
        if (labeledStatement.getLeaf().getKind() == Tree.Kind.LABELED_STATEMENT) {
            final Name label = ((LabeledStatementTree)labeledStatement.getLeaf()).getLabel();
            new ErrorAwareTreePathScanner<Void, Void>(){

                public Void visitBreak(BreakTree node, Void p) {
                    if (node.getLabel() != null && label.contentEquals(node.getLabel())) {
                        result.add(Utilities.findIdentifierSpan(this.getCurrentPath(), info, document));
                    }
                    return (Void)super.visitBreak(node, (Object)p);
                }

                public Void visitContinue(ContinueTree node, Void p) {
                    if (node.getLabel() != null && label.contentEquals(node.getLabel())) {
                        result.add(Utilities.findIdentifierSpan(this.getCurrentPath(), info, document));
                    }
                    return (Void)super.visitContinue(node, (Object)p);
                }
            }.scan(labeledStatement, null);
        }
        return result;
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }
}

