/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.dtd;

import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.lib.api.dtd.ReaderProvider;
import org.netbeans.modules.html.editor.lib.api.dtd.ReaderProviderFactory;
import org.netbeans.modules.html.editor.lib.dtd.DTD;
import org.netbeans.modules.html.editor.lib.dtd.DTDParser;
import org.netbeans.modules.html.editor.lib.dtd.InvalidateEvent;
import org.netbeans.modules.html.editor.lib.dtd.InvalidateListener;
import org.openide.util.Lookup;

public class Registry {
    private static Map dtdMap = new HashMap();
    private static List<ReaderProvider> providers;
    private static LinkedList listeners;
    private static Map provider2dtds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvalidateListener(InvalidateListener listener) {
        LinkedList linkedList = listeners;
        synchronized (linkedList) {
            listeners.add(new WeakReference<InvalidateListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvalidateListener(InvalidateListener listener) {
        LinkedList linkedList = listeners;
        synchronized (linkedList) {
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                WeakReference ref = (WeakReference)it.next();
                InvalidateListener obj = (InvalidateListener)ref.get();
                if (obj != null && obj != listener) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireInvalidateEvent(Set identifiers) {
        Iterator it = identifiers.iterator();
        while (it.hasNext()) {
            dtdMap.remove(it.next());
        }
        ArrayList<InvalidateListener> targets = new ArrayList<InvalidateListener>();
        LinkedList linkedList = listeners;
        synchronized (linkedList) {
            Iterator it2 = listeners.iterator();
            while (it2.hasNext()) {
                WeakReference ref = (WeakReference)it2.next();
                InvalidateListener obj = (InvalidateListener)ref.get();
                if (obj == null) {
                    it2.remove();
                    continue;
                }
                targets.add(obj);
            }
        }
        InvalidateEvent evt = new InvalidateEvent(identifiers);
        for (InvalidateListener l : targets) {
            l.dtdInvalidated(evt);
        }
    }

    public static void registerReaderProvider(ReaderProvider provider) {
        Registry.getProviders().add(provider);
    }

    public static void invalidateReaderProvider(ReaderProvider provider) {
        Set identifiers = (Set)provider2dtds.get(provider);
        if (identifiers != null) {
            Registry.fireInvalidateEvent(identifiers);
            provider2dtds.remove(provider);
        }
    }

    public static void unregisterReaderProvider(ReaderProvider provider) {
        Registry.getProviders().remove(provider);
        Registry.invalidateReaderProvider(provider);
    }

    private static DTD getWeak(String identifier) {
        WeakReference ref = (WeakReference)dtdMap.get(identifier);
        if (ref == null) {
            return null;
        }
        DTD dtd = (DTD)ref.get();
        if (dtd == null) {
            dtdMap.remove(identifier);
        }
        return dtd;
    }

    private static void putWeak(String identifier, DTD dtd) {
        dtdMap.put(identifier, new WeakReference<DTD>(dtd));
    }

    private static synchronized Collection<ReaderProvider> getProviders() {
        if (providers == null) {
            providers = new ArrayList<ReaderProvider>();
            Collection result = Lookup.getDefault().lookupAll(ReaderProviderFactory.class);
            for (ReaderProviderFactory factory : result) {
                providers.addAll(factory.getProviders());
            }
        }
        return providers;
    }

    private static ReaderProvider getProvider(String identifier, String fileName) {
        for (ReaderProvider prov : Registry.getProviders()) {
            Reader reader = prov.getReaderForIdentifier(identifier, fileName);
            if (reader == null) continue;
            return prov;
        }
        return null;
    }

    private static DTD parseDTD(String identifier, String fileName) {
        ReaderProvider prov = Registry.getProvider(identifier, fileName);
        if (prov == null) {
            return null;
        }
        try {
            DTD dtd = new DTDParser().createDTD(prov, identifier, fileName);
            if (dtd != null) {
                HashSet<String> dtdSet = (HashSet<String>)provider2dtds.get(prov);
                if (dtdSet == null) {
                    dtdSet = new HashSet<String>();
                    provider2dtds.put(prov, dtdSet);
                }
                dtdSet.add(identifier);
                Registry.putWeak(identifier, dtd);
            }
            return dtd;
        }
        catch (DTDParser.WrongDTDException exc) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error parsing DTD for identfier \"" + identifier + "\"; file = " + fileName, exc);
            return null;
        }
    }

    public static DTD getDTD(String identifier, String fileName) {
        DTD dtd = Registry.getWeak(identifier);
        if (dtd == null) {
            dtd = Registry.parseDTD(identifier, fileName);
        }
        return dtd;
    }

    static {
        listeners = new LinkedList();
        provider2dtds = new HashMap();
    }
}

