/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.source;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.netbeans.modules.debugger.jpda.truffle.source.SourceFS;
import org.openide.filesystems.FileObject;

final class SourceFilesCache {
    private static final SourceFilesCache DEFAULT = new SourceFilesCache();
    private final SourceFS fs = new SourceFS();

    private SourceFilesCache() {
    }

    public static SourceFilesCache getDefault() {
        return DEFAULT;
    }

    public URL getSourceFile(String name, long hash, URI uri, String content) throws IOException {
        String path = Long.toHexString(hash) + '/' + name;
        FileObject fo = this.fs.findResource(path);
        if (fo == null) {
            fo = this.fs.createFile(path, content);
            if (fo == null) {
                throw new IllegalArgumentException("Not able to create file with name '" + name + "'. Path = " + path);
            }
            fo.setAttribute("com.oracle.truffle InternalURI", (Object)uri);
        }
        return fo.toURL();
    }
}

