/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.StompWebSocketEndpointRegistration;
import org.springframework.web.socket.config.annotation.WebMvcStompWebSocketEndpointRegistration;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;

public class WebMvcStompEndpointRegistry
implements StompEndpointRegistry {
    private final WebSocketHandler webSocketHandler;
    private final SubProtocolWebSocketHandler subProtocolWebSocketHandler;
    private final StompSubProtocolHandler stompHandler;
    private final List<WebMvcStompWebSocketEndpointRegistration> registrations = new ArrayList<WebMvcStompWebSocketEndpointRegistration>();
    private final TaskScheduler sockJsScheduler;
    private int order = 1;

    public WebMvcStompEndpointRegistry(WebSocketHandler webSocketHandler, UserSessionRegistry userSessionRegistry, TaskScheduler defaultSockJsTaskScheduler) {
        Assert.notNull((Object)webSocketHandler);
        Assert.notNull((Object)userSessionRegistry);
        this.webSocketHandler = webSocketHandler;
        this.subProtocolWebSocketHandler = WebMvcStompEndpointRegistry.unwrapSubProtocolWebSocketHandler(webSocketHandler);
        this.stompHandler = new StompSubProtocolHandler();
        this.stompHandler.setUserSessionRegistry(userSessionRegistry);
        this.sockJsScheduler = defaultSockJsTaskScheduler;
    }

    private static SubProtocolWebSocketHandler unwrapSubProtocolWebSocketHandler(WebSocketHandler webSocketHandler) {
        WebSocketHandler actual = webSocketHandler instanceof WebSocketHandlerDecorator ? ((WebSocketHandlerDecorator)webSocketHandler).getLastHandler() : webSocketHandler;
        Assert.isInstanceOf(SubProtocolWebSocketHandler.class, (Object)actual, (String)("No SubProtocolWebSocketHandler found: " + webSocketHandler));
        return (SubProtocolWebSocketHandler)actual;
    }

    @Override
    public StompWebSocketEndpointRegistration addEndpoint(String ... paths) {
        this.subProtocolWebSocketHandler.addProtocolHandler(this.stompHandler);
        WebMvcStompWebSocketEndpointRegistration registration = new WebMvcStompWebSocketEndpointRegistration(paths, this.webSocketHandler, this.sockJsScheduler);
        this.registrations.add(registration);
        return registration;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public AbstractHandlerMapping getHandlerMapping() {
        LinkedHashMap<String, HttpRequestHandler> urlMap = new LinkedHashMap<String, HttpRequestHandler>();
        for (WebMvcStompWebSocketEndpointRegistration registration : this.registrations) {
            MultiValueMap<HttpRequestHandler, String> mappings = registration.getMappings();
            for (HttpRequestHandler httpHandler : mappings.keySet()) {
                for (String pattern : (List)mappings.get((Object)httpHandler)) {
                    urlMap.put(pattern, httpHandler);
                }
            }
        }
        SimpleUrlHandlerMapping hm = new SimpleUrlHandlerMapping();
        hm.setUrlMap(urlMap);
        hm.setOrder(this.order);
        return hm;
    }
}

