/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.notification;

import java.awt.EventQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.ui.api.UI;
import org.netbeans.modules.hudson.ui.notification.Bundle;
import org.netbeans.modules.hudson.ui.notification.ProblemPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

class ProblemNotification {
    private static final Logger LOG = Logger.getLogger(ProblemNotification.class.getName());
    final HudsonJob job;
    private final int build;
    private final boolean failed;
    private Notification notification;

    ProblemNotification(HudsonJob job, int build, boolean failed) {
        this.job = job;
        this.build = build;
        this.failed = failed;
    }

    private String getTitle() {
        return this.failed ? Bundle.ProblemNotification_title_failed(this.job.getDisplayName(), this.build) : Bundle.ProblemNotification_title_unstable(this.job.getDisplayName(), this.build);
    }

    String showFailureText() {
        return this.failed ? Bundle.ProblemNotification_description_failed() : Bundle.ProblemNotification_description_unstable();
    }

    void showFailure() {
        UI.selectNode(this.job.getInstance().getUrl(), this.job.getName(), Integer.toString(this.build));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (HudsonJobBuild b : ProblemNotification.this.job.getBuilds()) {
                    if (b.getNumber() != ProblemNotification.this.build) continue;
                    if (ProblemNotification.this.failed) {
                        UI.showConsoleAction(b).actionPerformed(null);
                        break;
                    }
                    if (b.getMavenModules().isEmpty()) {
                        UI.showFailuresAction().createContextAwareInstance(Lookups.singleton((Object)b)).actionPerformed(null);
                        break;
                    }
                    for (HudsonMavenModuleBuild module : b.getMavenModules()) {
                        switch (module.getColor()) {
                            case yellow: 
                            case yellow_anime: {
                                UI.showFailuresAction().createContextAwareInstance(Lookups.singleton((Object)module)).actionPerformed(null);
                            }
                        }
                    }
                }
            }
        });
    }

    void ignore() {
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.ProblemNotification_ignore_question(this.job.getDisplayName(), this.job.getInstance().getName()), Bundle.ProblemNotification_ignore_title(this.job.getDisplayName()), 2)) == NotifyDescriptor.OK_OPTION) {
            this.job.setSalient(false);
        }
    }

    private NotificationDisplayer.Priority getPriority() {
        return this.failed ? NotificationDisplayer.Priority.HIGH : NotificationDisplayer.Priority.NORMAL;
    }

    private NotificationDisplayer.Category getCategory() {
        return this.failed ? NotificationDisplayer.Category.ERROR : NotificationDisplayer.Category.WARNING;
    }

    private Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/hudson/ui/resources/notification.png", (boolean)true);
    }

    void add() {
        LOG.log(Level.FINE, "Adding {0}", this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProblemNotification.this.notification = NotificationDisplayer.getDefault().notify(ProblemNotification.this.getTitle(), ProblemNotification.this.getIcon(), (JComponent)new ProblemPanel(ProblemNotification.this), (JComponent)new ProblemPanel(ProblemNotification.this), ProblemNotification.this.getPriority(), ProblemNotification.this.getCategory());
            }
        });
    }

    void remove() {
        if (this.notification != null) {
            LOG.log(Level.FINE, "Removing {0}", this);
            this.notification.clear();
            this.notification = null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProblemNotification)) {
            return false;
        }
        ProblemNotification other = (ProblemNotification)obj;
        return this.job.getName().equals(other.job.getName()) && this.build == other.build;
    }

    public int hashCode() {
        return this.job.getName().hashCode() ^ this.build;
    }

    public String toString() {
        return "ProblemNotification[" + this.job.getName() + "#" + this.build + "]";
    }
}

