/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.openide.util.ImageUtilities;

public class ContentHeader
extends JPanel
implements Constants {
    private static final Image IMG_BANNER;
    private static final Color COL_BANNER_LEFT;
    private static final Color COL_BANNER_RIGHT;
    private final JLabel lblTitle = new JLabel();
    private final Color COL_GRADIENT_START = new Color(249, 255, 249);
    private final Color COL_GRADIENT_END = new Color(237, 241, 244);

    public ContentHeader(String title) {
        this.setLayout(new BorderLayout());
        this.lblTitle.setText(title);
        this.lblTitle.setFont(CONTENT_HEADER_FONT);
        this.lblTitle.setForeground(Color.white);
        this.add((Component)this.lblTitle, "West");
        this.setBorder(BorderFactory.createEmptyBorder(30, 34, 15, 34));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        g2d.setColor(Utils.getBorderColor());
        g2d.drawRect(0, 0, width, 12);
        if (UIManager.getBoolean("nb.startpage.defaultbackground")) {
            g2d.setColor(UIManager.getColor("Tree.background"));
        } else {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.COL_GRADIENT_START, 0.0f, 12.0f, this.COL_GRADIENT_END));
        }
        g2d.fillRect(1, 0, width - 2, 12);
        int imgWidth = IMG_BANNER.getWidth(this);
        int imgX = (width - imgWidth) / 2;
        g2d.drawImage(IMG_BANNER, imgX, 13, imgWidth, height - 13, this);
        if (imgX > 0) {
            g2d.setPaint(COL_BANNER_LEFT);
            g2d.fillRect(0, 13, imgX, height - 13);
            g2d.setPaint(COL_BANNER_RIGHT);
            g2d.fillRect(width - imgX - 1, 13, imgX + 1, height - 13);
        }
    }

    static {
        String imgName = UIManager.getString("nb.startpage.imagename.contentheader");
        if (null == imgName) {
            imgName = "org/netbeans/modules/welcome/resources/content_banner.png";
        }
        IMG_BANNER = ImageUtilities.loadImage((String)imgName, (boolean)true);
        Color c = UIManager.getColor("nb.startpage.contentheader.color1");
        if (null == c) {
            c = new Color(235, 0, 71);
        }
        COL_BANNER_LEFT = c;
        c = UIManager.getColor("nb.startpage.contentheader.color2");
        if (null == c) {
            c = new Color(0, 116, 226);
        }
        COL_BANNER_RIGHT = c;
    }
}

