/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.uiapi.BuildExecutionSupportImplementation;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class BuildExecutionSupportImpl
implements BuildExecutionSupportImplementation {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final List<IndentityHashCodeWrapper> runningItems = new ArrayList<IndentityHashCodeWrapper>();
    private BuildExecutionSupport.Item lastFinishedItem;
    private static final int HISTORY_MAX = 7;
    private final Map<String, List<BuildExecutionSupport.ActionItem>> historyItems = new HashMap<String, List<BuildExecutionSupport.ActionItem>>();

    public static BuildExecutionSupportImplementation getInstance() {
        return (BuildExecutionSupportImplementation)Lookup.getDefault().lookup(BuildExecutionSupportImplementation.class);
    }

    public BuildExecutionSupportImpl() {
        OpenProjects.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("openProjects")) {
                    List<Project> opened = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
                    HashSet<FileObject> fos = new HashSet<FileObject>();
                    for (Project p : opened) {
                        if (p == null) continue;
                        fos.add(p.getProjectDirectory());
                    }
                    List list = BuildExecutionSupportImpl.this.runningItems;
                    synchronized (list) {
                        for (List lst : BuildExecutionSupportImpl.this.historyItems.values()) {
                            Iterator it = lst.iterator();
                            while (it.hasNext()) {
                                BuildExecutionSupport.ActionItem item = (BuildExecutionSupport.ActionItem)it.next();
                                if (fos.contains(item.getProjectDirectory())) continue;
                                it.remove();
                            }
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFinishedItem(BuildExecutionSupport.Item item) {
        List<IndentityHashCodeWrapper> list = this.runningItems;
        synchronized (list) {
            this.lastFinishedItem = item;
            this.runningItems.remove(new IndentityHashCodeWrapper(item));
            if (item instanceof BuildExecutionSupport.ActionItem) {
                BuildExecutionSupport.ActionItem ai = (BuildExecutionSupport.ActionItem)item;
                String action = ai.getAction();
                assert (action != null);
                if ("run".equals(action)) {
                    List<BuildExecutionSupport.ActionItem> list2 = this.historyItems.get(action);
                    if (list2 == null) {
                        list2 = new ArrayList<BuildExecutionSupport.ActionItem>();
                        this.historyItems.put(action, list2);
                    }
                    if (list2.contains(ai)) {
                        list2.remove(ai);
                    }
                    list2.add(ai);
                    if (list2.size() > 7) {
                        list2.remove(0);
                    }
                }
            }
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRunningItem(BuildExecutionSupport.Item item) {
        List<IndentityHashCodeWrapper> list = this.runningItems;
        synchronized (list) {
            IndentityHashCodeWrapper indentityHashCodeWrapper = new IndentityHashCodeWrapper(item);
            if (!this.runningItems.contains(indentityHashCodeWrapper)) {
                this.runningItems.add(indentityHashCodeWrapper);
            }
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildExecutionSupport.Item getLastItem() {
        List<IndentityHashCodeWrapper> list = this.runningItems;
        synchronized (list) {
            return this.lastFinishedItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuildExecutionSupport.Item> getRunningItems() {
        ArrayList<BuildExecutionSupport.Item> items = new ArrayList<BuildExecutionSupport.Item>();
        List<IndentityHashCodeWrapper> list = this.runningItems;
        synchronized (list) {
            for (IndentityHashCodeWrapper wr : this.runningItems) {
                items.add(wr.item);
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuildExecutionSupport.ActionItem> getHistoryFor(String action) {
        ArrayList<BuildExecutionSupport.ActionItem> items = new ArrayList<BuildExecutionSupport.ActionItem>();
        List<IndentityHashCodeWrapper> list = this.runningItems;
        synchronized (list) {
            List<BuildExecutionSupport.ActionItem> itms = this.historyItems.get(action);
            if (itms != null) {
                items.addAll(itms);
                Collections.reverse(items);
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> lsts;
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            lsts = new ArrayList<ChangeListener>(this.listeners);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : lsts) {
            l.stateChanged(event);
        }
    }

    private static class IndentityHashCodeWrapper {
        final BuildExecutionSupport.Item item;

        public IndentityHashCodeWrapper(BuildExecutionSupport.Item item) {
            this.item = item;
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.item != null ? System.identityHashCode(this.item) : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndentityHashCodeWrapper other = (IndentityHashCodeWrapper)obj;
            return this.item == other.item;
        }
    }
}

