/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phing.file;

import java.awt.EventQueue;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.phing.exec.PhingExecutable;
import org.netbeans.modules.php.phing.file.BuildXml;
import org.openide.util.RequestProcessor;

public final class PhingTargets
implements ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(PhingTargets.class.getName());
    public static final String DEFAULT_TARGET = "default";
    private static final RequestProcessor RP = new RequestProcessor(PhingTargets.class);
    private final Project project;
    private final BuildXml buildXml;
    private volatile List<String> targets;

    private PhingTargets(Project project, BuildXml buildXml) {
        assert (project != null);
        assert (buildXml != null);
        this.project = project;
        this.buildXml = buildXml;
    }

    public static PhingTargets create(Project project, BuildXml buildXml) {
        assert (project != null);
        assert (buildXml != null);
        PhingTargets phingTargets = new PhingTargets(project, buildXml);
        buildXml.addChangeListener(phingTargets);
        return phingTargets;
    }

    @CheckForNull
    public List<String> getTargets() {
        List<String> targetsRef = this.targets;
        return targetsRef == null ? null : Collections.unmodifiableList(targetsRef);
    }

    public List<String> loadTargets(@NullAllowed Long timeout, @NullAllowed TimeUnit unit) throws ExecutionException, TimeoutException {
        List<String> targetsRef = this.targets;
        if (targetsRef != null) {
            return Collections.unmodifiableList(targetsRef);
        }
        assert (!EventQueue.isDispatchThread());
        Future<List<String>> targetsJob = this.getTargetsJob();
        if (targetsJob == null) {
            return null;
        }
        try {
            List<String> allTargets;
            if (timeout != null) {
                assert (unit != null);
                allTargets = targetsJob.get(timeout, unit);
            } else {
                allTargets = targetsJob.get();
            }
            this.targets = new CopyOnWriteArrayList<String>(allTargets);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return this.getTargets();
    }

    @CheckForNull
    private Future<List<String>> getTargetsJob() {
        PhingExecutable phing = PhingExecutable.getDefault(this.project, this.buildXml.getFile().getParentFile(), false);
        if (phing == null) {
            return null;
        }
        return phing.listTargets();
    }

    public void reset() {
        this.targets = null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.reset();
    }
}

