/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.ide;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PatchContextChooser
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private JButton locationButton;
    private JTextField locationField;
    private JLabel locationLabel;
    private BeanTreeView projectsView;
    private JLabel titleLabel;

    public PatchContextChooser() {
        this.initComponents();
        this.projectsView.setPopupAllowed(false);
        this.projectsView.setRootVisible(false);
        this.projectsView.setSelectionMode(1);
        this.manager = new ExplorerManager();
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            LogicalViewProvider view = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            if (view == null) continue;
            Node node = view.createLogicalView();
            nodes.add(node);
        }
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                if (n1 == null && n2 == null) {
                    return 0;
                }
                if (n1 == null) {
                    return -1;
                }
                if (n2 == null) {
                    return 1;
                }
                return n1.getDisplayName().compareTo(n2.getDisplayName());
            }
        });
        Children.Array children = new Children.Array();
        children.add(nodes.toArray(new Node[nodes.size()]));
        AbstractNode root = new AbstractNode((Children)children);
        this.manager.setRootContext((Node)root);
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    Project project;
                    Lookup lookup;
                    DataObject dob;
                    Node[] nodes = PatchContextChooser.this.manager.getSelectedNodes();
                    FileObject fob = null;
                    if (nodes.length != 0 && (fob = (dob = (DataObject)(lookup = nodes[0].getLookup()).lookup(DataObject.class)) != null ? dob.getPrimaryFile() : (FileObject)lookup.lookup(FileObject.class)) == null && (project = (Project)lookup.lookup(Project.class)) != null) {
                        fob = project.getProjectDirectory();
                    }
                    PatchContextChooser.this.locationField.setText(fob == null ? "" : FileUtil.getFileDisplayName(fob));
                }
            }
        });
    }

    private void initComponents() {
        this.projectsView = new BeanTreeView();
        this.titleLabel = new JLabel();
        this.locationLabel = new JLabel();
        this.locationField = new JTextField();
        this.locationButton = new JButton();
        this.titleLabel.setText(NbBundle.getMessage(PatchContextChooser.class, (String)"PatchContextChooser.titleLabel.text"));
        this.locationLabel.setText(NbBundle.getMessage(PatchContextChooser.class, (String)"PatchContextChooser.locationLabel.text"));
        this.locationButton.setText(NbBundle.getMessage(PatchContextChooser.class, (String)"PatchContextChooser.locationButton.text"));
        this.locationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatchContextChooser.this.locationButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.projectsView, -1, 460, Short.MAX_VALUE).addComponent(this.titleLabel).addGroup(layout.createSequentialGroup().addComponent(this.locationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locationField, -1, 254, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locationButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.projectsView, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationLabel).addComponent(this.locationField, -2, -1, -2).addComponent(this.locationButton))));
    }

    private void locationButtonActionPerformed(ActionEvent evt) {
        FileChooserBuilder builder = new FileChooserBuilder(PatchContextChooser.class);
        File file = builder.setApproveText(NbBundle.getMessage(PatchContextChooser.class, (String)"LBL_Select")).showOpenDialog();
        if (file != null) {
            FileObject fob = FileUtil.toFileObject((File)file);
            this.locationField.setText(FileUtil.getFileDisplayName((FileObject)fob));
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public File getSelectedFile() {
        File file = null;
        String fileName = this.locationField.getText().trim();
        if (!"".equals(fileName) && !(file = new File(fileName)).exists()) {
            file = null;
        }
        return file;
    }
}

