/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.project.api.PhpOptions;

class ProxyClient {
    private static final Logger LOGGER = Logger.getLogger(ProxyClient.class.getName());
    private String proxyHost;
    private int proxyPort;
    private int idePort;
    private String ideKey;

    static ProxyClient getInstance(DebuggerOptions options) {
        return options.getDebugProxy() != null ? new ProxyClient(options) : null;
    }

    private ProxyClient(DebuggerOptions options) {
        assert (options != null);
        assert (options.getDebugProxy().first() != null);
        assert (options.getDebugProxy().second() != null);
        this.proxyHost = (String)options.getDebugProxy().first();
        this.proxyPort = (Integer)options.getDebugProxy().second();
        this.idePort = PhpOptions.getInstance().getDebuggerPort();
        this.ideKey = PhpOptions.getInstance().getDebuggerSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean register() {
        boolean retval;
        block7: {
            retval = false;
            String command = ProxyClient.getProxyInitCommand(this.idePort, this.ideKey);
            try {
                Socket socket = new Socket(this.proxyHost, this.proxyPort);
                OutputStream outputStream = socket.getOutputStream();
                InputStream inputStream = socket.getInputStream();
                try {
                    ProxyClient.sendCommand(outputStream, command);
                    String response = ProxyClient.getResponse(inputStream, command);
                    retval = response != null;
                }
                finally {
                    outputStream.close();
                    inputStream.close();
                    socket.close();
                }
            }
            catch (UnknownHostException ex) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
            catch (IOException ex) {
                if (!LOGGER.isLoggable(Level.INFO)) break block7;
                LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister() {
        block19: {
            String command = ProxyClient.getProxyStopCommand(this.ideKey);
            try {
                socket.setSoTimeout(5000);
                try (Socket socket = new Socket(this.proxyHost, this.proxyPort);
                     OutputStream outputStream = socket.getOutputStream();){
                    ProxyClient.sendCommand(outputStream, command);
                }
            }
            catch (UnknownHostException ex) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
            catch (IOException ex) {
                if (!LOGGER.isLoggable(Level.INFO)) break block19;
                LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
    }

    private static String getProxyInitCommand(int idePort, String ideKey) {
        return String.format("proxyinit -p %d -k %s -m 0", idePort, ideKey);
    }

    private static String getProxyStopCommand(String ideKey) {
        return String.format("proxystop -k %s", ideKey);
    }

    private static void sendCommand(OutputStream outputStream, String command) throws IOException {
        outputStream.write(command.getBytes(Charset.defaultCharset()));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("send command: %s: ", command));
        }
    }

    private static String getResponse(InputStream inputStream, String command) throws IOException {
        int nextByte;
        int len;
        String retval = null;
        int available = 1024;
        byte[] responseBytes = new byte[available];
        for (len = 0; (nextByte = inputStream.read()) != -1 && len < available; ++len) {
            responseBytes[len] = (byte)nextByte;
        }
        if (len > 0) {
            retval = new String(responseBytes, 0, len, Charset.defaultCharset());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, String.format("response(%s) is %s: ", command, retval));
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("No response after command(\"%s\"): ", command));
        }
        return retval;
    }
}

