/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Bundle;
import org.netbeans.modules.java.j2seplatform.platformdefinition.DefaultPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs.NBJRTUtil;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class J2SEPlatformCustomizer
extends JTabbedPane {
    static final int PREF_WIDTH = 600;
    static final int PREF_HEIGHT = 350;
    private static final Logger LOG = Logger.getLogger(J2SEPlatformCustomizer.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(J2SEPlatformCustomizer.class);
    private static final String CUSTOMIZERS_PATH = "org-netbeans-api-java/platform/j2seplatform/customizers/";
    private static final String SUPPORTS_DEFAULT_PLATFORM = "supportsDefaultPlatform";
    private static final String URL_SEPARATOR = "/";
    static final int CLASSPATH = 0;
    static final int SOURCES = 1;
    static final int JAVADOC = 2;
    private J2SEPlatformImpl platform;

    public J2SEPlatformCustomizer(J2SEPlatformImpl platform) {
        this.platform = platform;
        this.initComponents();
    }

    private void initComponents() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AN_J2SEPlatformCustomizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_J2SEPlatformCustomizer"));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Classes"), this.createPathTab(0));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Sources"), this.createPathTab(1));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Javadoc"), this.createPathTab(2));
        Lookup lkp = Lookups.forPath((String)CUSTOMIZERS_PATH);
        boolean isDefaultPlatform = this.platform instanceof DefaultPlatformImpl;
        for (Lookup.Item li : lkp.lookupResult(Customizer.class).allItems()) {
            Customizer c = (Customizer)li.getInstance();
            if (!(c instanceof Component)) continue;
            String name = li.getId();
            FileObject fo = FileUtil.getConfigFile((String)String.format("%s.instance", name));
            if (fo != null) {
                try {
                    name = fo.getFileSystem().getDecorator().annotateName(fo.getName(), Collections.singleton(fo));
                }
                catch (FileStateInvalidException ex) {
                    name = fo.getName();
                }
                if (isDefaultPlatform && fo.getAttribute(SUPPORTS_DEFAULT_PLATFORM) == Boolean.FALSE) continue;
            }
            c.setObject(this.platform);
            this.addTab(name, (Component)((Object)c));
        }
    }

    private JComponent createPathTab(int type) {
        return new PathView(this.platform, type);
    }

    private static enum IconKind {
        ARCHVIVE{

            @Override
            protected Icon createIcon() {
                return ImageUtilities.loadImageIcon((String)IconKind.RES_ARCHIVE, (boolean)false);
            }
        }
        ,
        FOLDER{

            @Override
            protected Icon createIcon() {
                return ImageUtilities.image2Icon((Image)DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate().getIcon(1));
            }
        }
        ,
        NET{

            @Override
            protected Icon createIcon() {
                return ImageUtilities.loadImageIcon((String)IconKind.RES_NET, (boolean)false);
            }
        }
        ,
        MODULE{

            @Override
            protected Icon createIcon() {
                return ImageUtilities.loadImageIcon((String)IconKind.RES_MODULE, (boolean)false);
            }
        }
        ,
        UNKNOWN{

            @Override
            protected Icon createIcon() {
                return ImageUtilities.loadImageIcon((String)IconKind.RES_EMPTY, (boolean)false);
            }
        };

        private static final String RES_ARCHIVE = "org/netbeans/modules/java/j2seplatform/resources/jar.png";
        private static final String RES_NET = "org/netbeans/modules/java/j2seplatform/resources/web.gif";
        private static final String RES_MODULE = "org/netbeans/modules/java/j2seplatform/resources/module.png";
        private static final String RES_EMPTY = "org/netbeans/modules/java/j2seplatform/resources/empty.png";
        private static Icon[] iconCache;

        @NonNull
        public Icon getIcon() {
            Icon icon;
            if (iconCache == null) {
                iconCache = new Icon[IconKind.values().length];
            }
            if ((icon = iconCache[this.ordinal()]) == null) {
                IconKind.iconCache[this.ordinal()] = icon = this.createIcon();
            }
            return icon;
        }

        protected abstract Icon createIcon();
    }

    private static class ArchiveFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public ArchiveFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            if (!this.extensions.contains(extension)) {
                return false;
            }
            try {
                return FileUtil.isArchiveFile((URL)Utilities.toURI((File)f).toURL());
            }
            catch (MalformedURLException e) {
                Exceptions.printStackTrace((Throwable)e);
                return false;
            }
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    static class PathRenderer
    extends DefaultListCellRenderer {
        PathRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon = null;
            if (value instanceof URL) {
                Pair<String, Icon> p = PathRenderer.getDisplayName((URL)value);
                value = p.first();
                icon = (Icon)p.second();
            }
            Component res = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setIcon(icon);
            return res;
        }

        @NonNull
        private static Pair<String, Icon> getDisplayName(@NonNull URL url) {
            IconKind iconKind = IconKind.UNKNOWN;
            try {
                Pair<URL, String> parsed = NBJRTUtil.parseURI(url.toURI());
                if (parsed != null) {
                    String moduleName = (String)parsed.second();
                    int end = moduleName.endsWith(J2SEPlatformCustomizer.URL_SEPARATOR) ? moduleName.length() - J2SEPlatformCustomizer.URL_SEPARATOR.length() : moduleName.length();
                    int start = end == 0 ? -1 : moduleName.lastIndexOf(J2SEPlatformCustomizer.URL_SEPARATOR, end - 1);
                    start = start < 0 ? 0 : start + J2SEPlatformCustomizer.URL_SEPARATOR.length();
                    moduleName = moduleName.substring(start, end);
                    iconKind = IconKind.MODULE;
                    return Pair.of((Object)moduleName, (Object)iconKind.getIcon());
                }
            }
            catch (URISyntaxException parsed) {
                // empty catch block
            }
            if ("jar".equals(url.getProtocol())) {
                iconKind = IconKind.ARCHVIVE;
                URL fileURL = FileUtil.getArchiveFile((URL)url);
                if (FileUtil.getArchiveRoot((URL)fileURL).equals(url)) {
                    url = fileURL;
                } else {
                    return Pair.of((Object)url.toExternalForm(), (Object)iconKind.getIcon());
                }
            }
            if ("file".equals(url.getProtocol())) {
                if (iconKind == IconKind.UNKNOWN) {
                    iconKind = IconKind.FOLDER;
                }
                File f = Utilities.toFile((URI)URI.create(url.toExternalForm()));
                return Pair.of((Object)f.getAbsolutePath(), (Object)iconKind.getIcon());
            }
            if (url.getProtocol().startsWith("http") || url.getProtocol().startsWith("ftp")) {
                iconKind = IconKind.NET;
            }
            return Pair.of((Object)url.toExternalForm(), (Object)iconKind.getIcon());
        }
    }

    static class PathModel
    extends AbstractListModel {
        private J2SEPlatformImpl platform;
        private int type;
        private volatile List<URL> data;

        public PathModel(J2SEPlatformImpl platform, int type) {
            this.platform = platform;
            this.type = type;
        }

        @Override
        public int getSize() {
            return this.getData().size();
        }

        @Override
        public Object getElementAt(int index) {
            List<URL> list = this.getData();
            return list.get(index);
        }

        private void removePath(int[] indices) {
            List<URL> data = this.getData();
            for (int i = indices.length - 1; i >= 0; --i) {
                data.remove(indices[i]);
            }
            this.updatePlatform();
            this.fireIntervalRemoved(this, indices[0], indices[indices.length - 1]);
        }

        private void moveUpPath(int[] indices) {
            List<URL> data = this.getData();
            for (int i = 0; i < indices.length; ++i) {
                URL p2 = data.get(indices[i]);
                URL p1 = data.set(indices[i] - 1, p2);
                data.set(indices[i], p1);
            }
            this.updatePlatform();
            this.fireContentsChanged(this, indices[0] - 1, indices[indices.length - 1]);
        }

        private void moveDownPath(int[] indices) {
            List<URL> data = this.getData();
            for (int i = indices.length - 1; i >= 0; --i) {
                URL p1 = data.get(indices[i]);
                URL p2 = data.set(indices[i] + 1, p1);
                data.set(indices[i], p2);
            }
            this.updatePlatform();
            this.fireContentsChanged(this, indices[0], indices[indices.length - 1] + 1);
        }

        private boolean addPath(File f) {
            try {
                return this.addPath(PathModel.findRoot(f, this.type));
            }
            catch (MalformedURLException mue) {
                return false;
            }
        }

        boolean addPath(Collection<? extends URL> urls) {
            if (urls.isEmpty()) {
                return false;
            }
            List<URL> data = this.getData();
            int oldSize = data.size();
            for (URL uRL : urls) {
                data.add(PathModel.safeRoot(uRL));
            }
            this.updatePlatform();
            this.fireIntervalAdded(this, oldSize, oldSize + urls.size() - 1);
            return true;
        }

        void update(@NonNull List<? extends URL> paths) {
            List<URL> data = this.getData();
            int oldSize = data.size();
            data.clear();
            for (URL uRL : paths) {
                data.add(PathModel.safeRoot(uRL));
            }
            this.updatePlatform();
            this.fireContentsChanged(this, 0, Math.max(Math.max(oldSize, data.size()) - 1, 0));
        }

        @NonNull
        List<URI> getRootURIs() {
            ArrayList<URI> roots = new ArrayList<URI>();
            List<URL> data = this.getData();
            for (URL url : data) {
                try {
                    roots.add(url.toURI());
                }
                catch (URISyntaxException ex) {
                    LOG.log(Level.WARNING, "Cannot convert: {0} to URI.", url);
                }
            }
            return Collections.unmodifiableList(roots);
        }

        private static URL safeRoot(@NonNull URL url) {
            if (FileUtil.isArchiveFile((URL)url)) {
                url = FileUtil.getArchiveRoot((URL)url);
            } else if (!url.toExternalForm().endsWith(J2SEPlatformCustomizer.URL_SEPARATOR)) {
                try {
                    url = new URL(url.toExternalForm() + J2SEPlatformCustomizer.URL_SEPARATOR);
                }
                catch (MalformedURLException mue) {
                    Exceptions.printStackTrace((Throwable)mue);
                }
            }
            return url;
        }

        private static Collection<? extends URL> findRoot(File file, int type) throws MalformedURLException {
            FileObject fo;
            if (type != 0 && (fo = URLMapper.findFileObject((URL)FileUtil.urlForArchiveOrDir((File)file))) != null) {
                final Collection<FileObject> result = Collections.synchronizedCollection(new ArrayList());
                if (type == 1) {
                    FileObject root = JavadocAndSourceRootDetection.findSourceRoot((FileObject)fo);
                    if (root != null) {
                        result.add(root);
                    }
                } else if (type == 2) {
                    final AtomicBoolean cancel = new AtomicBoolean();
                    class Task
                    implements ProgressRunnable<Void>,
                    Cancellable {
                        Task() {
                        }

                        public Void run(ProgressHandle handle) {
                            result.addAll(JavadocAndSourceRootDetection.findJavadocRoots((FileObject)fo, (AtomicBoolean)cancel));
                            return null;
                        }

                        public boolean cancel() {
                            cancel.set(true);
                            return true;
                        }
                    }
                    Task task = new Task();
                    ProgressUtils.showProgressDialogAndRun((ProgressRunnable)task, (String)Bundle.TXT_JavadocSearch(file.getAbsolutePath()), (boolean)false);
                }
                if (!result.isEmpty()) {
                    return result.stream().map(FileObject::toURL).collect(Collectors.toList());
                }
            }
            return Collections.singleton(Utilities.toURI((File)file).toURL());
        }

        private synchronized List<URL> getData() {
            if (this.data == null) {
                switch (this.type) {
                    case 0: {
                        RP.execute(new Runnable(){

                            @Override
                            public void run() {
                                final List update = PathModel.getPathList(platform.getBootstrapLibraries());
                                Mutex.EVENT.readAccess(new Runnable(){

                                    @Override
                                    public void run() {
                                        data = update;
                                        this.fireIntervalAdded(this, 0, data.size());
                                    }
                                });
                            }
                        });
                        return Collections.emptyList();
                    }
                    case 1: {
                        this.data = PathModel.getPathList(this.platform.getSourceFolders());
                        break;
                    }
                    case 2: {
                        this.data = new ArrayList<URL>(this.platform.getJavadocFolders());
                    }
                }
            }
            return this.data;
        }

        private static List<URL> getPathList(ClassPath cp) {
            ArrayList<URL> result = new ArrayList<URL>();
            for (ClassPath.Entry entry : cp.entries()) {
                result.add(entry.getURL());
            }
            return result;
        }

        private static ClassPath createClassPath(List<URL> roots) {
            ArrayList<PathResourceImplementation> resources = new ArrayList<PathResourceImplementation>();
            for (URL url : roots) {
                resources.add(ClassPathSupport.createResource((URL)url));
            }
            return ClassPathSupport.createClassPath(resources);
        }

        private void updatePlatform() {
            switch (this.type) {
                case 1: {
                    this.platform.setSourceFolders(PathModel.createClassPath(this.data));
                    break;
                }
                case 2: {
                    this.platform.setJavadocFolders(this.data);
                    break;
                }
                default: {
                    assert (false) : "Trying to update unknown property";
                    break;
                }
            }
        }
    }

    private static class PathView
    extends JPanel {
        private JList resources;
        private JButton addButton;
        private JButton addURLButton;
        private JButton removeButton;
        private JButton moveUpButton;
        private JButton moveDownButton;
        private int type;
        private File currentDir;

        public PathView(J2SEPlatformImpl platform, int type) {
            this.type = type;
            this.initComponents(platform);
        }

        private void initComponents(final J2SEPlatformImpl platform) {
            this.setLayout(new GridBagLayout());
            final JLabel label = new JLabel();
            String key = null;
            String mneKey = null;
            String ad = null;
            switch (this.type) {
                case 0: {
                    key = "TXT_JDKClasspath";
                    mneKey = "MNE_JDKClasspath";
                    ad = "AD_JDKClasspath";
                    break;
                }
                case 1: {
                    key = "TXT_JDKSources";
                    mneKey = "MNE_JDKSources";
                    ad = "AD_JDKSources";
                    break;
                }
                case 2: {
                    key = "TXT_JDKJavadoc";
                    mneKey = "MNE_JDKJavadoc";
                    ad = "AD_JDKJavadoc";
                    break;
                }
                default: {
                    assert (false) : "Illegal type of panel";
                    return;
                }
            }
            label.setText(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)key));
            label.setDisplayedMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)mneKey).charAt(0));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.insets = new Insets(6, 6, 2, 6);
            c.fill = 2;
            c.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(label, c);
            this.add(label);
            this.resources = new JList(new PathModel(platform, this.type));
            this.resources.setCellRenderer(new PathRenderer());
            label.setLabelFor(this.resources);
            this.resources.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)ad));
            this.resources.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.selectionChanged();
                }
            });
            JScrollPane spane = new JScrollPane(this.resources);
            spane.setPreferredSize(new Dimension(400, 200));
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 1;
            c.gridheight = 5;
            c.insets = new Insets(0, 6, 6, 6);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(spane, c);
            this.add(spane);
            if (this.type == 1 || this.type == 2) {
                char mne;
                String text;
                this.addButton = new JButton();
                if (this.type == 1) {
                    text = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Add");
                    mne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Add").charAt(0);
                    ad = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Add");
                } else {
                    text = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddZip");
                    mne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_AddZip").charAt(0);
                    ad = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_AddZip");
                }
                this.addButton.setText(text);
                this.addButton.setMnemonic(mne);
                this.addButton.getAccessibleContext().setAccessibleDescription(ad);
                this.addButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.addPathElement();
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 1;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(0, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.addButton, c);
                this.add(this.addButton);
                if (this.type == 2) {
                    this.addURLButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddURL"));
                    this.addURLButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_AddURL").charAt(0));
                    this.addURLButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.addURLElement();
                        }
                    });
                    c = new GridBagConstraints();
                    c.gridx = 1;
                    c.gridy = 2;
                    c.gridwidth = 0;
                    c.fill = 2;
                    c.anchor = 18;
                    c.insets = new Insets(0, 6, 6, 6);
                    ((GridBagLayout)this.getLayout()).setConstraints(this.addURLButton, c);
                    this.add(this.addURLButton);
                }
                this.removeButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Remove"));
                this.removeButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Remove").charAt(0));
                this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Remove"));
                this.removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.removePathElement();
                    }
                });
                this.removeButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 3;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.removeButton, c);
                this.add(this.removeButton);
                this.moveUpButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Up"));
                this.moveUpButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Up").charAt(0));
                this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Up"));
                this.moveUpButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.moveUpPathElement();
                    }
                });
                this.moveUpButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 4;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveUpButton, c);
                this.add(this.moveUpButton);
                this.moveDownButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Down"));
                this.moveDownButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Down").charAt(0));
                this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Down"));
                this.moveDownButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.moveDownPathElement();
                    }
                });
                this.moveDownButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 5;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(5, 6, 6, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveDownButton, c);
                this.add(this.moveDownButton);
            } else if (platform.getSpecification().getVersion().compareTo((Object)Util.JDK9) >= 0) {
                RP.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!SwingUtilities.isEventDispatchThread()) {
                            boolean hasModules = false;
                            ClassPath boot = platform.getBootstrapLibraries();
                            for (ClassPath.Entry e : boot.entries()) {
                                try {
                                    if (NBJRTUtil.parseURI(e.getURL().toURI()) == null) continue;
                                    hasModules = true;
                                }
                                catch (URISyntaxException ex) {
                                    LOG.log(Level.WARNING, "Cannot resolve URI: {0}", e.getURL());
                                }
                            }
                            if (hasModules) {
                                SwingUtilities.invokeLater(this);
                            }
                        } else {
                            label.setText(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_JDKModules"));
                            label.setDisplayedMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_JDKClasspath").charAt(0));
                        }
                    }
                });
            }
        }

        private void addURLElement() {
            JPanel p = new JPanel();
            GridBagLayout lm = new GridBagLayout();
            p.setLayout(lm);
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = -1;
            c.gridx = -1;
            c.insets = new Insets(12, 12, 12, 6);
            c.anchor = 18;
            JLabel label = new JLabel(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddJavadocURLMessage"));
            label.setDisplayedMnemonic('U');
            lm.setConstraints(label, c);
            p.add(label);
            c = new GridBagConstraints();
            c.gridy = -1;
            c.gridx = -1;
            c.gridwidth = 0;
            c.insets = new Insets(12, 0, 12, 6);
            c.fill = 2;
            c.anchor = 18;
            JTextField text = new JTextField();
            text.setColumns(30);
            text.setText(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_DefaultProtocol"));
            text.selectAll();
            label.setLabelFor(text);
            lm.setConstraints(text, c);
            p.add(text);
            Object[] options = new JButton[]{new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddJavadocURLTitle")), new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Cancel"))};
            options[0].setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Add").charAt(0));
            options[1].setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Cancel").charAt(0));
            DialogDescriptor input = new DialogDescriptor((Object)p, NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddJavadocURLTitle"), true, options, (Object)options[0], 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) == options[0]) {
                try {
                    String value = text.getText();
                    URL url = new URL(value);
                    ((PathModel)this.resources.getModel()).addPath(Collections.singleton(url));
                    this.resources.setSelectedIndex(this.resources.getModel().getSize() - 1);
                }
                catch (MalformedURLException mue) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_InvalidURLFormat"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
        }

        private void addPathElement() {
            int firstIndex = this.resources.getModel().getSize();
            File[] cwd = new File[]{this.currentDir};
            if (PathView.select((PathModel)this.resources.getModel(), cwd, this)) {
                int lastIndex = this.resources.getModel().getSize() - 1;
                if (firstIndex <= lastIndex) {
                    int[] toSelect = new int[lastIndex - firstIndex + 1];
                    for (int i = 0; i < toSelect.length; ++i) {
                        toSelect[i] = firstIndex + i;
                    }
                    this.resources.setSelectedIndices(toSelect);
                }
                this.currentDir = cwd[0];
            }
        }

        private static boolean select(PathModel model, File[] currentDir, Component parentComponent) {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(true);
            String title = null;
            String message = null;
            String approveButtonName = null;
            String approveButtonNameMne = null;
            if (model.type == 1) {
                title = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenSources");
                message = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Sources");
                approveButtonName = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenSources");
                approveButtonNameMne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_OpenSources");
            } else if (model.type == 2) {
                title = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenJavadoc");
                message = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Javadoc");
                approveButtonName = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenJavadoc");
                approveButtonNameMne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_OpenJavadoc");
            }
            chooser.setDialogTitle(title);
            chooser.setApproveButtonText(approveButtonName);
            chooser.setApproveButtonMnemonic(approveButtonNameMne.charAt(0));
            chooser.setFileSelectionMode(2);
            if (Utilities.isMac()) {
                chooser.putClientProperty("JFileChooser.packageIsTraversable", "always");
            }
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(new ArchiveFileFilter(message, new String[]{"ZIP", "JAR"}));
            if (currentDir[0] != null) {
                chooser.setCurrentDirectory(currentDir[0]);
            }
            if (chooser.showOpenDialog(parentComponent) == 0) {
                File[] fs = chooser.getSelectedFiles();
                boolean addingFailed = false;
                for (File f : fs) {
                    File parent;
                    if (!f.exists() && (parent = f.getParentFile()) != null && f.getName().equals(parent.getName()) && parent.exists()) {
                        f = parent;
                    }
                    if (!f.exists()) continue;
                    addingFailed |= !model.addPath(f);
                }
                if (addingFailed) {
                    new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_CanNotAddResolve"), 0);
                }
                currentDir[0] = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
                return true;
            }
            return false;
        }

        private void removePathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.removePath(indices);
            if (indices[indices.length - 1] - indices.length + 1 < this.resources.getModel().getSize()) {
                this.resources.setSelectedIndex(indices[indices.length - 1] - indices.length + 1);
            } else if (indices[0] > 0) {
                this.resources.setSelectedIndex(indices[0] - 1);
            }
        }

        private void moveDownPathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.moveDownPath(indices);
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = indices[i] + 1;
            }
            this.resources.setSelectedIndices(indices);
        }

        private void moveUpPathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.moveUpPath(indices);
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = indices[i] - 1;
            }
            this.resources.setSelectedIndices(indices);
        }

        private void selectionChanged() {
            if (this.type == 0) {
                return;
            }
            int[] indices = this.resources.getSelectedIndices();
            this.removeButton.setEnabled(indices.length > 0);
            this.moveUpButton.setEnabled(indices.length > 0 && indices[0] > 0);
            this.moveDownButton.setEnabled(indices.length > 0 && indices[indices.length - 1] < this.resources.getModel().getSize() - 1);
        }
    }
}

