/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceConstants;
import com.sun.tools.ws.resources.WebserviceapMessages;
import com.sun.tools.ws.util.ClassNameInfo;
import com.sun.tools.ws.wsdl.document.soap.SOAPStyle;
import com.sun.xml.ws.model.RuntimeModeler;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;

public abstract class WebServiceVisitor
extends SimpleElementVisitor6<Void, Object> {
    protected ModelBuilder builder;
    protected String wsdlNamespace;
    protected String typeNamespace;
    protected Stack<SOAPBinding> soapBindingStack;
    protected SOAPBinding typeElementSoapBinding;
    protected SOAPStyle soapStyle = SOAPStyle.DOCUMENT;
    protected boolean wrapped = true;
    protected Port port;
    protected Name serviceImplName;
    protected Name endpointInterfaceName;
    protected AnnotationProcessorContext context;
    protected AnnotationProcessorContext.SeiContext seiContext;
    protected boolean processingSei = false;
    protected String serviceName;
    protected Name packageName;
    protected String portName;
    protected boolean endpointReferencesInterface = false;
    protected boolean hasWebMethods = false;
    protected TypeElement typeElement;
    protected Set<String> processedMethods;
    protected boolean pushedSoapBinding = false;
    private static final NoTypeVisitor NO_TYPE_VISITOR = new NoTypeVisitor();

    public WebServiceVisitor(ModelBuilder builder, AnnotationProcessorContext context) {
        this.builder = builder;
        this.context = context;
        this.soapBindingStack = new Stack();
        this.processedMethods = new HashSet<String>();
    }

    @Override
    public Void visitType(TypeElement e, Object o) {
        WebService webService = e.getAnnotation(WebService.class);
        if (!this.shouldProcessWebService(webService, e)) {
            return null;
        }
        if (this.builder.checkAndSetProcessed(e)) {
            return null;
        }
        this.typeElement = e;
        switch (e.getKind()) {
            case INTERFACE: {
                if (this.endpointInterfaceName != null && !((Object)this.endpointInterfaceName).equals(e.getQualifiedName())) {
                    this.builder.processError(WebserviceapMessages.WEBSERVICEAP_ENDPOINTINTERFACES_DO_NOT_MATCH(this.endpointInterfaceName, e.getQualifiedName()), e);
                }
                this.verifySeiAnnotations(webService, e);
                this.endpointInterfaceName = e.getQualifiedName();
                this.processingSei = true;
                this.preProcessWebService(webService, e);
                this.processWebService(webService, e);
                this.postProcessWebService(webService, e);
                break;
            }
            case CLASS: {
                String endpointInterfaceName;
                this.typeElementSoapBinding = e.getAnnotation(SOAPBinding.class);
                if (this.serviceImplName == null) {
                    this.serviceImplName = e.getQualifiedName();
                }
                String string = endpointInterfaceName = webService != null ? webService.endpointInterface() : null;
                if (endpointInterfaceName != null && endpointInterfaceName.length() > 0) {
                    this.checkForInvalidImplAnnotation(e, SOAPBinding.class);
                    if (webService.name().length() > 0) {
                        this.builder.processError(WebserviceapMessages.WEBSERVICEAP_ENDPOINTINTEFACE_PLUS_ELEMENT("name"), e);
                    }
                    this.endpointReferencesInterface = true;
                    this.verifyImplAnnotations(e);
                    this.inspectEndpointInterface(endpointInterfaceName, e);
                    this.serviceImplName = null;
                    return null;
                }
                this.processingSei = false;
                this.preProcessWebService(webService, e);
                this.processWebService(webService, e);
                this.serviceImplName = null;
                this.postProcessWebService(webService, e);
                this.serviceImplName = null;
            }
        }
        return null;
    }

    protected void verifySeiAnnotations(WebService webService, TypeElement d) {
        if (webService.endpointInterface().length() > 0) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_ENDPOINTINTERFACE_ON_INTERFACE(d.getQualifiedName(), webService.endpointInterface()), d);
        }
        if (webService.serviceName().length() > 0) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_INVALID_SEI_ANNOTATION_ELEMENT("serviceName", d.getQualifiedName()), d);
        }
        if (webService.portName().length() > 0) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_INVALID_SEI_ANNOTATION_ELEMENT("portName", d.getQualifiedName()), d);
        }
    }

    protected void verifyImplAnnotations(TypeElement d) {
        for (ExecutableElement method : ElementFilter.methodsIn(d.getEnclosedElements())) {
            this.checkForInvalidImplAnnotation(method, WebMethod.class);
            this.checkForInvalidImplAnnotation(method, Oneway.class);
            this.checkForInvalidImplAnnotation(method, WebResult.class);
            for (VariableElement variableElement : method.getParameters()) {
                this.checkForInvalidImplAnnotation(variableElement, WebParam.class);
            }
        }
    }

    protected void checkForInvalidSeiAnnotation(TypeElement element, Class annotationClass) {
        Object annotation = element.getAnnotation(annotationClass);
        if (annotation != null) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_INVALID_SEI_ANNOTATION(annotationClass.getName(), element.getQualifiedName()), element);
        }
    }

    protected void checkForInvalidImplAnnotation(Element element, Class annotationClass) {
        Object annotation = element.getAnnotation(annotationClass);
        if (annotation != null) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_ENDPOINTINTEFACE_PLUS_ANNOTATION(annotationClass.getName()), element);
        }
    }

    protected void preProcessWebService(WebService webService, TypeElement element) {
        this.processedMethods = new HashSet<String>();
        this.seiContext = this.context.getSeiContext(element);
        String targetNamespace = null;
        if (webService != null) {
            targetNamespace = webService.targetNamespace();
        }
        PackageElement packageElement = this.builder.getProcessingEnvironment().getElementUtils().getPackageOf(element);
        if (targetNamespace == null || targetNamespace.length() == 0) {
            String packageName = packageElement.getQualifiedName().toString();
            if (packageName == null || packageName.length() == 0) {
                this.builder.processError(WebserviceapMessages.WEBSERVICEAP_NO_PACKAGE_CLASS_MUST_HAVE_TARGETNAMESPACE(element.getQualifiedName()), element);
            }
            targetNamespace = RuntimeModeler.getNamespace(packageName);
        }
        this.seiContext.setNamespaceUri(targetNamespace);
        if (this.serviceImplName == null) {
            this.serviceImplName = this.seiContext.getSeiImplName();
        }
        if (this.serviceImplName != null) {
            this.seiContext.setSeiImplName(this.serviceImplName);
            this.context.addSeiContext(this.serviceImplName, this.seiContext);
        }
        this.portName = ClassNameInfo.getName(element.getSimpleName().toString().replace('$', '_'));
        this.packageName = packageElement.getQualifiedName();
        this.portName = webService != null && webService.name() != null && webService.name().length() > 0 ? webService.name() : this.portName;
        this.serviceName = ClassNameInfo.getName(element.getQualifiedName().toString()) + WebServiceConstants.SERVICE.getValue();
        this.serviceName = webService != null && webService.serviceName() != null && webService.serviceName().length() > 0 ? webService.serviceName() : this.serviceName;
        this.typeNamespace = this.wsdlNamespace = this.seiContext.getNamespaceUri();
        SOAPBinding soapBinding = element.getAnnotation(SOAPBinding.class);
        if (soapBinding != null) {
            this.pushedSoapBinding = this.pushSoapBinding(soapBinding, element, element);
        } else if (element.equals(this.typeElement)) {
            this.pushedSoapBinding = this.pushSoapBinding(new MySoapBinding(), element, element);
        }
    }

    public static boolean sameStyle(SOAPBinding.Style style, SOAPStyle soapStyle) {
        return style.equals((Object)SOAPBinding.Style.DOCUMENT) && soapStyle.equals(SOAPStyle.DOCUMENT) || style.equals((Object)SOAPBinding.Style.RPC) && soapStyle.equals(SOAPStyle.RPC);
    }

    protected boolean pushSoapBinding(SOAPBinding soapBinding, Element bindingElement, TypeElement classElement) {
        boolean changed = false;
        if (!WebServiceVisitor.sameStyle(soapBinding.style(), this.soapStyle)) {
            changed = true;
            if (this.pushedSoapBinding) {
                this.builder.processError(WebserviceapMessages.WEBSERVICEAP_MIXED_BINDING_STYLE(classElement.getQualifiedName()), bindingElement);
            }
        }
        if (soapBinding.style().equals((Object)SOAPBinding.Style.RPC)) {
            this.soapStyle = SOAPStyle.RPC;
            this.wrapped = true;
            if (soapBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE)) {
                this.builder.processError(WebserviceapMessages.WEBSERVICEAP_RPC_LITERAL_MUST_NOT_BE_BARE(classElement.getQualifiedName()), bindingElement);
            }
        } else {
            this.soapStyle = SOAPStyle.DOCUMENT;
            if (this.wrapped != soapBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED)) {
                this.wrapped = soapBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED);
                changed = true;
            }
        }
        if (soapBinding.use().equals((Object)SOAPBinding.Use.ENCODED)) {
            String style = "rpc";
            if (soapBinding.style().equals((Object)SOAPBinding.Style.DOCUMENT)) {
                style = "document";
            }
            this.builder.processError(WebserviceapMessages.WEBSERVICE_ENCODED_NOT_SUPPORTED(classElement.getQualifiedName(), style), bindingElement);
        }
        if (changed || this.soapBindingStack.empty()) {
            this.soapBindingStack.push(soapBinding);
            this.pushedSoapBinding = true;
        }
        return changed;
    }

    protected SOAPBinding popSoapBinding() {
        if (this.pushedSoapBinding) {
            this.soapBindingStack.pop();
        }
        SOAPBinding soapBinding = null;
        if (!this.soapBindingStack.empty()) {
            soapBinding = this.soapBindingStack.peek();
            if (soapBinding.style().equals((Object)SOAPBinding.Style.RPC)) {
                this.soapStyle = SOAPStyle.RPC;
                this.wrapped = true;
            } else {
                this.soapStyle = SOAPStyle.DOCUMENT;
                this.wrapped = soapBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED);
            }
        }
        return soapBinding;
    }

    protected String getNamespace(PackageElement packageElement) {
        return RuntimeModeler.getNamespace(packageElement.getQualifiedName().toString());
    }

    protected boolean shouldProcessWebService(WebService webService, TypeElement element) {
        switch (element.getKind()) {
            case INTERFACE: {
                SOAPBinding soapBinding;
                this.hasWebMethods = false;
                if (webService == null) {
                    this.builder.processError(WebserviceapMessages.WEBSERVICEAP_ENDPOINTINTERFACE_HAS_NO_WEBSERVICE_ANNOTATION(element.getQualifiedName()), element);
                }
                if ((soapBinding = element.getAnnotation(SOAPBinding.class)) != null && soapBinding.style() == SOAPBinding.Style.RPC && soapBinding.parameterStyle() == SOAPBinding.ParameterStyle.BARE) {
                    this.builder.processError(WebserviceapMessages.WEBSERVICEAP_INVALID_SOAPBINDING_PARAMETERSTYLE(soapBinding, element), element);
                    return false;
                }
                return this.isLegalSei(element);
            }
            case CLASS: {
                if (webService == null) {
                    return false;
                }
                this.hasWebMethods = this.hasWebMethods(element);
                SOAPBinding soapBinding = element.getAnnotation(SOAPBinding.class);
                if (soapBinding != null && soapBinding.style() == SOAPBinding.Style.RPC && soapBinding.parameterStyle() == SOAPBinding.ParameterStyle.BARE) {
                    this.builder.processError(WebserviceapMessages.WEBSERVICEAP_INVALID_SOAPBINDING_PARAMETERSTYLE(soapBinding, element), element);
                    return false;
                }
                return this.isLegalImplementation(webService, element);
            }
        }
        throw new IllegalArgumentException("Class or Interface was expecting. But element: " + element);
    }

    protected abstract void processWebService(WebService var1, TypeElement var2);

    protected void postProcessWebService(WebService webService, TypeElement element) {
        this.processMethods(element);
        this.popSoapBinding();
    }

    protected boolean hasWebMethods(TypeElement element) {
        if (element.getQualifiedName().toString().equals(Object.class.getName())) {
            return false;
        }
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            WebMethod webMethod = method.getAnnotation(WebMethod.class);
            if (webMethod == null) continue;
            if (webMethod.exclude()) {
                if (webMethod.operationName().length() > 0) {
                    this.builder.processError(WebserviceapMessages.WEBSERVICEAP_INVALID_WEBMETHOD_ELEMENT_WITH_EXCLUDE("operationName", element.getQualifiedName(), method.toString()), method);
                }
                if (webMethod.action().length() <= 0) continue;
                this.builder.processError(WebserviceapMessages.WEBSERVICEAP_INVALID_WEBMETHOD_ELEMENT_WITH_EXCLUDE("action", element.getQualifiedName(), method.toString()), method);
                continue;
            }
            return true;
        }
        return false;
    }

    protected void processMethods(TypeElement element) {
        switch (element.getKind()) {
            case INTERFACE: {
                this.builder.log("ProcessedMethods Interface: " + element);
                this.hasWebMethods = false;
                for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
                    executableElement.accept(this, null);
                }
                for (TypeMirror typeMirror : element.getInterfaces()) {
                    this.processMethods((TypeElement)((DeclaredType)typeMirror).asElement());
                }
            }
            case CLASS: {
                TypeMirror superclass;
                this.builder.log("ProcessedMethods Class: " + element);
                this.hasWebMethods = this.hasWebMethods(element);
                if (element.getQualifiedName().toString().equals(Object.class.getName())) {
                    return;
                }
                if (element.getAnnotation(WebService.class) != null) {
                    for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
                        executableElement.accept(this, null);
                    }
                }
                if ((superclass = element.getSuperclass()).getKind().equals((Object)TypeKind.NONE)) break;
                this.processMethods((TypeElement)((DeclaredType)superclass).asElement());
            }
        }
    }

    private TypeElement getEndpointInterfaceElement(String endpointInterfaceName, TypeElement element) {
        TypeElement intTypeElement = null;
        for (TypeMirror typeMirror : element.getInterfaces()) {
            if (!endpointInterfaceName.equals(((Object)typeMirror).toString())) continue;
            intTypeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            this.seiContext = this.context.getSeiContext(intTypeElement.getQualifiedName());
            assert (this.seiContext != null);
            this.seiContext.setImplementsSei(true);
            break;
        }
        if (intTypeElement == null) {
            intTypeElement = this.builder.getProcessingEnvironment().getElementUtils().getTypeElement(endpointInterfaceName);
        }
        if (intTypeElement == null) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_ENDPOINTINTERFACE_CLASS_NOT_FOUND(endpointInterfaceName));
        }
        return intTypeElement;
    }

    private void inspectEndpointInterface(String endpointInterfaceName, TypeElement d) {
        TypeElement intTypeElement = this.getEndpointInterfaceElement(endpointInterfaceName, d);
        if (intTypeElement != null) {
            intTypeElement.accept(this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitExecutable(ExecutableElement method, Object o) {
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return null;
        }
        if (this.processedMethod(method)) {
            return null;
        }
        WebMethod webMethod = method.getAnnotation(WebMethod.class);
        if (webMethod != null && webMethod.exclude()) {
            return null;
        }
        SOAPBinding soapBinding = method.getAnnotation(SOAPBinding.class);
        if (soapBinding == null && !((Object)method.getEnclosingElement()).equals(this.typeElement) && method.getEnclosingElement().getKind().equals((Object)ElementKind.CLASS)) {
            soapBinding = method.getEnclosingElement().getAnnotation(SOAPBinding.class);
            if (soapBinding != null) {
                this.builder.log("using " + method.getEnclosingElement() + "'s SOAPBinding.");
            } else {
                soapBinding = new MySoapBinding();
            }
        }
        boolean newBinding = false;
        if (soapBinding != null) {
            newBinding = this.pushSoapBinding(soapBinding, method, this.typeElement);
        }
        try {
            if (this.shouldProcessMethod(method, webMethod)) {
                this.processMethod(method, webMethod);
            }
        }
        finally {
            if (newBinding) {
                this.popSoapBinding();
            }
        }
        return null;
    }

    protected boolean processedMethod(ExecutableElement method) {
        String id = method.toString();
        if (this.processedMethods.contains(id)) {
            return true;
        }
        this.processedMethods.add(id);
        return false;
    }

    protected boolean shouldProcessMethod(ExecutableElement method, WebMethod webMethod) {
        boolean staticFinal;
        this.builder.log("should process method: " + method.getSimpleName() + " hasWebMethods: " + this.hasWebMethods + " ");
        Set<Modifier> modifiers = method.getModifiers();
        boolean bl = staticFinal = modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.FINAL);
        if (staticFinal) {
            if (webMethod != null) {
                this.builder.processError(WebserviceapMessages.WEBSERVICEAP_WEBSERVICE_METHOD_IS_STATIC_OR_FINAL(method.getEnclosingElement(), method), method);
            }
            return false;
        }
        boolean result = this.endpointReferencesInterface || ((Object)method.getEnclosingElement()).equals(this.typeElement) || method.getEnclosingElement().getAnnotation(WebService.class) != null;
        this.builder.log("endpointReferencesInterface: " + this.endpointReferencesInterface);
        this.builder.log("declaring class has WebService: " + (method.getEnclosingElement().getAnnotation(WebService.class) != null));
        this.builder.log("returning: " + result);
        return result;
    }

    protected abstract void processMethod(ExecutableElement var1, WebMethod var2);

    protected boolean isLegalImplementation(WebService webService, TypeElement classElement) {
        TypeElement interfaceElement;
        boolean isStateful = this.isStateful(classElement);
        Set<Modifier> modifiers = classElement.getModifiers();
        if (!modifiers.contains((Object)Modifier.PUBLIC)) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_WEBSERVICE_CLASS_NOT_PUBLIC(classElement.getQualifiedName()), classElement);
            return false;
        }
        if (modifiers.contains((Object)Modifier.FINAL) && !isStateful) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_WEBSERVICE_CLASS_IS_FINAL(classElement.getQualifiedName()), classElement);
            return false;
        }
        if (modifiers.contains((Object)Modifier.ABSTRACT) && !isStateful) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_WEBSERVICE_CLASS_IS_ABSTRACT(classElement.getQualifiedName()), classElement);
            return false;
        }
        boolean hasDefaultConstructor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(classElement.getEnclosedElements())) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || constructor.getParameters().size() != 0) continue;
            hasDefaultConstructor = true;
            break;
        }
        if (!hasDefaultConstructor && !isStateful) {
            if (classElement.getEnclosingElement() != null && !modifiers.contains((Object)Modifier.STATIC)) {
                this.builder.processError(WebserviceapMessages.WEBSERVICEAP_WEBSERVICE_CLASS_IS_INNERCLASS_NOT_STATIC(classElement.getQualifiedName()), classElement);
                return false;
            }
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_WEBSERVICE_NO_DEFAULT_CONSTRUCTOR(classElement.getQualifiedName()), classElement);
            return false;
        }
        return !(webService.endpointInterface().isEmpty() ? !this.methodsAreLegal(classElement) : !this.classImplementsSei(classElement, interfaceElement = this.getEndpointInterfaceElement(webService.endpointInterface(), classElement)));
    }

    private boolean isStateful(TypeElement classElement) {
        try {
            return classElement.getAnnotation(Class.forName("com.sun.xml.ws.developer.Stateful")) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    protected boolean classImplementsSei(TypeElement classElement, TypeElement interfaceElement) {
        for (TypeMirror typeMirror : classElement.getInterfaces()) {
            if (!((Object)((DeclaredType)typeMirror).asElement()).equals(interfaceElement)) continue;
            return true;
        }
        List<ExecutableElement> classMethods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        for (ExecutableElement interfaceMethod : ElementFilter.methodsIn(interfaceElement.getEnclosedElements())) {
            boolean bl = false;
            for (ExecutableElement classMethod : classMethods) {
                if (!this.sameMethod(interfaceMethod, classMethod)) continue;
                bl = true;
                classMethods.remove(classMethod);
                break;
            }
            if (bl) continue;
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_METHOD_NOT_IMPLEMENTED(interfaceElement.getSimpleName(), classElement.getSimpleName(), interfaceMethod), interfaceMethod);
            return false;
        }
        return true;
    }

    protected boolean sameMethod(ExecutableElement method1, ExecutableElement method2) {
        if (!((Object)method1.getSimpleName()).equals(method2.getSimpleName())) {
            return false;
        }
        if (!((Object)method1.getReturnType()).equals(method2.getReturnType())) {
            return false;
        }
        List<? extends VariableElement> parameters1 = method1.getParameters();
        List<? extends VariableElement> parameters2 = method2.getParameters();
        if (parameters1.size() != parameters2.size()) {
            return false;
        }
        for (int i = 0; i < parameters1.size(); ++i) {
            if (this.builder.getProcessingEnvironment().getTypeUtils().isSameType(parameters1.get(i).asType(), parameters2.get(i).asType())) continue;
            return false;
        }
        return true;
    }

    protected boolean isLegalSei(TypeElement interfaceElement) {
        for (VariableElement field : ElementFilter.fieldsIn(interfaceElement.getEnclosedElements())) {
            if (field.getConstantValue() == null) continue;
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_SEI_CANNOT_CONTAIN_CONSTANT_VALUES(interfaceElement.getQualifiedName(), field.getSimpleName()));
            return false;
        }
        return this.methodsAreLegal(interfaceElement);
    }

    protected boolean methodsAreLegal(TypeElement element) {
        switch (element.getKind()) {
            case INTERFACE: {
                this.hasWebMethods = false;
                for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
                    if (this.isLegalMethod(executableElement, element)) continue;
                    return false;
                }
                for (TypeMirror typeMirror : element.getInterfaces()) {
                    if (this.methodsAreLegal((TypeElement)((DeclaredType)typeMirror).asElement())) continue;
                    return false;
                }
                return true;
            }
            case CLASS: {
                this.hasWebMethods = this.hasWebMethods(element);
                for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
                    if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || this.isLegalMethod(executableElement, element)) continue;
                    return false;
                }
                DeclaredType superClass = (DeclaredType)element.getSuperclass();
                TypeElement typeElement = (TypeElement)superClass.asElement();
                return typeElement.getQualifiedName().toString().equals(Object.class.getName()) || this.methodsAreLegal(typeElement);
            }
        }
        throw new IllegalArgumentException("Class or interface was expecting. But element: " + element);
    }

    protected boolean isLegalMethod(ExecutableElement method, TypeElement typeElement) {
        boolean isOneWay;
        WebMethod webMethod = method.getAnnotation(WebMethod.class);
        if (typeElement.getKind().equals((Object)ElementKind.INTERFACE) && webMethod != null && webMethod.exclude()) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_INVALID_SEI_ANNOTATION_ELEMENT_EXCLUDE("exclude=true", typeElement.getQualifiedName(), method.toString()), method);
        }
        if (this.hasWebMethods && webMethod == null) {
            return true;
        }
        if (webMethod != null && webMethod.exclude()) {
            return true;
        }
        TypeMirror returnType = method.getReturnType();
        if (!this.isLegalType(returnType)) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_METHOD_RETURN_TYPE_CANNOT_IMPLEMENT_REMOTE(typeElement.getQualifiedName(), method.getSimpleName(), returnType), method);
        }
        boolean bl = isOneWay = method.getAnnotation(Oneway.class) != null;
        if (isOneWay && !this.isValidOneWayMethod(method, typeElement)) {
            return false;
        }
        SOAPBinding soapBinding = method.getAnnotation(SOAPBinding.class);
        if (soapBinding != null && soapBinding.style().equals((Object)SOAPBinding.Style.RPC)) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_RPC_SOAPBINDING_NOT_ALLOWED_ON_METHOD(typeElement.getQualifiedName(), method.toString()), method);
        }
        int paramIndex = 0;
        for (VariableElement variableElement : method.getParameters()) {
            if (this.isLegalParameter(variableElement, method, typeElement, paramIndex++)) continue;
            return false;
        }
        if (!this.isDocLitWrapped() && this.soapStyle.equals(SOAPStyle.DOCUMENT)) {
            VariableElement outParam = this.getOutParameter(method);
            int n = this.getModeParameterCount(method, WebParam.Mode.IN);
            int outParams = this.getModeParameterCount(method, WebParam.Mode.OUT);
            if (n != 1) {
                this.builder.processError(WebserviceapMessages.WEBSERVICEAP_DOC_BARE_AND_NO_ONE_IN(typeElement.getQualifiedName(), method.toString()), method);
            }
            if (returnType.accept(NO_TYPE_VISITOR, null).booleanValue()) {
                if (outParam == null && !isOneWay) {
                    this.builder.processError(WebserviceapMessages.WEBSERVICEAP_DOC_BARE_NO_OUT(typeElement.getQualifiedName(), method.toString()), method);
                }
                if (outParams != 1 && !isOneWay && outParams != 0) {
                    this.builder.processError(WebserviceapMessages.WEBSERVICEAP_DOC_BARE_NO_RETURN_AND_NO_OUT(typeElement.getQualifiedName(), method.toString()), method);
                }
            } else if (outParams > 0) {
                this.builder.processError(WebserviceapMessages.WEBSERVICEAP_DOC_BARE_RETURN_AND_OUT(typeElement.getQualifiedName(), method.toString()), outParam);
            }
        }
        return true;
    }

    protected boolean isLegalParameter(VariableElement param, ExecutableElement method, TypeElement typeElement, int paramIndex) {
        if (!this.isLegalType(param.asType())) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_METHOD_PARAMETER_TYPES_CANNOT_IMPLEMENT_REMOTE(typeElement.getQualifiedName(), method.getSimpleName(), param.getSimpleName(), ((Object)param.asType()).toString()), param);
            return false;
        }
        TypeMirror holderType = this.builder.getHolderValueType(param.asType());
        WebParam webParam = param.getAnnotation(WebParam.class);
        WebParam.Mode mode = null;
        if (webParam != null) {
            mode = webParam.mode();
        }
        if (holderType != null) {
            if (mode != null && mode == WebParam.Mode.IN) {
                this.builder.processError(WebserviceapMessages.WEBSERVICEAP_HOLDER_PARAMETERS_MUST_NOT_BE_IN_ONLY(typeElement.getQualifiedName(), method.toString(), paramIndex), param);
            }
        } else if (mode != null && mode != WebParam.Mode.IN) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_NON_IN_PARAMETERS_MUST_BE_HOLDER(typeElement.getQualifiedName(), method.toString(), paramIndex), param);
        }
        return true;
    }

    protected boolean isDocLitWrapped() {
        return this.soapStyle.equals(SOAPStyle.DOCUMENT) && this.wrapped;
    }

    protected boolean isValidOneWayMethod(ExecutableElement method, TypeElement typeElement) {
        int inCnt;
        VariableElement outParam;
        boolean valid = true;
        if (!method.getReturnType().accept(NO_TYPE_VISITOR, null).booleanValue()) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_ONEWAY_OPERATION_CANNOT_HAVE_RETURN_TYPE(typeElement.getQualifiedName(), method.toString()), method);
            valid = false;
        }
        if ((outParam = this.getOutParameter(method)) != null) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_ONEWAY_AND_OUT(typeElement.getQualifiedName(), method.toString()), outParam);
            valid = false;
        }
        if (!this.isDocLitWrapped() && this.soapStyle.equals(SOAPStyle.DOCUMENT) && (inCnt = this.getModeParameterCount(method, WebParam.Mode.IN)) != 1) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_ONEWAY_AND_NOT_ONE_IN(typeElement.getQualifiedName(), method.toString()), method);
            valid = false;
        }
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            TypeElement thrownElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            if (!this.builder.isServiceException(typeMirror)) continue;
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_ONEWAY_OPERATION_CANNOT_DECLARE_EXCEPTIONS(typeElement.getQualifiedName(), method.toString(), thrownElement.getQualifiedName()), method);
            valid = false;
        }
        return valid;
    }

    protected int getModeParameterCount(ExecutableElement method, WebParam.Mode mode) {
        int cnt = 0;
        for (VariableElement variableElement : method.getParameters()) {
            WebParam webParam = variableElement.getAnnotation(WebParam.class);
            if (webParam != null) {
                if (webParam.header() || !this.isEquivalentModes(mode, webParam.mode())) continue;
                ++cnt;
                continue;
            }
            if (!this.isEquivalentModes(mode, WebParam.Mode.IN)) continue;
            ++cnt;
        }
        return cnt;
    }

    protected boolean isEquivalentModes(WebParam.Mode mode1, WebParam.Mode mode2) {
        if (mode1.equals((Object)mode2)) {
            return true;
        }
        assert (mode1 == WebParam.Mode.IN || mode1 == WebParam.Mode.OUT);
        return mode1 == WebParam.Mode.IN && mode2 != WebParam.Mode.OUT || mode1 == WebParam.Mode.OUT && mode2 != WebParam.Mode.IN;
    }

    protected boolean isHolder(VariableElement param) {
        return this.builder.getHolderValueType(param.asType()) != null;
    }

    protected boolean isLegalType(TypeMirror type) {
        if (type == null || !type.getKind().equals((Object)TypeKind.DECLARED)) {
            return true;
        }
        TypeElement typeElement = (TypeElement)((DeclaredType)type).asElement();
        if (typeElement == null) {
            this.builder.processError(WebserviceapMessages.WEBSERVICEAP_COULD_NOT_FIND_TYPEDECL(((Object)type).toString(), this.context.getRound()));
        }
        return !this.builder.isRemote(typeElement);
    }

    protected VariableElement getOutParameter(ExecutableElement method) {
        for (VariableElement variableElement : method.getParameters()) {
            WebParam webParam = variableElement.getAnnotation(WebParam.class);
            if (webParam == null || webParam.mode() == WebParam.Mode.IN) continue;
            return variableElement;
        }
        return null;
    }

    protected static class MySoapBinding
    implements SOAPBinding {
        protected MySoapBinding() {
        }

        public SOAPBinding.Style style() {
            return SOAPBinding.Style.DOCUMENT;
        }

        public SOAPBinding.Use use() {
            return SOAPBinding.Use.LITERAL;
        }

        public SOAPBinding.ParameterStyle parameterStyle() {
            return SOAPBinding.ParameterStyle.WRAPPED;
        }

        public Class<? extends Annotation> annotationType() {
            return SOAPBinding.class;
        }
    }

    private static final class NoTypeVisitor
    extends SimpleTypeVisitor6<Boolean, Void> {
        private NoTypeVisitor() {
        }

        @Override
        public Boolean visitNoType(NoType t, Void o) {
            return true;
        }

        @Override
        protected Boolean defaultAction(TypeMirror e, Void aVoid) {
            return false;
        }
    }
}

