/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.types.api.Type;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class Utils {
    public static final List<JsTokenId> LOOK_FOR_IMPORT_EXPORT_TOKENS = Collections.unmodifiableList(Arrays.asList(JsTokenId.KEYWORD_IMPORT, JsTokenId.KEYWORD_EXPORT, JsTokenId.OPERATOR_SEMICOLON));
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    private static final int REFRESH_INDEX_SLIDING = 2500;
    private static final Set<Request> todo = new HashSet<Request>();
    private static final RequestProcessor REFRESH_INDEX_FIRER = new RequestProcessor(Utils.class);
    private static final RequestProcessor.Task REFRESH_INDEX_TASK = REFRESH_INDEX_FIRER.create(() -> {
        Set<Request> set = todo;
        synchronized (set) {
            Iterator<Request> it = todo.iterator();
            while (it.hasNext()) {
                Request r = it.next();
                it.remove();
                if (r.root != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Schedule reindex for generic root: {0}", FileUtil.getFileDisplayName((FileObject)r.root));
                    }
                    IndexingManager.getDefault().refreshAllIndices("TLIndexer");
                    continue;
                }
                LOG.log(Level.FINE, "Schedule global reindex.");
                IndexingManager.getDefault().refreshAllIndices("TLIndexer");
            }
        }
    });

    public static Collection<String> getDisplayNames(Collection<? extends Type> types) {
        ArrayList<String> displayNames = new ArrayList<String>(types.size());
        for (Type type : types) {
            String displayName = ModelUtils.getDisplayName((Type)type);
            if (displayName == null || displayName.isEmpty() || displayNames.contains(displayName)) continue;
            displayNames.add(displayName);
        }
        Collections.sort(displayNames);
        return displayNames;
    }

    public static Collection<String> getDisplayNamesFromStrings(Collection<String> fqns) {
        ArrayList<String> displayNames = new ArrayList<String>(fqns.size());
        for (String fqn : fqns) {
            String displayName = ModelUtils.getDisplayName((String)fqn);
            if (displayName.length() == 0) continue;
            displayNames.add(displayName);
        }
        return displayNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshTaskListIndex(@NullAllowed FileObject artifact) {
        boolean shouldAdd;
        Optional<Collection> roots;
        Optional<FileObject> maybeFile = Optional.ofNullable(artifact);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Refresh task list index with artefact: {0}", (Object)maybeFile.map(f -> FileUtil.getFileDisplayName((FileObject)f)).orElse(null));
        }
        Collection<Request> toAdd = (roots = maybeFile.map(fo -> FileOwnerQuery.getOwner((FileObject)fo)).map(p -> Arrays.stream(ProjectUtils.getSources((Project)p).getSourceGroups("generic")).map(sg -> sg.getRootFolder()).filter(root -> root != null).map(root -> Request.forRoot(root)).collect(Collectors.toList()))).isPresent() ? roots.get() : Collections.singleton(Request.all());
        Set<Request> set = todo;
        synchronized (set) {
            boolean bl = shouldAdd = !todo.contains(Request.all());
            if (shouldAdd) {
                todo.addAll(toAdd);
            }
        }
        if (LOG.isLoggable(Level.FINE) && shouldAdd) {
            LOG.log(Level.FINE, "Added requests: {0}", toAdd);
        }
        REFRESH_INDEX_TASK.schedule(2500);
    }

    private static final class Request {
        private static final Request ALL = new Request(null);
        final FileObject root;

        private Request(@NullAllowed FileObject root) {
            this.root = root;
        }

        public int hashCode() {
            return this.root == null ? 0 : this.root.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Request)) {
                return false;
            }
            Request other = (Request)obj;
            return this.root == null ? other.root == null : this.root.equals(other.root);
        }

        public String toString() {
            return this.root == null ? "<all>" : FileUtil.getFileDisplayName((FileObject)this.root);
        }

        @NonNull
        static Request all() {
            return ALL;
        }

        @NonNull
        static Request forRoot(@NonNull FileObject root) {
            assert (root != null);
            return new Request(root);
        }
    }
}

