/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ActiveProfilesResolver;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.MetaAnnotationUtils;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

abstract class ContextLoaderUtils {
    static final String GENERATED_CONTEXT_HIERARCHY_LEVEL_PREFIX = "ContextHierarchyLevel#";
    private static final Log logger = LogFactory.getLog(ContextLoaderUtils.class);
    private static final String DEFAULT_CONTEXT_LOADER_CLASS_NAME = "org.springframework.test.context.support.DelegatingSmartContextLoader";
    private static final String DEFAULT_WEB_CONTEXT_LOADER_CLASS_NAME = "org.springframework.test.context.web.WebDelegatingSmartContextLoader";
    private static final String WEB_APP_CONFIGURATION_CLASS_NAME = "org.springframework.test.context.web.WebAppConfiguration";
    private static final String WEB_MERGED_CONTEXT_CONFIGURATION_CLASS_NAME = "org.springframework.test.context.web.WebMergedContextConfiguration";

    private ContextLoaderUtils() {
    }

    static ContextLoader resolveContextLoader(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList, String defaultContextLoaderClassName) {
        Assert.notNull(testClass, (String)"Class must not be null");
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be empty");
        if (!StringUtils.hasText((String)defaultContextLoaderClassName)) {
            Class<? extends Annotation> webAppConfigClass = ContextLoaderUtils.loadWebAppConfigurationClass();
            defaultContextLoaderClassName = webAppConfigClass != null && AnnotationUtils.findAnnotation(testClass, webAppConfigClass) != null ? DEFAULT_WEB_CONTEXT_LOADER_CLASS_NAME : DEFAULT_CONTEXT_LOADER_CLASS_NAME;
        }
        Class<? extends ContextLoader> contextLoaderClass = ContextLoaderUtils.resolveContextLoaderClass(testClass, configAttributesList, defaultContextLoaderClassName);
        return (ContextLoader)BeanUtils.instantiateClass(contextLoaderClass, ContextLoader.class);
    }

    static Class<? extends ContextLoader> resolveContextLoaderClass(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList, String defaultContextLoaderClassName) {
        Assert.notNull(testClass, (String)"Class must not be null");
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be empty");
        Assert.hasText((String)defaultContextLoaderClassName, (String)"Default ContextLoader class name must not be null or empty");
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            Class<? extends ContextLoader> contextLoaderClass;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Processing ContextLoader for context configuration attributes %s", configAttributes));
            }
            if (ContextLoader.class.equals(contextLoaderClass = configAttributes.getContextLoaderClass())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Found explicit ContextLoader class [%s] for context configuration attributes %s", contextLoaderClass.getName(), configAttributes));
            }
            return contextLoaderClass;
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Using default ContextLoader class [%s] for test class [%s]", defaultContextLoaderClassName, testClass.getName()));
            }
            return ClassUtils.forName((String)defaultContextLoaderClassName, (ClassLoader)ContextLoaderUtils.class.getClassLoader());
        }
        catch (Throwable t) {
            throw new IllegalStateException("Could not load default ContextLoader class [" + defaultContextLoaderClassName + "]. Specify @ContextConfiguration's 'loader' " + "attribute or make the default loader class available.", t);
        }
    }

    private static void convertContextConfigToConfigAttributesAndAddToList(ContextConfiguration contextConfiguration, Class<?> declaringClass, List<ContextConfigurationAttributes> attributesList) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("Retrieved @ContextConfiguration [%s] for declaring class [%s].", contextConfiguration, declaringClass.getName()));
        }
        ContextConfigurationAttributes attributes = new ContextConfigurationAttributes(declaringClass, contextConfiguration);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Resolved context configuration attributes: " + attributes));
        }
        attributesList.add(attributes);
    }

    private static void convertAnnotationAttributesToConfigAttributesAndAddToList(AnnotationAttributes annAttrs, Class<?> declaringClass, List<ContextConfigurationAttributes> attributesList) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("Retrieved @ContextConfiguration attributes [%s] for declaring class [%s].", annAttrs, declaringClass.getName()));
        }
        ContextConfigurationAttributes attributes = new ContextConfigurationAttributes(declaringClass, annAttrs);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Resolved context configuration attributes: " + attributes));
        }
        attributesList.add(attributes);
    }

    static List<List<ContextConfigurationAttributes>> resolveContextHierarchyAttributes(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        Assert.state((AnnotationUtils.findAnnotation(testClass, ContextHierarchy.class) != null ? 1 : 0) != 0, (String)"@ContextHierarchy must be present");
        Class<ContextConfiguration> contextConfigType = ContextConfiguration.class;
        Class<ContextHierarchy> contextHierarchyType = ContextHierarchy.class;
        ArrayList<List<ContextConfigurationAttributes>> hierarchyAttributes = new ArrayList<List<ContextConfigurationAttributes>>();
        MetaAnnotationUtils.UntypedAnnotationDescriptor descriptor = MetaAnnotationUtils.findAnnotationDescriptorForTypes(testClass, contextConfigType, contextHierarchyType);
        Assert.notNull((Object)descriptor, (String)String.format("Could not find an 'annotation declaring class' for annotation type [%s] or [%s] and test class [%s]", contextConfigType.getName(), contextHierarchyType.getName(), testClass.getName()));
        while (descriptor != null) {
            Class<?> rootDeclaringClass = descriptor.getRootDeclaringClass();
            Class<?> declaringClass = descriptor.getDeclaringClass();
            boolean contextConfigDeclaredLocally = AnnotationUtils.isAnnotationDeclaredLocally(contextConfigType, declaringClass);
            boolean contextHierarchyDeclaredLocally = AnnotationUtils.isAnnotationDeclaredLocally(contextHierarchyType, declaringClass);
            if (contextConfigDeclaredLocally && contextHierarchyDeclaredLocally) {
                String msg = String.format("Class [%s] has been configured with both @ContextConfiguration and @ContextHierarchy. Only one of these annotations may be declared on a test class or custom stereotype annotation.", declaringClass.getName());
                logger.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            ArrayList<ContextConfigurationAttributes> configAttributesList = new ArrayList<ContextConfigurationAttributes>();
            if (contextConfigDeclaredLocally) {
                ContextLoaderUtils.convertAnnotationAttributesToConfigAttributesAndAddToList(descriptor.getAnnotationAttributes(), declaringClass, configAttributesList);
            } else if (contextHierarchyDeclaredLocally) {
                ContextHierarchy contextHierarchy = (ContextHierarchy)AnnotationUtils.getAnnotation(declaringClass, contextHierarchyType);
                for (ContextConfiguration contextConfiguration : contextHierarchy.value()) {
                    ContextLoaderUtils.convertContextConfigToConfigAttributesAndAddToList(contextConfiguration, declaringClass, configAttributesList);
                }
            } else {
                String msg = String.format("Test class [%s] has been configured with neither @ContextConfiguration nor @ContextHierarchy as a class-level annotation.", rootDeclaringClass.getName());
                logger.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            hierarchyAttributes.add(0, configAttributesList);
            descriptor = MetaAnnotationUtils.findAnnotationDescriptorForTypes(rootDeclaringClass.getSuperclass(), contextConfigType, contextHierarchyType);
        }
        return hierarchyAttributes;
    }

    static Map<String, List<ContextConfigurationAttributes>> buildContextHierarchyMap(Class<?> testClass) {
        LinkedHashMap<String, List<ContextConfigurationAttributes>> map = new LinkedHashMap<String, List<ContextConfigurationAttributes>>();
        int hierarchyLevel = 1;
        for (List<ContextConfigurationAttributes> configAttributesList : ContextLoaderUtils.resolveContextHierarchyAttributes(testClass)) {
            for (ContextConfigurationAttributes configAttributes : configAttributesList) {
                String name = configAttributes.getName();
                if (!StringUtils.hasText((String)name)) {
                    name = GENERATED_CONTEXT_HIERARCHY_LEVEL_PREFIX + hierarchyLevel;
                }
                if (!map.containsKey(name)) {
                    ++hierarchyLevel;
                    map.put(name, new ArrayList());
                }
                ((List)map.get(name)).add(configAttributes);
            }
        }
        HashSet set = new HashSet(map.values());
        if (set.size() != map.size()) {
            String msg = String.format("The @ContextConfiguration elements configured via @ContextHierarchy in test class [%s] and its superclasses must define unique contexts per hierarchy level.", testClass.getName());
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        return map;
    }

    static List<ContextConfigurationAttributes> resolveContextConfigurationAttributes(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        ArrayList<ContextConfigurationAttributes> attributesList = new ArrayList<ContextConfigurationAttributes>();
        Class<ContextConfiguration> annotationType = ContextConfiguration.class;
        MetaAnnotationUtils.AnnotationDescriptor<ContextConfiguration> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        Assert.notNull(descriptor, (String)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        while (descriptor != null) {
            ContextLoaderUtils.convertAnnotationAttributesToConfigAttributesAndAddToList(descriptor.getAnnotationAttributes(), descriptor.getDeclaringClass(), attributesList);
            descriptor = MetaAnnotationUtils.findAnnotationDescriptor(descriptor.getRootDeclaringClass().getSuperclass(), annotationType);
        }
        return attributesList;
    }

    static Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> resolveInitializerClasses(List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be empty");
        HashSet<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses = new HashSet<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>>();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Processing context initializers for context configuration attributes %s", configAttributes));
            }
            initializerClasses.addAll(Arrays.asList(configAttributes.getInitializers()));
            if (configAttributes.isInheritInitializers()) continue;
            break;
        }
        return initializerClasses;
    }

    static String[] resolveActiveProfiles(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        Class<ActiveProfiles> annotationType = ActiveProfiles.class;
        MetaAnnotationUtils.AnnotationDescriptor<ActiveProfiles> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        if (descriptor == null && logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        }
        HashSet<String> activeProfiles = new HashSet<String>();
        while (descriptor != null) {
            boolean valueDeclared;
            Class<?> declaringClass = descriptor.getDeclaringClass();
            AnnotationAttributes annAttrs = descriptor.getAnnotationAttributes();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @ActiveProfiles attributes [%s] for declaring class [%s].", annAttrs, declaringClass.getName()));
            }
            ContextLoaderUtils.validateActiveProfilesConfiguration(declaringClass, annAttrs);
            Object[] profiles = annAttrs.getStringArray("profiles");
            Object[] valueProfiles = annAttrs.getStringArray("value");
            Class resolverClass = annAttrs.getClass("resolver");
            boolean resolverDeclared = !ActiveProfilesResolver.class.equals((Object)resolverClass);
            boolean bl = valueDeclared = !ObjectUtils.isEmpty((Object[])valueProfiles);
            if (resolverDeclared) {
                ActiveProfilesResolver resolver = null;
                try {
                    resolver = (ActiveProfilesResolver)BeanUtils.instantiateClass((Class)resolverClass, ActiveProfilesResolver.class);
                }
                catch (Exception e) {
                    String msg = String.format("Could not instantiate ActiveProfilesResolver of type [%s] for test class [%s].", resolverClass.getName(), declaringClass.getName());
                    logger.error((Object)msg);
                    throw new IllegalStateException(msg, e);
                }
                profiles = resolver.resolve(declaringClass);
                if (profiles == null) {
                    String msg = String.format("ActiveProfilesResolver [%s] returned a null array of bean definition profiles.", resolverClass.getName());
                    logger.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
            } else if (valueDeclared) {
                profiles = valueProfiles;
            }
            for (String string : profiles) {
                if (!StringUtils.hasText((String)string)) continue;
                activeProfiles.add(string.trim());
            }
            descriptor = annAttrs.getBoolean("inheritProfiles") ? MetaAnnotationUtils.findAnnotationDescriptor(descriptor.getRootDeclaringClass().getSuperclass(), annotationType) : null;
        }
        return StringUtils.toStringArray(activeProfiles);
    }

    private static void validateActiveProfilesConfiguration(Class<?> declaringClass, AnnotationAttributes annAttrs) {
        Object[] valueProfiles = annAttrs.getStringArray("value");
        Object[] profiles = annAttrs.getStringArray("profiles");
        Class resolverClass = annAttrs.getClass("resolver");
        boolean valueDeclared = !ObjectUtils.isEmpty((Object[])valueProfiles);
        boolean profilesDeclared = !ObjectUtils.isEmpty((Object[])profiles);
        boolean resolverDeclared = !ActiveProfilesResolver.class.equals((Object)resolverClass);
        String msg = null;
        if (valueDeclared && profilesDeclared) {
            msg = String.format("Test class [%s] has been configured with @ActiveProfiles' 'value' [%s] and 'profiles' [%s] attributes. Only one declaration of active bean definition profiles is permitted per @ActiveProfiles annotation.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])valueProfiles), ObjectUtils.nullSafeToString((Object[])profiles));
        } else if (valueDeclared && resolverDeclared) {
            msg = String.format("Test class [%s] has been configured with @ActiveProfiles' 'value' [%s] and 'resolver' [%s] attributes. Only one source of active bean definition profiles is permitted per @ActiveProfiles annotation, either declaritively or programmatically.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])valueProfiles), resolverClass.getName());
        } else if (profilesDeclared && resolverDeclared) {
            msg = String.format("Test class [%s] has been configured with @ActiveProfiles' 'profiles' [%s] and 'resolver' [%s] attributes. Only one source of active bean definition profiles is permitted per @ActiveProfiles annotation, either declaritively or programmatically.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])profiles), resolverClass.getName());
        }
        if (msg != null) {
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
    }

    static MergedContextConfiguration buildMergedContextConfiguration(Class<?> testClass, String defaultContextLoaderClassName, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        if (MetaAnnotationUtils.findAnnotationDescriptorForTypes(testClass, ContextConfiguration.class, ContextHierarchy.class) == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Neither @ContextConfiguration nor @ContextHierarchy found for test class [%s]", testClass.getName()));
            }
            return new MergedContextConfiguration(testClass, null, null, null, null);
        }
        if (AnnotationUtils.findAnnotation(testClass, ContextHierarchy.class) != null) {
            Map<String, List<ContextConfigurationAttributes>> hierarchyMap = ContextLoaderUtils.buildContextHierarchyMap(testClass);
            MergedContextConfiguration parentConfig = null;
            MergedContextConfiguration mergedConfig = null;
            for (List<ContextConfigurationAttributes> list : hierarchyMap.values()) {
                ArrayList<ContextConfigurationAttributes> reversedList = new ArrayList<ContextConfigurationAttributes>(list);
                Collections.reverse(reversedList);
                Assert.notEmpty(reversedList, (String)"ContextConfigurationAttributes list must not be empty");
                Class<?> declaringClass = ((ContextConfigurationAttributes)reversedList.get(0)).getDeclaringClass();
                parentConfig = mergedConfig = ContextLoaderUtils.buildMergedContextConfiguration(declaringClass, reversedList, defaultContextLoaderClassName, parentConfig, cacheAwareContextLoaderDelegate);
            }
            return mergedConfig;
        }
        return ContextLoaderUtils.buildMergedContextConfiguration(testClass, ContextLoaderUtils.resolveContextConfigurationAttributes(testClass), defaultContextLoaderClassName, null, cacheAwareContextLoaderDelegate);
    }

    private static MergedContextConfiguration buildMergedContextConfiguration(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList, String defaultContextLoaderClassName, MergedContextConfiguration parentConfig, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        String[] activeProfiles;
        Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses;
        Class[] classes;
        String[] locations;
        MergedContextConfiguration mergedConfig;
        ContextLoader contextLoader = ContextLoaderUtils.resolveContextLoader(testClass, configAttributesList, defaultContextLoaderClassName);
        ArrayList<String> locationsList = new ArrayList<String>();
        ArrayList classesList = new ArrayList();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Processing locations and classes for context configuration attributes %s", configAttributes));
            }
            if (contextLoader instanceof SmartContextLoader) {
                SmartContextLoader smartContextLoader = (SmartContextLoader)contextLoader;
                smartContextLoader.processContextConfiguration(configAttributes);
                locationsList.addAll(0, Arrays.asList(configAttributes.getLocations()));
                classesList.addAll(0, Arrays.asList(configAttributes.getClasses()));
            } else {
                String[] processedLocations = contextLoader.processLocations(configAttributes.getDeclaringClass(), configAttributes.getLocations());
                locationsList.addAll(0, Arrays.asList(processedLocations));
            }
            if (configAttributes.isInheritLocations()) continue;
            break;
        }
        if ((mergedConfig = ContextLoaderUtils.buildWebMergedContextConfiguration(testClass, locations = StringUtils.toStringArray(locationsList), classes = ClassUtils.toClassArray(classesList), initializerClasses = ContextLoaderUtils.resolveInitializerClasses(configAttributesList), activeProfiles = ContextLoaderUtils.resolveActiveProfiles(testClass), contextLoader, cacheAwareContextLoaderDelegate, parentConfig)) == null) {
            mergedConfig = new MergedContextConfiguration(testClass, locations, classes, initializerClasses, activeProfiles, contextLoader, cacheAwareContextLoaderDelegate, parentConfig);
        }
        return mergedConfig;
    }

    private static Class<? extends Annotation> loadWebAppConfigurationClass() {
        Class webAppConfigClass;
        block2: {
            webAppConfigClass = null;
            try {
                webAppConfigClass = ClassUtils.forName((String)WEB_APP_CONFIGURATION_CLASS_NAME, (ClassLoader)ContextLoaderUtils.class.getClassLoader());
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)"Could not load @WebAppConfiguration class [org.springframework.test.context.web.WebAppConfiguration].", t);
            }
        }
        return webAppConfigClass;
    }

    private static MergedContextConfiguration buildWebMergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses, String[] activeProfiles, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, MergedContextConfiguration parentConfig) {
        block4: {
            Annotation annotation;
            Class<? extends Annotation> webAppConfigClass = ContextLoaderUtils.loadWebAppConfigurationClass();
            if (webAppConfigClass != null && (annotation = AnnotationUtils.findAnnotation(testClass, webAppConfigClass)) != null) {
                String resourceBasePath = (String)AnnotationUtils.getValue((Annotation)annotation);
                try {
                    Class webMergedConfigClass = ClassUtils.forName((String)WEB_MERGED_CONTEXT_CONFIGURATION_CLASS_NAME, (ClassLoader)ContextLoaderUtils.class.getClassLoader());
                    Constructor constructor = ClassUtils.getConstructorIfAvailable((Class)webMergedConfigClass, (Class[])new Class[]{Class.class, String[].class, Class[].class, Set.class, String[].class, String.class, ContextLoader.class, CacheAwareContextLoaderDelegate.class, MergedContextConfiguration.class});
                    if (constructor != null) {
                        return (MergedContextConfiguration)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{testClass, locations, classes, initializerClasses, activeProfiles, resourceBasePath, contextLoader, cacheAwareContextLoaderDelegate, parentConfig});
                    }
                }
                catch (Throwable t) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Could not instantiate [org.springframework.test.context.web.WebMergedContextConfiguration].", t);
                }
            }
        }
        return null;
    }
}

