/**
 * An HTMLDocument is the root of the HTML hierarchy and holds the entire content. Besides providing access to the hierarchy, it also provides some convenience methods for accessing certain sets of information from the document.The following properties have been deprecated in favor of the corresponding ones for the BODY element:Note: In DOM Level 2, the method getElementById is inherited from the Document interface where it was moved to.
 */
var HTMLDocument = new Document();
/**
 * Write a string of text followed by a newline character to a document stream opened by open(). Note that the function will produce a document which is not necessarily driven by a DTD and therefore might be produce an invalid result in the context of the document
 * @syntax hTMLDocument.writeln(text)
 * @param {String} text The string to be parsed into some structure in the document structure model.
 * @returns {undefined} 
 */
HTMLDocument.prototype.writeln = function(text) {};

/**
 * The element that contains the content for the document. In documents with BODY contents, returns the BODY element. In frameset documents, this returns the outermost FRAMESET element.
 * @syntax hTMLDocument.body
 * @returns {HTMLElement} 
 */
HTMLDocument.prototype.body = new HTMLElement();

/**
 * With [HTML 4.01] documents, this method returns the (possibly empty) collection of elements whose name value is given by elementName. In [XHTML 1.0] documents, this methods only return the (possibly empty) collection of form controls with matching name. This method is case sensitive.
 * @syntax hTMLDocument.getElementsByName(elementName)
 * @param {String} elementName The name attribute value for an element.
 * @returns {NodeList} The matching elements.
 */
HTMLDocument.prototype.getElementsByName = function(elementName) {};

/**
 * A collection of all the OBJECT elements that include applets and APPLET (deprecated) elements in a document.
 * @syntax hTMLDocument.applets
 * @returns {HTMLCollection} 
 */
HTMLDocument.prototype.applets = new HTMLCollection();

/**
 * A collection of all AREA elements and anchor (A) elements in a document with a value for the href attribute.
 * @syntax hTMLDocument.links
 * @returns {HTMLCollection} 
 */
HTMLDocument.prototype.links = new HTMLCollection();

/**
 * Closes a document stream opened by open() and forces rendering.
 * @syntax hTMLDocument.close()
 * @returns {undefined} 
 */
HTMLDocument.prototype.close = function() {};

/**
 * This mutable string attribute denotes persistent state information that (1) is associated with the current frame or document and (2) is composed of information described by the cookies non-terminal of [IETF RFC 2965], Section 4.2.2. If no persistent state information is available for the current frame or document document, then this property's value is an empty string. When this attribute is read, all cookies are returned as a single string, with each cookie's name-value pair concatenated into a list of name-value pairs, each list item being separated by a ';' (semicolon). When this attribute is set, the value it is set to should be a string that adheres to the cookie non-terminal of [IETF RFC 2965]; that is, it should be a single name-value pair followed by zero or more cookie attribute values. If no domain attribute is specified, then the domain attribute for the new value defaults to the host portion of an absolute URI [IETF RFC 2396] of the current frame or document. If no path attribute is specified, then the path attribute for the new value defaults to the absolute path portion of the URI [IETF RFC 2396] of the current frame or document. If no max-age attribute is specified, then the max-age attribute for the new value defaults to a user agent defined value. If a cookie with the specified name is already associated with the current frame or document, then the new value as well as the new attributes replace the old value and attributes. If a max-age attribute of 0 is specified for the new value, then any existing cookies of the specified name are removed from the cookie storage. Note: See [IETF RFC 2965] for the semantics of persistent state item attribute value pairs. Note: The precise nature of a user agent session is not defined by this specification. Exceptions on setting DOMException SYNTAX_ERR: If the new value does not adhere to the cookie syntax specified by [IETF RFC 2965].
 * @syntax hTMLDocument.cookie
 * @returns {String} 
 */
HTMLDocument.prototype.cookie = new String();

/**
 * Open a document stream for writing. If a document exists in the target, this method clears it. Note: This method and the ones following allow a user to add to or replace the structure model of a document using strings of unparsed HTML. At the time of writing alternate methods for providing similar functionality for both HTML and XML documents were being considered (see [DOM Level 3 Load and Save]).
 * @syntax hTMLDocument.open()
 * @returns {undefined} 
 */
HTMLDocument.prototype.open = function() {};

/**
 * A collection of all the anchor (A) elements in a document with a value for the name attribute. Note: For reasons of backward compatibility, the returned set of anchors only contains those anchors created with the name attribute, not those created with the id attribute. Note that in [XHTML 1.0], the name attribute (see section 4.10) has no semantics and is only present for legacy user agents: the id attribute is used instead. Users should prefer the iterator mechanisms provided by [DOM Level 2 Traversal] instead.
 * @syntax hTMLDocument.anchors
 * @returns {HTMLCollection} 
 */
HTMLDocument.prototype.anchors = new HTMLCollection();

/**
 * Returns the URI [IETF RFC 2396] of the page that linked to this page. The value is an empty string if the user navigated to the page directly (not through a link, but, for example, via a bookmark).
 * @syntax hTMLDocument.referrer
 * @returns {String} 
 */
HTMLDocument.prototype.referrer = new String();

/**
 * The title of a document as specified by the TITLE element in the head of the document.
 * @syntax hTMLDocument.title
 * @returns {String} 
 */
HTMLDocument.prototype.title = new String();

/**
 * The domain name of the server that served the document, or null if the server cannot be identified by a domain name.
 * @syntax hTMLDocument.domain
 * @returns {String} 
 */
HTMLDocument.prototype.domain = new String();

/**
 * Write a string of text to a document stream opened by open(). Note that the function will produce a document which is not necessarily driven by a DTD and therefore might be produce an invalid result in the context of the document.
 * @syntax hTMLDocument.write(text)
 * @param {String} text The string to be parsed into some structure in the document structure model.
 * @returns {undefined} 
 */
HTMLDocument.prototype.write = function(text) {};

/**
 * A collection of all the IMG elements in a document. The behavior is limited to IMG elements for backwards compatibility. Note: As suggested by [HTML 4.01], to include images, authors may use the OBJECT element or the IMG element. Therefore, it is recommended not to use this attribute to find the images in the document but getElementsByTagName with HTML 4.01 or getElementsByTagNameNS with XHTML 1.0.
 * @syntax hTMLDocument.images
 * @returns {HTMLCollection} 
 */
HTMLDocument.prototype.images = new HTMLCollection();

/**
 * The absolute URI [IETF RFC 2396] of the document.
 * @syntax hTMLDocument.URL
 * @returns {String} 
 */
HTMLDocument.prototype.URL = new String();

/**
 * A collection of all the forms of a document.
 * @syntax hTMLDocument.forms
 * @returns {HTMLCollection} 
 */
HTMLDocument.prototype.forms = new HTMLCollection();

/**
 * Represents the HTMLDocument prototype object.
 * @syntax HTMLDocument.prototype
 * @static
 */
HTMLDocument.prototype;

